/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.contextpropagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.concurrent.mp.spi.ThreadContextConfig;
import com.ibm.ws.concurrent.mp.spi.ThreadContextFactory;
import com.ibm.ws.microprofile.contextpropagation.ContextManagerImpl;
import com.ibm.ws.microprofile.contextpropagation.ContextOp;
import com.ibm.ws.microprofile.contextpropagation.ThreadContextConfigImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ThreadContextBuilderImpl
implements ThreadContext.Builder {
    private static final TraceComponent tc = Tr.register(ThreadContextBuilderImpl.class, (String)"concurrent", (String)"com.ibm.ws.microprofile.context.resources.CWWKCMessages");
    static final Set<String> DEFAULT_CLEARED = Collections.singleton("Transaction");
    static final Set<String> DEFAULT_PROPAGATED = Collections.singleton("Remaining");
    static final Set<String> DEFAULT_UNCHANGED = Collections.emptySet();
    private final ContextManagerImpl contextManager;
    private final ArrayList<ThreadContextProvider> contextProviders;
    private Set<String> cleared;
    private String name;
    private Set<String> propagated;
    private Set<String> unchanged;
    static final long serialVersionUID = -4094244676144049098L;

    ThreadContextBuilderImpl(ContextManagerImpl contextManager, ArrayList<ThreadContextProvider> contextProviders) {
        this.contextManager = contextManager;
        this.contextProviders = contextProviders;
    }

    public ThreadContext build() {
        String appName;
        ContextOp remaining;
        Set<String> cleared = this.cleared == null ? this.contextManager.getDefault("mp.context.ThreadContext.cleared", DEFAULT_CLEARED) : this.cleared;
        Set<String> propagated = this.propagated == null ? this.contextManager.getDefault("mp.context.ThreadContext.propagated", DEFAULT_PROPAGATED) : this.propagated;
        Set<String> unchanged = this.unchanged == null ? this.contextManager.getDefault("mp.context.ThreadContext.unchanged", DEFAULT_UNCHANGED) : this.unchanged;
        HashSet<String> unknown = new HashSet<String>(cleared);
        unknown.addAll(propagated);
        if (unknown.size() < cleared.size() + propagated.size() || !Collections.disjoint(unknown, unchanged)) {
            this.failOnOverlapOfClearedPropagatedUnchanged(cleared, propagated, unchanged);
        }
        if (unknown.remove("Remaining")) {
            ContextOp contextOp = propagated.contains("Remaining") ? ContextOp.PROPAGATED : (remaining = cleared.contains("Remaining") ? ContextOp.CLEARED : null);
            if (remaining == null) {
                throw new ConcurrentModificationException();
            }
        } else {
            remaining = unchanged.contains("Remaining") ? ContextOp.UNCHANGED : ContextOp.CLEARED;
        }
        ThreadContextConfigImpl configPerProvider = new ThreadContextConfigImpl(this.contextManager.cmProvider);
        for (ThreadContextProvider provider : this.contextProviders) {
            String contextType = provider.getThreadContextType();
            unknown.remove(contextType);
            ContextOp op = "EmptyHandleList".contentEquals(contextType) ? ContextOp.CLEARED : (propagated.contains(contextType) ? ContextOp.PROPAGATED : (cleared.contains(contextType) ? ContextOp.CLEARED : (unchanged.contains(contextType) ? ContextOp.UNCHANGED : remaining)));
            if (op == ContextOp.UNCHANGED) continue;
            configPerProvider.put(provider, op);
        }
        if (unknown.size() > 0) {
            ThreadContextBuilderImpl.failOnUnknownContextTypes(unknown, this.contextProviders);
        }
        int hash = ContextManagerImpl.instanceCount.incrementAndGet();
        StringBuilder nameBuilder = new StringBuilder("ThreadContext@").append(Integer.toHexString(hash));
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        String string = appName = cData == null ? null : cData.getJ2EEName().getApplication();
        if (appName != null) {
            nameBuilder.append('_').append(appName);
        }
        if (this.name != null) {
            nameBuilder.append('_').append(this.name);
        }
        nameBuilder.append("(propagated=").append(propagated);
        nameBuilder.append(",cleared=").append(cleared);
        nameBuilder.append(",unchanged=").append(unchanged);
        nameBuilder.append(')');
        String threadContextName = nameBuilder.toString();
        return ThreadContextFactory.createThreadContext((String)threadContextName, (int)hash, (ThreadContextConfig)configPerProvider);
    }

    public ThreadContext.Builder cleared(String ... types) {
        if (this.cleared == null) {
            this.cleared = new HashSet<String>();
        } else {
            this.cleared.clear();
        }
        Collections.addAll(this.cleared, types);
        return this;
    }

    private void failOnOverlapOfClearedPropagatedUnchanged(Set<String> cleared, Set<String> propagated, Set<String> unchanged) {
        HashSet<String> overlap = new HashSet<String>(cleared);
        overlap.retainAll(propagated);
        HashSet<String> s = new HashSet<String>(cleared);
        s.retainAll(unchanged);
        overlap.addAll(s);
        s = new HashSet<String>(propagated);
        s.retainAll(unchanged);
        overlap.addAll(s);
        if (overlap.isEmpty()) {
            throw new ConcurrentModificationException();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1152.context.lists.overlap", (Object[])new Object[]{overlap}));
    }

    static void failOnUnknownContextTypes(HashSet<String> unknown, ArrayList<ThreadContextProvider> contextProviders) {
        TreeSet<String> known = new TreeSet<String>();
        known.addAll(Arrays.asList("Remaining", "Application", "CDI", "Security", "Transaction"));
        for (ThreadContextProvider provider : contextProviders) {
            String contextType = provider.getThreadContextType();
            known.add(contextType);
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1155.unknown.context", (Object[])new Object[]{new TreeSet<String>(unknown), known}));
    }

    public ThreadContext.Builder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadContext.Builder propagated(String ... types) {
        if (this.propagated == null) {
            this.propagated = new HashSet<String>();
        } else {
            this.propagated.clear();
        }
        Collections.addAll(this.propagated, types);
        return this;
    }

    public ThreadContext.Builder unchanged(String ... types) {
        if (this.unchanged == null) {
            this.unchanged = new HashSet<String>();
        } else {
            this.unchanged.clear();
        }
        Collections.addAll(this.unchanged, types);
        return this;
    }
}

