/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.crypto;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HashUtils {
    private static final TraceComponent tc = Tr.register(HashUtils.class, (String)"SecurityCommon", (String)"com.ibm.ws.security.common.internal.resources.SSOCommonMessages");
    private static String DEFAULT_ALGORITHM = "SHA-256";
    private static String DEFAULT_CHARSET = "UTF-8";
    static final long serialVersionUID = -6124985628319901423L;

    @Sensitive
    public static String digest(@Sensitive String input) {
        return HashUtils.digest(input, DEFAULT_ALGORITHM);
    }

    @Sensitive
    protected static String digest(@Sensitive String input, String algorithm) {
        return HashUtils.digest(input, algorithm, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    @Sensitive
    protected static String digest(@Sensitive String input, String algorithm, String charset) {
        String output = null;
        if (input != null && input.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(input.getBytes(charset));
                output = Base64Coder.toString(Base64Coder.base64Encode(md.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void nsae;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = algorithm;
                objectArray[2] = charset;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.common.crypto.HashUtils", (String)"60", null, (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception instanciating MessageDigest. The algorithm is " + algorithm + nsae), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception instanciating MessageDigest : " + nsae);
            }
            catch (UnsupportedEncodingException nsae) {
                void uee;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = algorithm;
                objectArray[2] = charset;
                FFDCFilter.processException((Throwable)nsae, (String)"com.ibm.ws.security.common.crypto.HashUtils", (String)"65", null, (Object[])objectArray);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception converting String object : " + uee), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception converting String object : " + uee);
            }
        }
        return output;
    }
}

