/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.execution.impl;

import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.persistence.jpa.RemotableSplitFlowKey;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.util.SplitFlowConfig;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RuntimeSplitFlowExecution
extends RuntimeWorkUnitExecution {
    private static final String sourceClass = RuntimeSplitFlowExecution.class.getName();
    protected static final Logger logger = Logger.getLogger(sourceClass);
    private final String splitName;
    private final String flowName;
    private Date createTime;
    private Date startTime;
    private Date endTime;
    private ExecutionStatus flowStatus;
    static final long serialVersionUID = -5706250345640937093L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RuntimeSplitFlowExecution(SplitFlowConfig splitFlowConfig, ModelNavigator<JSLJob> navigator) {
        super(navigator, splitFlowConfig.getTopLevelNameInstanceExecutionInfo());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "<init>", new Object[]{splitFlowConfig, navigator});
        }
        this.createTime = null;
        this.startTime = null;
        this.endTime = null;
        this.splitName = splitFlowConfig.getSplitName();
        this.flowName = splitFlowConfig.getFlowName();
        this.correlationId = splitFlowConfig.getCorrelationId();
        this.type = WorkUnitDescriptor.WorkUnitType.SPLIT_FLOW;
        this.createTime = new Date();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus getFlowStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getFlowStatus", new Object[0]);
        }
        ExecutionStatus executionStatus = this.flowStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getFlowStatus", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setFlowStatus(ExecutionStatus flowStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "setFlowStatus", new Object[]{flowStatus});
        }
        this.flowStatus = flowStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "setFlowStatus");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Logger getClassNameLogger() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getClassNameLogger", new Object[0]);
        }
        Logger logger = RuntimeSplitFlowExecution.logger;
        if (RuntimeSplitFlowExecution.logger != null && RuntimeSplitFlowExecution.logger.isLoggable(Level.FINER)) {
            logger = logger;
            RuntimeSplitFlowExecution.logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getClassNameLogger", logger);
        }
        return logger;
    }

    @Override
    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String getExecutionLogMessage(RuntimeWorkUnitExecution.MessageType msgType) {
        RuntimeWorkUnitExecution.LogHelper lh = new RuntimeWorkUnitExecution.LogHelper(this);
        StringBuilder buf = lh.getBeginningPart(msgType);
        buf.append("invoking execution for a split-flow");
        buf.append("\n Split-Flow split name = ");
        buf.append(this.splitName);
        buf.append("\n Split-Flow flow name =");
        buf.append(this.flowName);
        buf.append("\n Associated Top-level JobInstance id= ");
        buf.append(this.getTopLevelInstanceId());
        buf.append("\n Associated Top-level JobExecution id = ");
        buf.append(this.getTopLevelExecutionId());
        buf.append("\n Associated Top-level Job Name = ");
        buf.append(this.getTopLevelJobName());
        if (!msgType.equals((Object)RuntimeWorkUnitExecution.MessageType.STARTED)) {
            buf.append("\n Job Batch Status = " + this.getBatchStatus());
            buf.append(", Job Exit Status = " + this.getExitStatus());
        }
        buf.append("\n==========================================================\n");
        return buf.toString();
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getSplitName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getSplitName", new Object[0]);
        }
        String string = this.splitName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getSplitName", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getFlowName() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getFlowName", new Object[0]);
        }
        String string = this.flowName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getFlowName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getCreateTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getCreateTime", new Object[0]);
        }
        Date date = this.createTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getCreateTime", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getStartTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getStartTime", new Object[0]);
        }
        Date date = this.startTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getStartTime", date);
        }
        return date;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Date getEndTime() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getEndTime", new Object[0]);
        }
        Date date = this.endTime;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            date = date;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "getEndTime", date);
        }
        return date;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStarted(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workStarted", new Object[]{date});
        }
        this.startTime = date;
        this.batchStatus = BatchStatus.STARTED;
        this.getPersistenceManagerService().updateSplitFlowExecution(this, this.batchStatus, date);
        this.publishStartedEvent();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workStarted");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workStopping(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workStopping", new Object[]{date});
        }
        this.batchStatus = BatchStatus.STOPPING;
        this.getPersistenceManagerService().updateSplitFlowExecution(this, this.batchStatus, date);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workStopping");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void workEnded(Date date) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workEnded", new Object[]{date});
        }
        this.endTime = date;
        this.getPersistenceManagerService().updateSplitFlowExecution(this, this.batchStatus, date);
        this.publishEndedEvent();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "workEnded");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateExecutionJobLogDir(String logDirPath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "updateExecutionJobLogDir", new Object[]{logDirPath});
        }
        RemotableSplitFlowKey key = new RemotableSplitFlowKey(this.getTopLevelExecutionId(), this.flowName);
        this.getPersistenceManagerService().updateSplitFlowExecutionLogDir(key, logDirPath);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "updateExecutionJobLogDir");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishStartedEvent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "publishStartedEvent", new Object[0]);
        }
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        if (publisher != null) {
            publisher.publishSplitFlowEvent(this.getSplitName(), this.getFlowName(), this.getTopLevelInstanceId(), this.getTopLevelExecutionId(), "batch/jobs/execution/split-flow/started", this.correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "publishStartedEvent");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void publishEndedEvent() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "publishEndedEvent", new Object[0]);
        }
        BatchEventsPublisher publisher = this.getBatchEventsPublisher();
        if (publisher != null) {
            publisher.publishSplitFlowEvent(this.getSplitName(), this.getFlowName(), this.getTopLevelInstanceId(), this.getTopLevelExecutionId(), "batch/jobs/execution/split-flow/ended", this.correlationId);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "publishEndedEvent");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isRemotePartitionDispatch() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "isRemotePartitionDispatch", new Object[0]);
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution", "isRemotePartitionDispatch", bl);
        }
        return bl;
    }
}

