/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.ra.inbound.impl.SibRaXaResource;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

class SibRaTransactionalDispatcher
extends SibRaDispatcher {
    private SIXAResource _xaResource;
    private SibRaXaResource _sibXaResource;
    private final String _busName;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaTransactionalDispatcher.class);
    private static TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String CLASS_NAME = SibRaTransactionalDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";

    protected SibRaTransactionalDispatcher(SibRaMessagingEngineConnection connection, AbstractConsumerSession session, SibRaEndpointActivation endpointActivation, String busName, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        super(connection, session, endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold);
        String methodName = "SibRaTransactionalDispatcher";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaTransactionalDispatcher", (Object)new Object[]{connection, session, endpointActivation, busName});
        }
        this._busName = busName;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaTransactionalDispatcher");
        }
    }

    @Override
    protected SITransaction getTransaction() throws ResourceException {
        String methodName = "getTransaction";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getTransaction");
        }
        SIXAResource transaction = this.getXaResource();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getTransaction", (Object)transaction);
        }
        return transaction;
    }

    private SIXAResource getXaResource() throws ResourceException {
        String methodName = "getXaResource";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXaResource");
        }
        if (this._xaResource == null) {
            try {
                this._xaResource = this._connection.getSIXAResource();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getXaResource"), (String)FFDC_PROBE_1, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_EXCEPTION_CWSIV0650", new Object[]{exception, this._connection}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getXaResource"), (String)FFDC_PROBE_3, (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_EXCEPTION_CWSIV0650", new Object[]{exception, this._connection}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getXaResource", (Object)this._xaResource);
        }
        return this._xaResource;
    }

    @Override
    protected MessageEndpoint createEndpoint() throws ResourceException {
        String methodName = "createEndpoint";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createEndpoint");
        }
        if (!this._endpointConfiguration.getTargetSignificance().equals("Required") || !this._endpointConfiguration.getTargetType().equals("ME")) {
            String p1;
            String p0;
            if (!this._endpointConfiguration.getTargetSignificance().equals("Required")) {
                p0 = "targetSignificance";
                p1 = "Required";
            } else if (!this._endpointConfiguration.getTargetType().equals("ME")) {
                p0 = "targetType";
                p1 = "ME";
            } else {
                p0 = "targetGroup";
                p1 = "!null";
            }
            SibTr.error((TraceComponent)TRACE, (String)"ME_NAME_REQUIRED_CWSIV0652", (Object)new Object[]{p0, p1});
            throw new NotSupportedException(NLS.getFormattedMessage("ME_NAME_REQUIRED_CWSIV0652", new Object[]{p0, p1}, null));
        }
        this._sibXaResource = new SibRaXaResource(this.getXaResource());
        MessageEndpoint endpoint = this._endpointFactory.createEndpoint((XAResource)((Object)this._sibXaResource));
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createEndpoint", (Object)endpoint);
        }
        return endpoint;
    }

    @Override
    protected void beforeDelivery(MessageEndpoint endpoint) throws ResourceException {
        String methodName = "beforeDelivery";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
        try {
            endpoint.beforeDelivery(this._invoker.getEndpointMethod());
        }
        catch (NoSuchMethodException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_2, (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("BEFORE_DELIVERY_CWSIV0651", new Object[]{exception, endpoint}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    @Override
    protected void beforeDelivery(SIBusMessage message, MessageEndpoint endpoint) throws ResourceException {
        String methodName = "beforeDelivery";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery", (Object)message);
        }
        this.beforeDelivery(endpoint);
        try {
            if (this._xaResource != null && this._xaResource.isEnlisted()) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Deleting the message under the xa transaction (Message=" + message + ") (xaResource=" + this._xaResource));
                }
                this.deleteMessage(message, (SITransaction)this._xaResource);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("xaResource is either null or is not enlisted so deleting the message non transactional (auto commit) (Message=" + message + ")"));
                }
                this.deleteMessage(message, null);
            }
        }
        catch (ResourceException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "beforeDelivery"), (String)FFDC_PROBE_4, (Object)this);
            endpoint.afterDelivery();
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"beforeDelivery");
        }
    }

    @Override
    protected SIBusMessage readMessage(SIMessageHandle handle) throws ResourceException, SIMessageNotLockedException {
        String methodName = "readMessage";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"readMessage", (Object)handle);
        }
        SIBusMessage message = null;
        if (this._xaResource != null && this._xaResource.isEnlisted()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Deleting the message under the xa transaction (Handle=" + handle + ") (xaResource=" + this._xaResource + ")"));
            }
            message = this.readAndDeleteMessage(handle, (SITransaction)this._xaResource);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("xaResource is either null or is not enlisted so deleting the message non transactional (auto commit) (Handle=" + handle + ")"));
            }
            message = this.readAndDeleteMessage(handle, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"readMessage", (Object)message);
        }
        return message;
    }

    @Override
    protected void afterDelivery(SIBusMessage message, MessageEndpoint endpoint, boolean success) throws ResourceException {
        String methodName = "afterDelivery";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{message, success});
        }
        endpoint.afterDelivery();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    @Override
    protected void cleanup() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            String methodName = "cleanup";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        generator.addField("sibXaResource", this._sibXaResource);
        generator.addField("xaResource", this._xaResource);
        return generator;
    }

    @Override
    protected boolean isTransactionRolledBack() {
        return this._sibXaResource.isTransactionRolledBack();
    }
}

