/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.attributes;

import com.ibm.oauth.core.api.attributes.Attribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class AttributeList {
    List<Attribute> _attributes = new ArrayList<Attribute>();

    public String getAttributeValueByNameAndType(String name, String type) {
        String result = null;
        ListIterator<Attribute> li = this._attributes.listIterator();
        boolean found = false;
        while (li.hasNext() && !found) {
            Attribute a = li.next();
            if (!this.stringsEqual(name, a.getName()) || !this.stringsEqual(type, a.getType())) continue;
            result = a.getValue();
            found = true;
        }
        return result;
    }

    public String getAttributeValueByName(String name) {
        String result = null;
        ListIterator<Attribute> li = this._attributes.listIterator();
        boolean found = false;
        while (li.hasNext() && !found) {
            Attribute a = li.next();
            if (!this.stringsEqual(name, a.getName())) continue;
            result = a.getValue();
            found = true;
        }
        return result;
    }

    public String[] getAttributeValuesByNameAndType(String name, String type) {
        List<String> vals;
        String[] result = null;
        Attribute a = this.getAttributeByNameAndType(name, type);
        if (a != null && (vals = a.getValues()) != null && vals.size() > 0) {
            result = new String[vals.size()];
            for (int i = 0; i < vals.size(); ++i) {
                result[i] = vals.get(i);
            }
        }
        return result;
    }

    public String[] getAttributeValuesByName(String name) {
        String[] result = null;
        ListIterator<Attribute> li = this._attributes.listIterator();
        boolean found = false;
        while (li.hasNext() && !found) {
            Attribute a = li.next();
            if (!this.stringsEqual(name, a.getName())) continue;
            List<String> vals = a.getValues();
            if (vals != null && vals.size() > 0) {
                result = new String[vals.size()];
                for (int i = 0; i < vals.size(); ++i) {
                    result[i] = vals.get(i);
                }
            }
            found = true;
        }
        return result;
    }

    public void setAttribute(String name, String type, String[] values) {
        ListIterator<Attribute> li = this._attributes.listIterator();
        Attribute existingAttribute = null;
        boolean found = false;
        while (li.hasNext() && !found) {
            Attribute a = li.next();
            if (!this.stringsEqual(name, a.getName()) || !this.stringsEqual(type, a.getType())) continue;
            existingAttribute = a;
            found = true;
        }
        if (found) {
            existingAttribute.setValues(values);
        } else {
            Attribute newAttribute = new Attribute(name, type, values);
            this._attributes.add(newAttribute);
        }
    }

    public Attribute getAttributeByNameAndType(String name, String type) {
        Attribute result = null;
        ListIterator<Attribute> li = this._attributes.listIterator();
        boolean found = false;
        while (li.hasNext() && !found) {
            Attribute a = li.next();
            if (!this.stringsEqual(name, a.getName()) || !this.stringsEqual(type, a.getType())) continue;
            result = a;
            found = true;
        }
        return result;
    }

    public Attribute[] getAttributesByType(String type) {
        Attribute[] result = null;
        ArrayList<Attribute> l = new ArrayList<Attribute>();
        ListIterator<Attribute> li = this._attributes.listIterator();
        while (li.hasNext()) {
            Attribute a = li.next();
            if (!this.stringsEqual(type, a.getType())) continue;
            l.add(a);
        }
        if (l.size() > 0) {
            result = new Attribute[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                result[i] = (Attribute)l.get(i);
            }
        }
        return result;
    }

    public List<Attribute> getAllAttributes() {
        return Collections.unmodifiableList(this._attributes);
    }

    boolean stringsEqual(String s1, String s2) {
        boolean result = false;
        if (s1 == null && s2 == null || s1 != null && s2 != null && s1.equals(s2)) {
            result = true;
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        ListIterator<Attribute> li = this._attributes.listIterator();
        while (li.hasNext()) {
            sb.append(li.next());
            if (!li.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }
}

