/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.translator.compiler.JDTCompilerFactory;
import com.ibm.ws.jsp.translator.compiler.JspCompilerFactoryImpl;
import com.ibm.ws.jsp.translator.resource.JspResourcesFactoryImpl;
import com.ibm.ws.webcontainer.util.DocumentRootUtils;
import com.ibm.wsspi.jsp.compiler.JspCompilerFactory;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.context.translation.JspTranslationEnvironment;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import com.ibm.wsspi.jsp.resource.translation.JspResourcesFactory;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class FileBasedJspContext
implements JspTranslationContext {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.tools.FileBasedJspContext";
    private String docRoot;
    private boolean searchClasspathForResources;
    private DocumentRootUtils dru;
    private URL contextURL;
    private JspResourcesFactory jspResourcesFactory;
    private JspInputSourceFactory jspInputSourceFactory;
    private JspClassloaderContext jspClassloaderContext;
    private JspCompilerFactory jspCompilerFactory;
    static final long serialVersionUID = -4272013587155786911L;

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IServletContext getServletContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletContext", new Object[0]);
        }
        IServletContext iServletContext = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iServletContext = iServletContext;
            logger.exiting(CLASS_NAME, "getServletContext", iServletContext);
        }
        return iServletContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public FileBasedJspContext(String docRoot, JspOptions jspOptions, String extDocRoot, String preFragExtDocRoot, ClassLoader loader, JspClassloaderContext jspClassloaderContext, boolean searchClasspathForResources) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{docRoot, jspOptions, extDocRoot, preFragExtDocRoot, loader, jspClassloaderContext, searchClasspathForResources});
        }
        this.docRoot = "";
        this.searchClasspathForResources = false;
        this.contextURL = null;
        this.jspResourcesFactory = null;
        this.jspInputSourceFactory = null;
        this.jspClassloaderContext = null;
        this.jspCompilerFactory = null;
        this.docRoot = docRoot;
        this.searchClasspathForResources = searchClasspathForResources;
        File baseDir = new File(docRoot);
        baseDir = baseDir.getParentFile();
        this.dru = new DocumentRootUtils(baseDir.toString(), extDocRoot, preFragExtDocRoot);
        try {
            this.contextURL = new URL("file", null, this.getRealPath("/"));
        }
        catch (MalformedURLException e) {
            logger.logp(Level.WARNING, CLASS_NAME, "FileBasedJspContext", "Failed to create context URL for docRoot: " + docRoot, e);
        }
        this.jspResourcesFactory = new JspResourcesFactoryImpl(jspOptions, this, null);
        this.jspInputSourceFactory = new JspInputSourceFactoryImpl(docRoot, this.contextURL, this.dru, this.searchClasspathForResources, null, loader);
        this.jspClassloaderContext = jspClassloaderContext;
        this.jspCompilerFactory = jspOptions.isUseJDKCompiler() ? new JspCompilerFactoryImpl(this.getRealPath("/"), jspClassloaderContext, jspOptions) : new JDTCompilerFactory(jspClassloaderContext.getClassLoader(), jspOptions);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRealPath(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealPath", new Object[]{path});
        }
        String string = this.getRealPath(path, true);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRealPath", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long getRealTimeStamp(String path) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealTimeStamp", new Object[]{path});
        }
        File f = new File(this.getRealPath(path));
        long l = f.lastModified();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting(CLASS_NAME, "getRealTimeStamp", l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRealPath(String path, boolean checkExtDocRoot) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getRealPath", new Object[]{path, checkExtDocRoot});
        }
        String realPath = "";
        realPath = path.startsWith("/") ? this.docRoot + path : this.docRoot + "/" + path;
        if (checkExtDocRoot && !new File(realPath).exists() && this.dru != null && this.dru.searchPathExists()) {
            try {
                DocumentRootUtils documentRootUtils = this.dru;
                synchronized (documentRootUtils) {
                    this.dru.handleDocumentRoots(path);
                    realPath = this.dru.getFilePath();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = realPath;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getRealPath", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String path, boolean SearchMetsInfResources) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{path, SearchMetsInfResources});
        }
        Set set = this.getResourcePaths(path);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting(CLASS_NAME, "getResourcePaths", set);
        }
        return set;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set getResourcePaths(String path) {
        File[] fileList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getResourcePaths", new Object[]{path});
        }
        HashSet<String> set = new HashSet<String>();
        File root = new File(this.docRoot + path);
        if (root.exists() && (fileList = root.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                String resourcePath = fileList[i].getPath();
                resourcePath = resourcePath.substring(this.docRoot.length());
                resourcePath = resourcePath.replace('\\', '/');
                if (fileList[i].isDirectory() && !resourcePath.endsWith("/")) {
                    resourcePath = resourcePath + "/";
                }
                set.add(resourcePath);
            }
        }
        HashSet<String> hashSet = set;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            logger.exiting(CLASS_NAME, "getResourcePaths", hashSet);
        }
        return hashSet;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspResourcesFactory getJspResourcesFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspResourcesFactory", new Object[0]);
        }
        JspResourcesFactory jspResourcesFactory = this.jspResourcesFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspResourcesFactory = jspResourcesFactory;
            logger.exiting(CLASS_NAME, "getJspResourcesFactory", jspResourcesFactory);
        }
        return jspResourcesFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspInputSourceFactory getJspInputSourceFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspInputSourceFactory", new Object[0]);
        }
        JspInputSourceFactory jspInputSourceFactory = this.jspInputSourceFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspInputSourceFactory = jspInputSourceFactory;
            logger.exiting(CLASS_NAME, "getJspInputSourceFactory", jspInputSourceFactory);
        }
        return jspInputSourceFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspClassloaderContext getJspClassloaderContext() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspClassloaderContext", new Object[0]);
        }
        JspClassloaderContext jspClassloaderContext = this.jspClassloaderContext;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspClassloaderContext = jspClassloaderContext;
            logger.exiting(CLASS_NAME, "getJspClassloaderContext", jspClassloaderContext);
        }
        return jspClassloaderContext;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerFactory getJspCompilerFactory() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspCompilerFactory", new Object[0]);
        }
        JspCompilerFactory jspCompilerFactory = this.jspCompilerFactory;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerFactory = jspCompilerFactory;
            logger.exiting(CLASS_NAME, "getJspCompilerFactory", jspCompilerFactory);
        }
        return jspCompilerFactory;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJspTranslationEnviroment(JspTranslationEnvironment jspEnvironment) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setJspTranslationEnviroment", new Object[]{jspEnvironment});
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setJspTranslationEnviroment");
        }
    }
}

