/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import io.openliberty.grpc.internal.monitor.GrpcClientStatsMonitor;
import io.openliberty.grpc.internal.monitor.GrpcMethod;
import java.time.Clock;
import java.time.Instant;

public class GrpcMonitoringClientCallListener<RespT>
extends ForwardingClientCallListener<RespT> {
    private final ClientCall.Listener<RespT> delegate;
    private final GrpcClientStatsMonitor clientMetrics;
    private final GrpcMethod grpcMethod;
    private final Clock clock;
    private final Instant startInstant;

    GrpcMonitoringClientCallListener(ClientCall.Listener<RespT> delegate, GrpcClientStatsMonitor clientMetrics, GrpcMethod grpcMethod, Clock clock) {
        this.delegate = delegate;
        this.clientMetrics = clientMetrics;
        this.grpcMethod = grpcMethod;
        this.clock = clock;
        this.startInstant = clock.instant();
    }

    protected ClientCall.Listener<RespT> delegate() {
        return this.delegate;
    }

    public void onClose(Status status, Metadata metadata) {
        long latencyMs = this.clock.millis() - this.startInstant.toEpochMilli();
        this.clientMetrics.recordLatency(latencyMs);
        this.clientMetrics.recordClientHandled();
        super.onClose(status, metadata);
    }

    public void onMessage(RespT responseMessage) {
        if (this.grpcMethod.clientSendsOneMessage()) {
            this.clientMetrics.recordMsgReceived();
        }
        super.onMessage(responseMessage);
    }
}

