/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.Utils;
import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import com.ibm.ws.recoverylog.spi.PeerLeaseTable;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.AccessController;
import java.security.PrivilegedAction;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FileSharedServerLeaseLog
implements SharedServerLeaseLog {
    static String _tranRecoveryLogDirStem;
    static String _localRecoveryIdentity;
    static File _leaseLogDirectory;
    static File _serverInstallLeaseLogDir;
    boolean leaseLogWrittenInThisRun;
    static File _controlFile;
    private int _leaseTimeout;
    LeaseLock _peerLeaseLock;
    LeaseLock _localLeaseLock;
    private static final FileSharedServerLeaseLog _fileLeaseLog;
    private static final TraceComponent tc;
    static final long serialVersionUID = 8277349485136205702L;
    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

    public static FileSharedServerLeaseLog getFileSharedServerLeaseLog(String logDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object)new Object[]{logDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (_serverInstallLeaseLogDir == null) {
            FileSharedServerLeaseLog.setLeaseLog(logDirStem, localRecoveryIdentity, recoveryGroup);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFileSharedServerLeaseLog", (Object)_fileLeaseLog);
        }
        return _fileLeaseLog;
    }

    /*
     * WARNING - void declaration
     */
    private static void setLeaseLog(String tranRecoveryLogDirStem, String localRecoveryIdentity, String recoveryGroup) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setLeaseLog", (Object)new Object[]{tranRecoveryLogDirStem, localRecoveryIdentity, recoveryGroup});
        }
        if (recoveryGroup == null) {
            recoveryGroup = "defaultGroup";
        }
        try {
            File leasesDir = new File(tranRecoveryLogDirStem).getParentFile();
            _serverInstallLeaseLogDir = leasesDir.getCanonicalPath().equals(new File(System.getenv("WLP_USER_DIR") + File.separator + "servers" + File.separator + ConfigurationProviderManager.getConfigurationProvider().getServerName()).getCanonicalPath()) || localRecoveryIdentity == null || localRecoveryIdentity.trim().isEmpty() ? new File(System.getenv("WLP_USER_DIR") + File.separator + "shared" + File.separator + "leases" + File.separator + recoveryGroup) : new File(leasesDir.getCanonicalPath() + File.separator + "leases" + File.separator + recoveryGroup);
        }
        catch (IOException leasesDir) {
            void e;
            FFDCFilter.processException((Throwable)leasesDir, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"141", null, (Object[])new Object[]{tranRecoveryLogDirStem, localRecoveryIdentity, recoveryGroup});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog.setLeaseLog", (String)"139");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("_serverInstallLeaseLogDir: " + _serverInstallLeaseLogDir.getAbsolutePath()));
        }
        if (tranRecoveryLogDirStem != null) {
            _tranRecoveryLogDirStem = tranRecoveryLogDirStem;
            if (_leaseLogDirectory == null) {
                _leaseLogDirectory = _serverInstallLeaseLogDir;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Have instatiated directory: " + _leaseLogDirectory.getAbsolutePath()));
                }
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 3085797037830036996L;
                    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Void run() {
                        block9: {
                            if (_leaseLogDirectory.exists()) {
                                if (_leaseLogDirectory.isDirectory()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Lease log directory is in place as expected, instantiate control file");
                                    }
                                    _controlFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + "control");
                                }
                            } else {
                                try {
                                    _controlFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + "control");
                                    if (_leaseLogDirectory.mkdirs()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Lease log directory has been created");
                                        }
                                        if (_controlFile.createNewFile() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("Control has been created: " + _controlFile.getAbsolutePath()));
                                        }
                                    }
                                }
                                catch (IOException iOException) {
                                    void e;
                                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", (String)"178", (Object)this, (Object[])new Object[0]);
                                    if (!tc.isDebugEnabled()) break block9;
                                    Tr.debug((TraceComponent)tc, (String)("Caught an IOException: " + e));
                                }
                            }
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$1", 1.class, null, null);
                    }
                });
            }
        }
        _localRecoveryIdentity = localRecoveryIdentity;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setLeaseLog");
        }
    }

    @Override
    public void updateServerLease(String recoveryIdentity, String recoveryGroup, boolean isServerStartup) throws Exception {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"updateServerLease", (Object)new Object[]{recoveryIdentity, recoveryGroup, isServerStartup, this});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Using recoveryIdentity " + recoveryIdentity + " and log directory " + _tranRecoveryLogDirStem));
            }
            try {
                if (recoveryIdentity.equals(_localRecoveryIdentity)) {
                    boolean success;
                    block13: {
                        if (this._localLeaseLock == null) break block12;
                        if (!this.leaseLogWrittenInThisRun) {
                            try {
                                ByteBuffer byteBuffer = null;
                                FileChannel fChannel = this._localLeaseLock.getFileChannel();
                                byteBuffer = ByteBuffer.wrap(_tranRecoveryLogDirStem.getBytes());
                                fChannel.write(byteBuffer);
                                fChannel.force(false);
                                this.leaseLogWrittenInThisRun = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Have written \"" + byteBuffer.toString() + "\" to lease file"));
                                }
                            }
                            catch (IOException byteBuffer) {
                                FFDCFilter.processException((Throwable)byteBuffer, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"228", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                                if (!tc.isDebugEnabled()) break block13;
                                Tr.debug((TraceComponent)tc, (String)"Caught I/O exception when trying to write to file");
                            }
                        }
                    }
                    final File leaseFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + recoveryIdentity);
                    if (this.leaseLogWrittenInThisRun && !(success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                        static final long serialVersionUID = 8219157404829751789L;
                        private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                        @Override
                        public Boolean run() {
                            return leaseFile.setLastModified(System.currentTimeMillis());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$2", 2.class, null, null);
                        }
                    }).booleanValue()) && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unable to set the last modification time for " + leaseFile));
                    }
                    break block12;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Don't modify time as this is not the local server");
                }
            }
            catch (OverlappingFileLockException leaseFile) {
                FFDCFilter.processException((Throwable)leaseFile, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"253", (Object)this, (Object[])new Object[]{recoveryIdentity, recoveryGroup, isServerStartup});
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"The file aleady appears to be locked in another thread");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateServerLease", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteServerLease(final String recoveryIdentity) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteServerLease", (Object)new Object[]{recoveryIdentity, this});
        }
        final File leaseFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + recoveryIdentity);
        FileLock lock = null;
        FileChannel channel = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){
            static final long serialVersionUID = 4366605646950838579L;
            private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

            @Override
            public FileChannel run() {
                FileChannel theChannel = null;
                try {
                    theChannel = new RandomAccessFile(_controlFile, "rw").getChannel();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", (String)"285", (Object)this, (Object[])new Object[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Caught FileNotFound exception when trying to lock control file");
                    }
                    theChannel = null;
                }
                return theChannel;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$3", 3.class, null, null);
            }
        });
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Block until we acquire the lock on the control file");
            }
            if ((lock = channel.lock()) != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = 3133088653052075048L;
                    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Void run() {
                        block12: {
                            boolean success = false;
                            try {
                                boolean attemptDelete = true;
                                if (!recoveryIdentity.equals(_localRecoveryIdentity)) {
                                    PeerLeaseData pld;
                                    long leaseTime = leaseFile.lastModified();
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("recoveryId: " + recoveryIdentity + ", leaseTime: " + Utils.traceTime((long)leaseTime)));
                                    }
                                    if (!(pld = new PeerLeaseData(recoveryIdentity, leaseTime, FileSharedServerLeaseLog.this._leaseTimeout)).isExpired()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, do not attempt deletion");
                                        }
                                        attemptDelete = false;
                                    }
                                }
                                if (attemptDelete) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("Attempt to delete file " + leaseFile.getName() + ", in dir " + _serverInstallLeaseLogDir));
                                    }
                                    if (success = leaseFile.delete()) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"Successfully deleted lease file");
                                        }
                                    } else if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Failed to delete lease file");
                                    }
                                }
                            }
                            catch (SecurityException attemptDelete) {
                                void se;
                                FFDCFilter.processException((Throwable)attemptDelete, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$4", (String)"339", (Object)this, (Object[])new Object[0]);
                                if (!tc.isDebugEnabled()) break block12;
                                Tr.debug((TraceComponent)tc, (String)("Caught SecurityException " + se));
                            }
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$4", 4.class, null, null);
                    }
                });
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            FFDCFilter.processException((Throwable)overlappingFileLockException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"348", (Object)this, (Object[])new Object[]{recoveryIdentity});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The control file aleady appears to be locked in another thread");
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"352", (Object)this, (Object[])new Object[]{recoveryIdentity});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught an IOException");
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            channel.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteServerLease", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean claimPeerLeaseForRecovery(String recoveryIdentityToRecover, String myRecoveryIdentity, LeaseInfo leaseInfo) throws Exception {
        boolean claimedLease;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, this});
            }
            claimedLease = false;
            FileChannel fChannel = null;
            try {
                boolean attemptClaim = true;
                final File leaseFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + recoveryIdentityToRecover);
                long newleaseTime = AccessController.doPrivileged(new PrivilegedAction<Long>(){
                    static final long serialVersionUID = 6307420776197084944L;
                    private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                    @Override
                    public Long run() {
                        return leaseFile.lastModified();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$5", 5.class, null, null);
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("recoveryId: " + recoveryIdentityToRecover + ", new leaseTime: " + Utils.traceTime((long)newleaseTime)));
                }
                PeerLeaseData pld = new PeerLeaseData(recoveryIdentityToRecover, newleaseTime, this._leaseTimeout);
                if (newleaseTime == 0L || !pld.isExpired()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The lease file has not expired, or does not exist do not attempt recovery");
                    }
                    attemptClaim = false;
                }
                if (attemptClaim) {
                    if (this.lockPeerLease(recoveryIdentityToRecover)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Attempt to read lease file");
                        }
                        if ((fChannel = this._peerLeaseLock.getFileChannel()) != null) {
                            long fileSize = fChannel.size();
                            ByteBuffer buffer = ByteBuffer.allocate((int)fileSize);
                            fChannel.read(buffer);
                            buffer.flip();
                            String line = new String(buffer.array());
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Lease file contained " + line));
                            }
                            leaseInfo.setLeaseDetail(new File(line));
                            claimedLease = true;
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Lease Lock's channel was null");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Failed to lock or read lease file");
                    }
                }
            }
            catch (IOException attemptClaim) {
                void e;
                FFDCFilter.processException((Throwable)attemptClaim, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"442", (Object)this, (Object[])new Object[]{recoveryIdentityToRecover, myRecoveryIdentity, leaseInfo});
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug((TraceComponent)tc, (String)("Caught an IOException - " + e));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"claimPeerLeaseForRecovery", (Object)claimedLease);
        }
        return claimedLease;
    }

    @Override
    public void getLeasesForPeers(final PeerLeaseTable peerLeaseTable, String recoveryGroup) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLeasesForPeers", (Object)new Object[]{peerLeaseTable, recoveryGroup, this});
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            static final long serialVersionUID = -7402778734857988094L;
            private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

            @Override
            public Void run() {
                block21: {
                    FileChannel theChannel;
                    block20: {
                        theChannel = null;
                        FileLock lock = null;
                        try {
                            theChannel = new RandomAccessFile(_controlFile, "rw").getChannel();
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", (String)"473", (Object)this, (Object[])new Object[0]);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Caught FileNotFound exception when trying to lock control file");
                            }
                            theChannel = null;
                        }
                        if (theChannel != null) {
                            try {
                                lock = theChannel.tryLock();
                            }
                            catch (IOException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", (String)"483", (Object)this, (Object[])new Object[0]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Caught IOException when trying to lock control file - " + e));
                                }
                                theChannel = null;
                            }
                            if (lock != null) {
                                File[] thePeerFiles = _leaseLogDirectory.listFiles();
                                if (thePeerFiles != null) {
                                    for (File peerFile : thePeerFiles) {
                                        if (peerFile.isDirectory()) continue;
                                        String recoveryId = peerFile.getName();
                                        if (!recoveryId.equals(_controlFile.getName())) {
                                            long leaseTime = peerFile.lastModified();
                                            if (tc.isEventEnabled()) {
                                                Tr.event((TraceComponent)tc, (String)("Lease Table: read recoveryId: " + recoveryId));
                                                Tr.event((TraceComponent)tc, (String)("Lease Table: read leaseTime: " + Utils.traceTime((long)leaseTime)));
                                            }
                                            PeerLeaseData pld = new PeerLeaseData(recoveryId, leaseTime, FileSharedServerLeaseLog.this._leaseTimeout);
                                            peerLeaseTable.addPeerEntry(pld);
                                            continue;
                                        }
                                        if (!tc.isDebugEnabled()) continue;
                                        Tr.debug((TraceComponent)tc, (String)"Exclude the control file from the list");
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"No peer servers found");
                                }
                            }
                        }
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException thePeerFiles) {
                                FFDCFilter.processException((Throwable)thePeerFiles, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", (String)"526", (Object)this, (Object[])new Object[0]);
                                if (!tc.isDebugEnabled()) break block20;
                                Tr.debug((TraceComponent)tc, (String)"Caught an IOException on lock release");
                            }
                        }
                    }
                    if (theChannel != null) {
                        try {
                            theChannel.close();
                        }
                        catch (IOException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", (String)"535", (Object)this, (Object[])new Object[0]);
                            if (!tc.isDebugEnabled()) break block21;
                            Tr.debug((TraceComponent)tc, (String)"Caught an IOException on channel close");
                        }
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$6", 6.class, null, null);
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLeasesForPeers", (Object)this);
        }
    }

    @Override
    @FFDCIgnore(value={OverlappingFileLockException.class})
    public boolean lockPeerLease(String recoveryIdentity) {
        FileChannel fChannel;
        boolean claimedLock;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"lockPeerLease", (Object)new Object[]{recoveryIdentity, this});
            }
            claimedLock = false;
            final File leaseFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + recoveryIdentity);
            FileLock fLock = null;
            fChannel = null;
            boolean success = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
                static final long serialVersionUID = -7678627113732013995L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public Boolean run() {
                    boolean fileExists = true;
                    if (leaseFile == null || !leaseFile.exists()) {
                        fileExists = false;
                    }
                    return fileExists;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$7", 7.class, null, null);
                }
            });
            if (!success) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"lockPeerLease", (Object)false);
                }
                return false;
            }
            fChannel = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){
                static final long serialVersionUID = 6130814768062624092L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public FileChannel run() {
                    FileChannel theChannel = null;
                    try {
                        theChannel = new RandomAccessFile(leaseFile, "rw").getChannel();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$8", (String)"597", (Object)this, (Object[])new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Caught FileNotFound exception when trying to lock lease file");
                        }
                        theChannel = null;
                    }
                    return theChannel;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$8", 8.class, null, null);
                }
            });
            try {
                if (fChannel != null && (fLock = fChannel.tryLock()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("We have claimed the lock for file - " + leaseFile));
                    }
                    claimedLock = true;
                    this._peerLeaseLock = new LeaseLock(recoveryIdentity, fLock, fChannel);
                }
            }
            catch (OverlappingFileLockException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The file aleady appears to be locked in another thread");
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"623", (Object)this, (Object[])new Object[]{recoveryIdentity});
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"Caught an IOException");
            }
        }
        if (!claimedLock) {
            block15: {
                if (fChannel != null) {
                    try {
                        fChannel.close();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"634", (Object)this, (Object[])new Object[]{recoveryIdentity});
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)"Caught an IOException on channel close");
                    }
                }
            }
            this._localLeaseLock = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockPeerLease", (Object)claimedLock);
        }
        return claimedLock;
    }

    @Override
    public boolean releasePeerLease(String recoveryIdentity) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releasePeerLease", (Object)new Object[]{recoveryIdentity, this});
        }
        FileLock fLock = null;
        FileChannel fChannel = null;
        if (this._peerLeaseLock != null) {
            String recIdentity = this._peerLeaseLock.getRecoveryIdentity();
            if (recoveryIdentity.equals(recIdentity)) {
                fLock = this._peerLeaseLock.getFileLock();
                if (fLock != null) {
                    fLock.release();
                }
                if ((fChannel = this._peerLeaseLock.getFileChannel()) != null) {
                    fChannel.close();
                }
                this._peerLeaseLock = null;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The locks identity which was " + recIdentity + " did not match the requested identity which was " + recoveryIdentity));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The lease lock was unexpectedly null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releasePeerLease");
        }
        return true;
    }

    @Override
    public boolean lockLocalLease(String recoveryIdentity) {
        FileChannel fChannel;
        boolean claimedLock;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"lockLocalLease", (Object)new Object[]{recoveryIdentity, this});
            }
            claimedLock = false;
            final File leaseFile = new File(_serverInstallLeaseLogDir + String.valueOf(File.separatorChar) + recoveryIdentity);
            FileLock fLock = null;
            fChannel = null;
            fChannel = AccessController.doPrivileged(new PrivilegedAction<FileChannel>(){
                static final long serialVersionUID = -2296611191923165651L;
                private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

                @Override
                public FileChannel run() {
                    FileChannel theChannel = null;
                    try {
                        theChannel = new RandomAccessFile(leaseFile, "rw").getChannel();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        FFDCFilter.processException((Throwable)fileNotFoundException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$9", (String)"708", (Object)this, (Object[])new Object[0]);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Caught FileNotFound exception when trying to lock lease file");
                        }
                        theChannel = null;
                    }
                    return theChannel;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$9", 9.class, null, null);
                }
            });
            try {
                if (fChannel != null && (fLock = fChannel.tryLock()) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("We have claimed the lock for file - " + leaseFile));
                    }
                    claimedLock = true;
                    this._localLeaseLock = new LeaseLock(recoveryIdentity, fLock, fChannel);
                }
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                FFDCFilter.processException((Throwable)overlappingFileLockException, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"730", (Object)this, (Object[])new Object[]{recoveryIdentity});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The file aleady appears to be locked in another thread");
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"734", (Object)this, (Object[])new Object[]{recoveryIdentity});
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Caught an IOException");
            }
        }
        if (!claimedLock) {
            block13: {
                if (fChannel != null) {
                    try {
                        fChannel.close();
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", (String)"745", (Object)this, (Object[])new Object[]{recoveryIdentity});
                        if (!tc.isDebugEnabled()) break block13;
                        Tr.debug((TraceComponent)tc, (String)"Caught an IOException on channel close");
                    }
                }
            }
            this._localLeaseLock = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lockLocalLease", (Object)claimedLock);
        }
        return claimedLock;
    }

    @Override
    public boolean releaseLocalLease(String recoveryIdentity) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseLocalLease", (Object)new Object[]{recoveryIdentity, this});
        }
        FileLock fLock = null;
        FileChannel fChannel = null;
        if (this._localLeaseLock != null) {
            String recIdentity = this._localLeaseLock.getRecoveryIdentity();
            if (recoveryIdentity.equals(recIdentity)) {
                fLock = this._localLeaseLock.getFileLock();
                if (fLock != null) {
                    fLock.release();
                }
                if ((fChannel = this._localLeaseLock.getFileChannel()) != null) {
                    fChannel.close();
                }
                this._localLeaseLock = null;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The locks identity which was " + recIdentity + " did not match the requested identity which was " + recoveryIdentity));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The lease lock was unexpectedly null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseLocalLease");
        }
        return true;
    }

    @Override
    public void setPeerRecoveryLeaseTimeout(int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)leaseTimeout);
        }
        this._leaseTimeout = leaseTimeout;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setPeerRecoveryLeaseTimeout", (Object)this);
        }
    }

    @Override
    public void serverStopping() {
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog", FileSharedServerLeaseLog.class, null, null);
        _fileLeaseLog = new FileSharedServerLeaseLog();
        tc = Tr.register(FileSharedServerLeaseLog.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class LeaseLock {
        private final String _recoveryIdentity;
        FileLock _leaseFileLock = null;
        FileChannel _leaseChannel = null;
        static final long serialVersionUID = 8096026067015204049L;
        private static final /* synthetic */ com.ibm.websphere.ras.TraceComponent $$$tc$$$;

        public LeaseLock(String recIdentity, FileLock fLock, FileChannel fChannel) {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"LeaseLock", (Object)new Object[]{recIdentity, fLock, fChannel});
            }
            this._recoveryIdentity = recIdentity;
            this._leaseFileLock = fLock;
            this._leaseChannel = fChannel;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"LeaseLock", (Object)this);
            }
        }

        public FileLock getFileLock() {
            return this._leaseFileLock;
        }

        public FileChannel getFileChannel() {
            return this._leaseChannel;
        }

        public String getRecoveryIdentity() {
            return this._recoveryIdentity;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.recoverylog.spi.FileSharedServerLeaseLog$LeaseLock", LeaseLock.class, null, null);
        }
    }
}

