/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.opentracing.jaeger;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.opentracing.jaeger.AdapterFactoryImpl;
import com.ibm.ws.microprofile.opentracing.jaeger.adapter.Configuration;
import com.ibm.ws.microprofile.opentracing.jaeger.adapter.JaegerAdapterException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaegerTracerFactory {
    private static final TraceComponent tc = Tr.register(JaegerTracerFactory.class, (String)"OPENTRACING", (String)"com.ibm.ws.microprofile.opentracing.jaeger.resources.JaegerMessages");
    public static final String ENV_JAEGER_AGENT_HOST = "JAEGER_AGENT_HOST";
    public static final String ENV_JAEGER_AGENT_PORT = "JAEGER_AGENT_PORT";
    public static final String ENV_JAEGER_ENDPOINT = "JAEGER_ENDPOINT";
    public static final String ENV_JAEGER_USER = "JAEGER_USER";
    public static final String ENV_JAEGER_PASSWORD = "JAEGER_PASSWORD";
    public static final String ENV_JAEGER_AUTH_TOKEN = "JAEGER_AUTH_TOKEN";
    public static final String ENV_JAEGER_SAMPLER_TYPE = "JAEGER_SAMPLER_TYPE";
    public static final String ENV_JAEGER_SAMPLER_PARAM = "JAEGER_SAMPLER_PARAM";
    public static final String ENV_JAEGER_SAMPLER_MANAGER_HOST_PORT = "JAEGER_SAMPLER_MANAGER_HOST_PORT";
    public static final String ENV_JAEGER_REPORTER_LOG_SPANS = "JAEGER_REPORTER_LOG_SPANS";
    public static final String ENV_JAEGER_REPORTER_MAX_QUEUE_SIZE = "JAEGER_REPORTER_MAX_QUEUE_SIZE";
    public static final String ENV_JAEGER_REPORTER_FLUSH_INTERVAL = "JAEGER_REPORTER_FLUSH_INTERVAL";
    public static final String ENV_JAEGER_TAGS = "JAEGER_TAGS";
    public static final String ENV_JAEGER_PROPAGATION = "JAEGER_PROPAGATION";
    private static final String DEFAULT_AGENT_UDP_HOST = "localhost";
    private static final int DEFAULT_AGENT_UDP_COMPACT_PORT = 6831;
    private static boolean isErrorPrinted = false;
    static final long serialVersionUID = 7541102047146100726L;

    @FFDCIgnore(value={JaegerAdapterException.class, IllegalArgumentException.class})
    public static Tracer createJaegerTracer(String appName) {
        Tracer tracer = null;
        AdapterFactoryImpl factory = new AdapterFactoryImpl();
        try {
            String agentHost = JaegerTracerFactory.getProperty(ENV_JAEGER_AGENT_HOST);
            Integer agentPort = JaegerTracerFactory.getIntProperty(ENV_JAEGER_AGENT_PORT);
            String endpoint = JaegerTracerFactory.getProperty(ENV_JAEGER_ENDPOINT);
            String user = JaegerTracerFactory.getProperty(ENV_JAEGER_USER);
            String password = JaegerTracerFactory.getPasswordProperty(ENV_JAEGER_PASSWORD);
            String authToken = JaegerTracerFactory.getProperty(ENV_JAEGER_AUTH_TOKEN);
            Configuration.SenderConfiguration senderConfiguration = factory.newSenderConfiguration();
            if (agentHost != null) {
                senderConfiguration.withAgentHost(agentHost);
            }
            if (agentPort != null) {
                senderConfiguration.withAgentPort(agentPort);
            }
            if (endpoint != null) {
                senderConfiguration.withEndpoint(endpoint);
            }
            if (user != null) {
                senderConfiguration.withAuthUsername(user);
            }
            if (password != null) {
                senderConfiguration.withAuthPassword(password);
            }
            if (authToken != null) {
                senderConfiguration.withAuthToken(authToken);
            }
            String samplerType = JaegerTracerFactory.getProperty(ENV_JAEGER_SAMPLER_TYPE);
            Number samplerParam = JaegerTracerFactory.getNumProperty(ENV_JAEGER_SAMPLER_PARAM);
            String samplerHostPort = JaegerTracerFactory.getProperty(ENV_JAEGER_SAMPLER_MANAGER_HOST_PORT);
            Configuration.SamplerConfiguration samplerConfiguration = factory.newSamplerConfiguration();
            if (samplerType != null) {
                samplerConfiguration.withType(samplerType);
            }
            if (samplerParam != null) {
                samplerConfiguration.withParam(samplerParam);
            }
            if (samplerHostPort != null) {
                samplerConfiguration.withManagerHostPort(samplerHostPort);
            }
            Boolean reporterLogSpan = JaegerTracerFactory.getBooleanProperty(ENV_JAEGER_REPORTER_LOG_SPANS);
            Integer reporterMaxQueSize = JaegerTracerFactory.getIntProperty(ENV_JAEGER_REPORTER_MAX_QUEUE_SIZE);
            Integer reporterFlushInterval = JaegerTracerFactory.getIntProperty(ENV_JAEGER_REPORTER_FLUSH_INTERVAL);
            Configuration.ReporterConfiguration reporterConfiguration = factory.newReporterConfiguration();
            if (reporterLogSpan != null) {
                reporterConfiguration.withLogSpans(reporterLogSpan);
            }
            if (reporterMaxQueSize != null) {
                reporterConfiguration.withMaxQueueSize(reporterMaxQueSize);
            }
            if (reporterFlushInterval != null) {
                reporterConfiguration.withFlushInterval(reporterFlushInterval);
            }
            if (senderConfiguration != null) {
                reporterConfiguration.withSender(senderConfiguration);
            }
            String propagation = JaegerTracerFactory.getProperty(ENV_JAEGER_PROPAGATION);
            Configuration.CodecConfiguration codecConfiguration = factory.newCodecConfiguration();
            if (propagation != null) {
                for (String format : Arrays.asList(propagation.split(","))) {
                    try {
                        codecConfiguration.withPropagation(Configuration.Propagation.valueOf((String)format.toUpperCase()));
                    }
                    catch (IllegalArgumentException iae) {
                        Tr.warning((TraceComponent)tc, (String)"JAEGER_PROPAGATION_INVALID_VALUE", (Object[])new Object[]{format});
                    }
                }
            }
            Configuration configuration = factory.newConfiguration(appName).withReporter(reporterConfiguration).withSampler(samplerConfiguration).withTracerTags(JaegerTracerFactory.tracerTagsFromEnv()).withCodec(codecConfiguration);
            tracer = configuration.getTracer();
            String dest = null;
            if (endpoint != null) {
                dest = endpoint;
            } else {
                dest = agentHost != null ? agentHost : DEFAULT_AGENT_UDP_HOST;
                dest = agentPort != null ? dest + ":" + agentPort : dest + ":" + 6831;
            }
            Tr.info((TraceComponent)tc, (String)"JAEGER_TRACER_CREATED", (Object[])new Object[]{appName, dest});
        }
        catch (JaegerAdapterException jae) {
            InvocationTargetException ite;
            boolean rethrow = true;
            if (jae.getCause() != null && jae.getCause() instanceof InvocationTargetException && (ite = (InvocationTargetException)jae.getCause()).getTargetException() != null && ite.getTargetException() instanceof NoClassDefFoundError) {
                if (!isErrorPrinted) {
                    isErrorPrinted = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Jaeger library was not found or exception occurred during loading.  Exception:" + jae.getMessage()), (Object[])new Object[]{jae});
                    }
                }
                rethrow = false;
            }
            if (rethrow) {
                throw jae;
            }
        }
        catch (IllegalArgumentException e) {
            Tr.error((TraceComponent)tc, (String)"JAEGER_CONFIG_EXCEPTION", (Object[])new Object[]{e.getMessage()});
            throw e;
        }
        return tracer;
    }

    private static String getProperty(final String name) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -3319273051301638643L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            public String run() {
                return System.getProperty(name, System.getenv(name));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory$1", 1.class, (String)"OPENTRACING", (String)"com.ibm.ws.microprofile.opentracing.jaeger.resources.JaegerMessages");
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(name + ":" + value), (Object[])new Object[0]);
        }
        return value;
    }

    @Sensitive
    private static String getPasswordProperty(final String name) {
        String password = AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 8481150991001258725L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            public String run() {
                return System.getProperty(name, System.getenv(name));
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory$2", 2.class, (String)"OPENTRACING", (String)"com.ibm.ws.microprofile.opentracing.jaeger.resources.JaegerMessages");
            }
        });
        if (PasswordUtil.isEncrypted((String)password)) {
            try {
                password = PasswordUtil.decode((String)password);
            }
            catch (InvalidPasswordDecodingException | UnsupportedCryptoAlgorithmException throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory", (String)"256", null, (Object[])new Object[]{name});
                Tr.warning((TraceComponent)tc, (String)"JAEGER_PASSWORD_CANNOT_DECODE", (Object[])new Object[0]);
            }
        }
        return password;
    }

    private static Integer getIntProperty(String name) {
        String sValue = JaegerTracerFactory.getProperty(name);
        Integer iValue = null;
        if (sValue != null) {
            try {
                iValue = Integer.parseInt(sValue);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory", (String)"269", null, (Object[])new Object[]{name});
                Tr.warning((TraceComponent)tc, (String)"JAEGER_ENV_VAR_PARSE_ERROR", (Object[])new Object[]{name, Integer.class.getName()});
            }
        }
        return iValue;
    }

    private static Number getNumProperty(String name) {
        String sValue = JaegerTracerFactory.getProperty(name);
        Number nValue = null;
        if (sValue != null) {
            try {
                nValue = NumberFormat.getInstance().parse(sValue);
            }
            catch (ParseException parseException) {
                FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.microprofile.opentracing.jaeger.JaegerTracerFactory", (String)"282", null, (Object[])new Object[]{name});
                Tr.warning((TraceComponent)tc, (String)"JAEGER_ENV_VAR_PARSE_ERROR", (Object[])new Object[]{name, Number.class.getName()});
            }
        }
        return nValue;
    }

    private static Boolean getBooleanProperty(String name) {
        String sValue = JaegerTracerFactory.getProperty(name);
        Boolean bValue = null;
        if (sValue != null) {
            bValue = Boolean.parseBoolean(sValue);
        }
        return bValue;
    }

    private static Map<String, String> tracerTagsFromEnv() {
        HashMap<String, String> tracerTagMaps = null;
        String tracerTags = JaegerTracerFactory.getProperty(ENV_JAEGER_TAGS);
        if (tracerTags != null) {
            String[] tags;
            for (String tag : tags = tracerTags.split("\\s*,\\s*")) {
                String[] tagValue = tag.split("\\s*=\\s*");
                if (tagValue.length == 2) {
                    if (tracerTagMaps == null) {
                        tracerTagMaps = new HashMap<String, String>();
                    }
                    tracerTagMaps.put(tagValue[0], JaegerTracerFactory.resolveValue(tagValue[1]));
                    continue;
                }
                Tr.warning((TraceComponent)tc, (String)"JAEGER_TAGS_CANNOT_PARSE", (Object[])new Object[0]);
            }
        }
        return tracerTagMaps;
    }

    private static String resolveValue(String value) {
        String[] ref;
        if (value.startsWith("${") && value.endsWith("}") && (ref = value.substring(2, value.length() - 1).split("\\s*:\\s*")).length > 0) {
            String propertyValue = JaegerTracerFactory.getProperty(ref[0]);
            if (propertyValue == null && ref.length > 1) {
                propertyValue = ref[1];
            }
            return propertyValue;
        }
        return value;
    }
}

