/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.ssl.SSLConfiguration;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class SSLChannelOptions
extends ChannelConfiguration {
    private static final TraceComponent tc = Tr.register(SSLChannelOptions.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private String sslRefId = null;
    private boolean useDefaultId = false;
    private Dictionary<String, Object> properties = null;
    private ServiceRegistration<ChannelConfiguration> registration = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConfguration(Dictionary<String, Object> props, String defaultId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateConfguration", (Object[])new Object[]{props, defaultId});
        }
        String id = (String)props.get("sslRef");
        SSLChannelOptions sSLChannelOptions = this;
        synchronized (sSLChannelOptions) {
            this.properties = props;
            if (id == null || id.isEmpty()) {
                this.useDefaultId = true;
                id = this.sslRefId = defaultId;
                this.properties.put("sslRef", defaultId);
            } else {
                this.sslRefId = id;
                this.useDefaultId = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateConfguration", (Object)id);
        }
    }

    synchronized void updateRefId(String newDefaultId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRefId", (Object[])new Object[]{newDefaultId});
        }
        if (this.useDefaultId) {
            this.sslRefId = newDefaultId;
            this.properties.put("sslRef", this.sslRefId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRefId");
        }
    }

    private void updateSuper() {
        if (this.properties instanceof Map) {
            super.modified((Map)((Object)this.properties));
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Enumeration<String> keys = this.properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                map.put(key, this.properties.get(key));
            }
            super.modified(map);
        }
    }

    synchronized void updateRegistration(BundleContext ctx, ConcurrentServiceReferenceMap<String, SSLConfiguration> sslConfigs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updateRegistration", (Object[])new Object[]{ctx, sslConfigs});
        }
        if (ctx == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"updateRegistration");
            }
            return;
        }
        ServiceReference requiredRef = sslConfigs.getReference((Object)this.sslRefId);
        if (requiredRef != null && sslConfigs.getService((Object)this.sslRefId) != null) {
            this.properties.put("alias", this.sslRefId);
            this.updateSuper();
            if (this.registration == null) {
                this.registration = ctx.registerService(ChannelConfiguration.class, (Object)this, this.properties);
            } else {
                this.registration.setProperties(this.properties);
            }
        } else {
            this.unregister();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateRegistration");
        }
    }

    synchronized void unregister() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"unregister", (Object[])new Object[]{this});
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }
}

