/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;

public class CDIUtils {
    public static BeanManager getBeanManager(ExternalContext externalContext) {
        return (BeanManager)externalContext.getApplicationMap().get("oam.cdi.BEAN_MANAGER_INSTANCE");
    }

    public static <T> T lookup(BeanManager bm, Class<T> clazz) {
        Iterator iter = bm.getBeans(clazz, new Annotation[0]).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type " + clazz.getName());
        }
        Bean bean = (Bean)iter.next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object dao = bm.getReference(bean, clazz, ctx);
        return (T)dao;
    }

    public static Object lookup(BeanManager bm, String name) {
        Iterator iter = bm.getBeans(name).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("CDI BeanManager cannot find an instance of requested type '" + name + "'");
        }
        Bean bean = (Bean)iter.next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Type type = (Type)bean.getTypes().iterator().next();
        return bm.getReference(bean, type, ctx);
    }
}

