/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl.rldispatcher;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;

final class ConversationReceiveListenerDataReceivedInvocation
extends AbstractInvocation {
    private static final TraceComponent tc = SibTr.register(ConversationReceiveListenerDataReceivedInvocation.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private ConversationReceiveListener listener;
    private WsByteBuffer data;
    private boolean allocatedFromPool;
    private boolean partOfExchange;
    private ObjectPool owningPool;

    protected ConversationReceiveListenerDataReceivedInvocation(Connection connection, ConversationReceiveListener listener, WsByteBuffer data, int size, int segmentType, int requestNumber, int priority, boolean allocatedFromPool, boolean partOfExchange, Conversation conversation, ObjectPool owningPool) {
        super(connection, size, segmentType, requestNumber, priority, conversation);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connection, listener, data, "" + size, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromPool, "" + partOfExchange, conversation});
        }
        this.listener = listener;
        this.data = data;
        this.allocatedFromPool = allocatedFromPool;
        this.partOfExchange = partOfExchange;
        this.owningPool = owningPool;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    protected synchronized Dispatchable getThreadContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getThreadContext");
        }
        int currentPos = this.data.position();
        int currentLimit = this.data.limit();
        Dispatchable dis = null;
        try {
            dis = this.listener.getThreadContext(this.conversation, this.data, this.segmentType);
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ConversationReceiveListenerDataReceivedInvocation.getThreadContext", (String)"00130002", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown by getThreadContext");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
            }
            this.connection.invalidate(true, t, "exception thrown from getThreadContext - " + t.getMessage());
            throw new SIErrorException(TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages", (String)"CRLDRI_INTERNAL_SICJ0065", null, (String)"CRLDRI_INTERNAL_SICJ0065"));
        }
        this.data.position(currentPos);
        this.data.limit(currentLimit);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getThreadContext", (Object)dis);
        }
        return dis;
    }

    @Override
    protected synchronized void invoke() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invoke");
        }
        if (!this.conversation.isClosed()) {
            try {
                ConversationReceiveListener newReceiveListener = null;
                do {
                    int position = this.data.position();
                    int limit = this.data.limit();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        JFapUtils.debugTraceWsByteBuffer(this, tc, this.data, 16, "data passed to dataReceived method");
                    }
                    if ((newReceiveListener = this.listener.dataReceived(this.data, this.segmentType, this.requestNumber, this.priority, this.allocatedFromPool, this.partOfExchange, this.conversation)) == null) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("new receive listener supplied: " + newReceiveListener));
                    }
                    ((ConversationImpl)this.conversation).setDefaultReceiveListener(newReceiveListener);
                    this.listener = newReceiveListener;
                    this.data.limit(limit);
                    this.data.position(position);
                } while (newReceiveListener != null);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ConversationReceiveListenerDataReceivedInvocation.invoke", (String)"00130001");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown by dataReceived");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
                }
                this.connection.invalidate(true, t, "execption thrown by dataReceived method - " + t.getMessage());
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Conversation was already closed bypassing invoke.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invoke");
        }
    }

    protected synchronized void reset(Connection connection, ConversationReceiveListener listener, WsByteBuffer data, int size, int segmentType, int requestNumber, int priority, boolean allocatedFromPool, boolean partOfExchange, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset", (Object)new Object[]{connection, listener, data, "" + size, "" + segmentType, "" + requestNumber, "" + priority, "" + allocatedFromPool, "" + partOfExchange, conversation});
        }
        this.connection = connection;
        this.listener = listener;
        this.data = data;
        this.size = size;
        this.segmentType = segmentType;
        this.requestNumber = requestNumber;
        this.priority = priority;
        this.allocatedFromPool = allocatedFromPool;
        this.partOfExchange = partOfExchange;
        this.conversation = conversation;
        this.setDispatchable(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    protected synchronized void repool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"repool");
        }
        this.connection = null;
        this.listener = null;
        this.data = null;
        this.conversation = null;
        this.setDispatchable(null);
        this.owningPool.add((Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"repool");
        }
    }
}

