/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ExecutionPath;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.MergedField;
import graphql.language.SourceLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public class AbsoluteGraphQLError
implements GraphQLError {
    private final List<SourceLocation> locations;
    private final List<Object> absolutePath;
    private final String message;
    private final ErrorClassification errorType;
    private final Map<String, Object> extensions;

    public AbsoluteGraphQLError(ExecutionStrategyParameters executionStrategyParameters, GraphQLError relativeError) {
        Assert.assertNotNull(executionStrategyParameters);
        Assert.assertNotNull(relativeError);
        this.absolutePath = this.createAbsolutePath(executionStrategyParameters.getPath(), relativeError);
        this.locations = this.createAbsoluteLocations(relativeError, executionStrategyParameters.getField());
        this.message = relativeError.getMessage();
        this.errorType = relativeError.getErrorType();
        if (relativeError.getExtensions() != null) {
            this.extensions = new LinkedHashMap<String, Object>();
            this.extensions.putAll(relativeError.getExtensions());
        } else {
            this.extensions = null;
        }
    }

    public AbsoluteGraphQLError(MergedField sameField, ExecutionPath executionPath, GraphQLError relativeError) {
        this.absolutePath = this.createAbsolutePath(executionPath, relativeError);
        this.locations = this.createAbsoluteLocations(relativeError, sameField);
        this.message = relativeError.getMessage();
        this.errorType = relativeError.getErrorType();
        if (relativeError.getExtensions() != null) {
            this.extensions = new LinkedHashMap<String, Object>();
            this.extensions.putAll(relativeError.getExtensions());
        } else {
            this.extensions = null;
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    @Override
    public ErrorClassification getErrorType() {
        return this.errorType;
    }

    @Override
    public List<Object> getPath() {
        return this.absolutePath;
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    private List<Object> createAbsolutePath(ExecutionPath executionPath, GraphQLError relativeError) {
        return Optional.ofNullable(relativeError.getPath()).map(originalPath -> {
            ArrayList<Object> path = new ArrayList<Object>();
            path.addAll(executionPath.toList());
            path.addAll(relativeError.getPath());
            return path;
        }).map(Collections::unmodifiableList).orElse(executionPath.toList());
    }

    private List<SourceLocation> createAbsoluteLocations(GraphQLError relativeError, MergedField fields) {
        Optional<SourceLocation> baseLocation = Optional.ofNullable(fields.getSingleField().getSourceLocation());
        if (relativeError.getLocations() != null && relativeError.getLocations().isEmpty()) {
            return baseLocation.map(Collections::singletonList).orElse(null);
        }
        return Optional.ofNullable(relativeError.getLocations()).map(locations -> locations.stream().map(l -> baseLocation.map(base -> new SourceLocation(base.getLine() + l.getLine(), base.getColumn() + l.getColumn())).orElse(null)).collect(Collectors.toList())).map(Collections::unmodifiableList).orElse(null);
    }
}

