/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.PublicApi;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.util.TraversalControl;
import graphql.util.Traverser;
import graphql.util.TraverserContext;
import graphql.util.TraverserResult;
import graphql.util.TraverserVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@PublicApi
public class SchemaTraverser {
    private final Function<? super GraphQLSchemaElement, ? extends List<GraphQLSchemaElement>> getChildren;

    public SchemaTraverser(Function<? super GraphQLSchemaElement, ? extends List<GraphQLSchemaElement>> getChildren) {
        this.getChildren = getChildren;
    }

    public SchemaTraverser() {
        this(GraphQLSchemaElement::getChildren);
    }

    public TraverserResult depthFirst(GraphQLTypeVisitor graphQLTypeVisitor, GraphQLSchemaElement root) {
        return this.depthFirst(graphQLTypeVisitor, Collections.singletonList(root));
    }

    public TraverserResult depthFirst(GraphQLTypeVisitor graphQLTypeVisitor, Collection<? extends GraphQLSchemaElement> roots) {
        return this.depthFirst(this.initTraverser(), new TraverserDelegateVisitor(graphQLTypeVisitor), roots);
    }

    public TraverserResult depthFirst(GraphQLTypeVisitor graphQLTypeVisitor, Collection<? extends GraphQLSchemaElement> roots, Map<String, GraphQLNamedType> types) {
        Traverser<GraphQLSchemaElement> traverser = this.initTraverser().rootVar(SchemaTraverser.class, types);
        return this.depthFirst(traverser, new TraverserDelegateVisitor(graphQLTypeVisitor), roots);
    }

    public TraverserResult depthFirst(Traverser<GraphQLSchemaElement> traverser, TraverserDelegateVisitor traverserDelegateVisitor, Collection<? extends GraphQLSchemaElement> roots) {
        return this.doTraverse(traverser, roots, traverserDelegateVisitor);
    }

    private Traverser<GraphQLSchemaElement> initTraverser() {
        return Traverser.depthFirst(this.getChildren);
    }

    private TraverserResult doTraverse(Traverser<GraphQLSchemaElement> traverser, Collection<? extends GraphQLSchemaElement> roots, TraverserDelegateVisitor traverserDelegateVisitor) {
        return traverser.traverse(roots, (TraverserVisitor<GraphQLSchemaElement>)traverserDelegateVisitor);
    }

    private static class TraverserDelegateVisitor
    implements TraverserVisitor<GraphQLSchemaElement> {
        private final GraphQLTypeVisitor before;

        TraverserDelegateVisitor(GraphQLTypeVisitor delegate) {
            this.before = delegate;
        }

        @Override
        public TraversalControl enter(TraverserContext<GraphQLSchemaElement> context) {
            return context.thisNode().accept(context, this.before);
        }

        @Override
        public TraversalControl leave(TraverserContext<GraphQLSchemaElement> context) {
            return TraversalControl.CONTINUE;
        }

        @Override
        public TraversalControl backRef(TraverserContext<GraphQLSchemaElement> context) {
            return this.before.visitBackRef(context);
        }
    }
}

