/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SecurityRequirementValidator
extends TypeValidator<SecurityRequirement> {
    private static final TraceComponent tc = Tr.register(SecurityRequirementValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final SecurityRequirementValidator INSTANCE = new SecurityRequirementValidator();
    static final long serialVersionUID = -3612533938073143301L;

    public static SecurityRequirementValidator getInstance() {
        return INSTANCE;
    }

    private SecurityRequirementValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, SecurityRequirement t) {
        Map secReqSchemes = t.getSchemes();
        if (secReqSchemes != null && !secReqSchemes.isEmpty()) {
            Map schemes = null;
            if (context.getModel().getComponents() != null) {
                schemes = context.getModel().getComponents().getSecuritySchemes();
            }
            Set h = secReqSchemes.keySet();
            for (String name : h) {
                String message;
                if (schemes == null || !schemes.containsKey(name) || schemes.get(name) == null) {
                    String message2 = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementNotDeclared", (Object[])new Object[]{name});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message2));
                    continue;
                }
                String type = ((SecurityScheme)schemes.get(name)).getType() != null ? ((SecurityScheme)schemes.get(name)).getType().toString() : null;
                List value = (List)secReqSchemes.get(name);
                if ("oauth2".equals(type) || "openIdConnect".equals(type)) {
                    if (value != null && !value.isEmpty()) continue;
                    message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementScopeNamesRequired", (Object[])new Object[]{name});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
                    continue;
                }
                if (!"apiKey".equals(type) && !"http".equals(type) || value == null || value.isEmpty()) continue;
                message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementFieldNotEmpty", (Object[])new Object[]{name, value});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
            }
        } else {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"securityRequirementIsEmpty", (Object[])new Object[0]);
            helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation(), message));
        }
    }
}

