/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.google.gson.JsonObject;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.HashUtils;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil;
import com.ibm.ws.security.openidconnect.token.IDToken;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientUtil {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OidcClientUtil.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private final List<NameValuePair> commonHeaders = new ArrayList<NameValuePair>();
    OidcClientHttpUtil oidcHttpUtil = null;
    static AtomicReference<ReferrerURLCookieHandler> referrerURLCookieHandlerRef = new AtomicReference();
    static AtomicReference<WebAppSecurityConfig> webAppSecurityConfigRef = new AtomicReference();

    public OidcClientUtil() {
        this.commonHeaders.add((NameValuePair)new BasicNameValuePair("Accept", "application/json"));
        this.init(OidcClientHttpUtil.getInstance());
    }

    void init(OidcClientHttpUtil oidcHttpUtil) {
        this.oidcHttpUtil = oidcHttpUtil;
    }

    final List<NameValuePair> getCommonHeaders() {
        return this.commonHeaders;
    }

    public HashMap<String, String> getTokensFromAuthzCode(String tokenEnpoint, String clientId, @Sensitive String clientSecret, String redirectUri, String code, String grantType, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, String resources, HashMap<String, String> customParams, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("grant_type", grantType));
        if (resources != null) {
            params.add((NameValuePair)new BasicNameValuePair("resource", resources));
        }
        params.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectUri));
        params.add((NameValuePair)new BasicNameValuePair("code", code));
        this.oidcHttpUtil.setClientId(clientId);
        if (authMethod.equals("post") || authMethod.equals("client_secret_post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        }
        this.handleCustomParams(params, customParams);
        Map<String, Object> postResponseMap = this.postToTokenEndpoint(tokenEnpoint, params, clientId, clientSecret, sslSocketFactory, isHostnameVerification, authMethod, useSystemPropertiesForHttpClientConnections);
        String tokenResponse = this.oidcHttpUtil.extractTokensFromResponse(postResponseMap);
        JSONObject jobject = JSONObject.parse((String)tokenResponse);
        Iterator it = jobject.entrySet().iterator();
        HashMap<String, String> tokens = new HashMap<String, String>();
        while (it.hasNext()) {
            Map.Entry obj = (Map.Entry)it.next();
            if (!(obj.getKey() instanceof String)) continue;
            Object value = obj.getValue();
            if (value == null) {
                value = "";
            }
            tokens.put((String)obj.getKey(), value.toString());
        }
        return tokens;
    }

    public void handleCustomParams(@Sensitive List<NameValuePair> params, HashMap<String, String> customParams) {
        if (customParams != null && !customParams.isEmpty()) {
            Set<Map.Entry<String, String>> entries = customParams.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
    }

    public Map<String, Object> checkToken(String tokenInfor, String clientId, @Sensitive String clientSecret, String accessToken, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("token", accessToken));
        if (authMethod.equals("post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        }
        Map<String, Object> postResponseMap = this.postToCheckTokenEndpoint(tokenInfor, params, clientId, clientSecret, isHostnameVerification, authMethod, sslSocketFactory, useSystemPropertiesForHttpClientConnections);
        return postResponseMap;
    }

    public Map<String, Object> getUserinfo(String userInfor, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        Map<String, Object> getResponseMap = this.getFromUserinfoEndpoint(userInfor, params, accessToken, sslSocketFactory, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        return getResponseMap;
    }

    Map<String, Object> postToTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        return this.oidcHttpUtil.postToEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, this.commonHeaders, isHostnameVerification, authMethod, useSystemPropertiesForHttpClientConnections);
    }

    Map<String, Object> postToCheckTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useSystemPropertiesForHttpClientConnections) throws Exception {
        return this.oidcHttpUtil.postToIntrospectEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, this.commonHeaders, isHostnameVerification, authMethod, useSystemPropertiesForHttpClientConnections);
    }

    Map<String, Object> getFromUserinfoEndpoint(String userInforEndpoint, List<NameValuePair> params, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws HttpException, IOException {
        return this.getFromEndpoint(userInforEndpoint, params, null, null, accessToken, sslSocketFactory, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
    }

    Map<String, Object> getFromEndpoint(String url, List<NameValuePair> params, String baUsername, @Sensitive String baPassword, String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean useSystemPropertiesForHttpClientConnections) throws HttpException, IOException {
        String query = null;
        if (params != null) {
            query = URLEncodedUtils.format(params, (String)"UTF-8");
        }
        if (query != null) {
            if (!url.endsWith("?")) {
                url = url + "?";
            }
            url = url + query;
        }
        HttpGet request = new HttpGet(url);
        for (NameValuePair nameValuePair : this.commonHeaders) {
            request.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
        if (accessToken != null) {
            request.setHeader("Authorization", "Bearer " + accessToken);
        }
        HttpClient httpClient = baUsername != null ? this.oidcHttpUtil.createHTTPClient(sslSocketFactory, url, isHostnameVerification, baUsername, baPassword, useSystemPropertiesForHttpClientConnections) : this.oidcHttpUtil.createHTTPClient(sslSocketFactory, url, isHostnameVerification, useSystemPropertiesForHttpClientConnections);
        HttpResponse responseCode = httpClient.execute((HttpUriRequest)request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", responseCode);
        result.put("RESPONSEMAP_METHOD", request);
        return result;
    }

    public String getRedirectUrl(HttpServletRequest req, String uri) {
        String hostName = req.getServerName();
        Integer httpsPort = new WebUtils().getRedirectPortFromRequest(req);
        String entryPoint = uri;
        if (httpsPort == null && req.isSecure()) {
            int port = req.getServerPort();
            String httpSchema = req.getScheme();
            return httpSchema + "://" + hostName + (port > 0 && port != 443 ? ":" + port : "") + entryPoint;
        }
        return "https://" + hostName + (httpsPort == null ? "" : ":" + httpsPort) + entryPoint;
    }

    public IDToken createIDToken(String tokenString, @Sensitive Object key, String clientId, String issuer, String signingAlgorithm, String accessToken) {
        return new IDToken(tokenString, key, clientId, issuer, signingAlgorithm, accessToken);
    }

    public static Cookie createCookie(String cookieName, @Sensitive String cookieValue, HttpServletRequest req) {
        return OidcClientUtil.createCookie(cookieName, cookieValue, -1, req);
    }

    public static Cookie createCookie(String cookieName, @Sensitive String cookieValue, int maxAge, HttpServletRequest req) {
        Cookie cookie = OidcClientUtil.getReferrerURLCookieHandler().createCookie(cookieName, cookieValue, req);
        String domainName = OidcClientUtil.getSsoDomain(req);
        if (domainName != null && !domainName.isEmpty()) {
            cookie.setDomain(domainName);
        }
        cookie.setMaxAge(maxAge);
        return cookie;
    }

    public static void invalidateReferrerURLCookie(HttpServletRequest req, HttpServletResponse res, String cookieName) {
        if (cookieName == null || req == null || res == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidateReferrerURLCookie param is null, return", (Object[])new Object[0]);
            }
            return;
        }
        Cookie c = OidcClientUtil.createCookie(cookieName, "", req);
        String domainName = OidcClientUtil.getSsoDomain(req);
        if (domainName != null && !domainName.isEmpty()) {
            c.setDomain(domainName);
        }
        c.setMaxAge(0);
        res.addCookie(c);
    }

    public static void invalidateReferrerURLCookies(HttpServletRequest req, HttpServletResponse res, String[] cookieNames) {
        if (cookieNames == null || req == null || res == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"invalidateReferrerURLCookies param is null, return", (Object[])new Object[0]);
            }
            return;
        }
        for (String name : cookieNames) {
            OidcClientUtil.invalidateReferrerURLCookie(req, res, name);
        }
    }

    public static String getSsoDomain(HttpServletRequest req) {
        SSOCookieHelper ssoCookieHelper = OidcClientUtil.getWebAppSecurityConfig().createSSOCookieHelper();
        String domainName = ssoCookieHelper.getSSODomainName(req, OidcClientUtil.getWebAppSecurityConfig().getSSODomainList(), OidcClientUtil.getWebAppSecurityConfig().getSSOUseDomainFromURL());
        return domainName;
    }

    static WebAppSecurityConfig getWebAppSecurityConfig() {
        if (webAppSecurityConfigRef.get() == null) {
            webAppSecurityConfigRef.set(WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig());
        }
        return webAppSecurityConfigRef.get();
    }

    public static ReferrerURLCookieHandler getReferrerURLCookieHandler() {
        ReferrerURLCookieHandler handler = referrerURLCookieHandlerRef.get();
        if (handler == null) {
            handler = OidcClientUtil.getWebAppSecurityConfig().createReferrerURLCookieHandler();
            referrerURLCookieHandlerRef.set(handler);
        }
        return handler;
    }

    public static void setReferrerURLCookieHandler(ReferrerURLCookieHandler referrerURLCookieHandler) {
        if (OidcClientUtil.getReferrerURLCookieHandler() != referrerURLCookieHandler) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Old and new CookieHandler", (Object[])new Object[]{OidcClientUtil.getReferrerURLCookieHandler(), referrerURLCookieHandler});
            }
            webAppSecurityConfigRef.set(WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig());
            referrerURLCookieHandlerRef.set(referrerURLCookieHandler);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public static boolean isReferrerHostValid(HttpServletRequest req, @Sensitive String requestUrl) {
        try {
            ReferrerURLCookieHandler.isReferrerHostValid((String)PasswordNullifier.nullifyParams((String)req.getRequestURL().toString()), (String)PasswordNullifier.nullifyParams((String)requestUrl), (List)OidcClientUtil.getWebAppSecurityConfig().getWASReqURLRedirectDomainNames());
            return true;
        }
        catch (Exception re) {
            return false;
        }
    }

    public static void setWebAppSecurityConfig(WebAppSecurityConfig webAppSecurityConfig) {
        webAppSecurityConfigRef.set(webAppSecurityConfig);
    }

    /*
     * WARNING - void declaration
     */
    public static void setCookieForRequestParameter(HttpServletRequest request, HttpServletResponse response, String id, String state, boolean isHttpsRequest, ConvergedClientConfig clientCfg) {
        String encodedReqParams;
        block6: {
            Map map = request.getParameterMap();
            JsonObject jsonObject = new JsonObject();
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                String[] strs;
                String key = (String)entry.getKey();
                if ("access_token".equals(key) || "id_token".equals(key) || (strs = (String[])entry.getValue()) == null || strs.length <= 0) continue;
                jsonObject.addProperty(key, strs[0]);
            }
            String requestParameters = jsonObject.toString();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("requestParameters:" + requestParameters), (Object[])new Object[0]);
            }
            encodedReqParams = null;
            try {
                encodedReqParams = Base64Coder.toString(Base64Coder.base64Encode(requestParameters.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException key) {
                void e;
                FFDCFilter.processException((Throwable)key, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil", (String)"418", null, (Object[])new Object[]{request, response, id, state, isHttpsRequest, clientCfg});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"get unexpected exception", (Object[])new Object[]{e});
            }
        }
        String encodedHash = null;
        if (encodedReqParams != null) {
            encodedHash = OidcClientUtil.calculateOidcCodeCookieValue(encodedReqParams, clientCfg);
        }
        Cookie c = OidcClientUtil.createCookie("WASOidcCode", encodedHash, request);
        if (clientCfg.isHttpsRequired() && isHttpsRequest) {
            c.setSecure(true);
        }
        response.addCookie(c);
    }

    public static String calculateOidcCodeCookieValue(String encoded, ConvergedClientConfig clientCfg) {
        String retVal = new String(encoded);
        String uniqueSecretValue = clientCfg.getClientSecret();
        if (uniqueSecretValue == null) {
            uniqueSecretValue = clientCfg.toString();
        }
        String signatureValue = new String(encoded) + "_" + uniqueSecretValue;
        retVal = retVal + "_" + HashUtils.digest(signatureValue);
        return retVal;
    }
}

