/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.signature;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SignatureAlgorithms {
    private static final TraceComponent tc = Tr.register(SignatureAlgorithms.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    static final String rsa_sha1 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    static final String rsa_sha256 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    static final String rsa_sha384 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    static final String rsa_sha512 = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    static final String hmac_sha1 = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    static final String hmac_sha256 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256";
    static final String hmac_sha384 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384";
    static final String hmac_sha512 = "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512";
    static Map<String, String> RSA_MAP = new HashMap<String, String>();
    static Map<String, String> HMAC_MAP;
    static final long serialVersionUID = -1275365531426196262L;

    public static void setAlgorithm(SoapMessage message, String method) {
        if (message == null || method == null || method.isEmpty()) {
            return;
        }
        String algorithm = method.toLowerCase();
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        AlgorithmSuite algorithmSuite = SignatureAlgorithms.getAlgorithmSuite(aim);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"AlgorithmSuite ", (Object[])new Object[]{algorithmSuite, method});
        }
        if (algorithmSuite != null) {
            if (RSA_MAP.containsKey(algorithm)) {
                algorithmSuite.setAsymmetricSignature(RSA_MAP.get(algorithm));
            }
            if (HMAC_MAP.containsKey(algorithm)) {
                algorithmSuite.setSymmetricSignature(HMAC_MAP.get(algorithm));
            }
        }
    }

    public static AlgorithmSuite getAlgorithmSuite(AssertionInfoMap aim) {
        Binding transport = null;
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais != null) {
            for (AssertionInfo ai : ais) {
                transport = (Binding)ai.getAssertion();
            }
        } else {
            ais = (Collection)aim.get((Object)SP12Constants.ASYMMETRIC_BINDING);
            if (ais != null) {
                for (AssertionInfo ai : ais) {
                    transport = (Binding)ai.getAssertion();
                }
            } else {
                ais = (Collection)aim.get((Object)SP12Constants.SYMMETRIC_BINDING);
                if (ais != null) {
                    for (AssertionInfo ai : ais) {
                        transport = (Binding)ai.getAssertion();
                    }
                }
            }
        }
        if (transport != null) {
            return transport.getAlgorithmSuite();
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
    static {
        RSA_MAP.put("sha1", rsa_sha1);
        RSA_MAP.put("sha256", rsa_sha256);
        RSA_MAP.put("sha384", rsa_sha384);
        RSA_MAP.put("sha512", rsa_sha512);
        HMAC_MAP = new HashMap<String, String>();
        HMAC_MAP.put("sha1", hmac_sha1);
        HMAC_MAP.put("sha256", hmac_sha256);
        HMAC_MAP.put("sha384", hmac_sha384);
        HMAC_MAP.put("sha512", hmac_sha512);
    }
}

