/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemMembership;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public final class ItemLink
extends AbstractItemLink
implements ItemMembership,
TransactionCallback {
    private static TraceComponent tc = SibTr.register(ItemLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private volatile int _referenceCount = 0;
    private boolean _referenceCountIsDecreasing = false;

    public ItemLink(AbstractItem item, LinkOwner owningStreamLink, Persistable persistable) throws OutOfCacheSpace {
        super(item, owningStreamLink, persistable);
    }

    public ItemLink(LinkOwner owningStreamLink, Persistable persistable) {
        super(owningStreamLink, persistable);
    }

    @Override
    public SevereMessageStoreException assertCanDelete(PersistentTransaction transaction) {
        SevereMessageStoreException ex = super.assertCanDelete(transaction);
        if (null == ex && 0 < this._referenceCount) {
            ex = new SevereMessageStoreException("Cannot delete Item with references");
            FFDCFilter.processException((Throwable)ex, (String)"ItemLink.delete", (String)"1:111:1.104.1.1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception :  Cannot delete Item with references");
            }
        }
        return ex;
    }

    public final synchronized void commitDecrementReferenceCount(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitDecrementReferenceCount");
        }
        if (this._referenceCount < 1) {
            SevereMessageStoreException e = new SevereMessageStoreException("Reference count decrement cannot be committed");
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.ItemLink.commitDecrementReferenceCount", (String)"1:131:1.104.1.1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Reference count decrement cannot be committed");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitDecrementReferenceCount");
            }
            throw e;
        }
        --this._referenceCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference count dropped to: " + this._referenceCount));
        }
        if (0 == this._referenceCount) {
            transaction.registerCallback(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitDecrementReferenceCount");
        }
    }

    public final ItemStream getOwningItemStream() throws SevereMessageStoreException {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    public final int getReferenceCount() {
        return this._referenceCount;
    }

    public final synchronized void incrementReferenceCount() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementReferenceCount");
        }
        if (this._referenceCountIsDecreasing) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot increment! Reference count has begun decreasing.");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementReferenceCount");
            }
            throw new SevereMessageStoreException("Cannot add more references to an item after one has been removed");
        }
        ++this._referenceCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementReferenceCount");
        }
    }

    @Override
    protected boolean internalCanExpire() {
        boolean can = super.internalCanExpire();
        if (can && this._referenceCount > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"preventing expiry as references remain");
            }
            can = false;
        }
        return can;
    }

    public final synchronized void rollbackIncrementReferenceCount(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackIncrementReferenceCount");
        }
        if (this._referenceCount < 1) {
            SevereMessageStoreException e = new SevereMessageStoreException("Reference count increment cannot be rolled back");
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.ItemLink.rollbackIncrementReferenceCount", (String)"1:212:1.104.1.1");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Reference count increment cannot be rolled back");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackIncrementReferenceCount");
            }
            throw e;
        }
        --this._referenceCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackIncrementReferenceCount");
        }
    }

    @Override
    public String toString() {
        return "ItemLink(" + this.getID() + ")" + super.toString() + " state=" + this.getState() + " refCount=" + this._referenceCount + " refCountDecreasing=" + Boolean.toString(this._referenceCountIsDecreasing);
    }

    @Override
    protected final String xmlTagName() {
        return "item";
    }

    @Override
    protected void xmlWriteAttributesOn(FormattedWriter writer) throws IOException {
        super.xmlWriteAttributesOn(writer);
        writer.write(" refCount=\"");
        writer.write(Integer.toString(this._referenceCount));
        writer.write("\" refCountDecreasing=\"");
        writer.write(Boolean.toString(this._referenceCountIsDecreasing));
        writer.write(34);
    }

    public void beforeCompletion(TransactionCommon transaction) {
    }

    public void afterCompletion(TransactionCommon transaction, boolean committed) {
        block4: {
            if (this.isAvailable()) {
                try {
                    Item item = (Item)this.getItem();
                    if (null != item) {
                        item.itemReferencesDroppedToZero();
                    }
                }
                catch (SevereMessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.ItemLink.afterCompletion", (String)"1:286:1.104.1.1");
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"Exception caught attempting to drop item reference count to zero!", (Object)((Object)e));
                }
            }
        }
    }
}

