/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.util.logging.Tr;
import com.ibm.tx.util.logging.TraceComponent;
import java.io.Serializable;
import javax.transaction.xa.XAResource;

public class DirectEnlistXAResourceInfo
implements Serializable {
    private static final long serialVersionUID = -6971618853657075544L;
    private static final TraceComponent tc = Tr.register(DirectEnlistXAResourceInfo.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final transient XAResource _xaResource;
    private final Serializable serializableXaResource;
    private final String rmName = "Directly enlisted XA Resource";

    public DirectEnlistXAResourceInfo(XAResource xaResource) {
        this._xaResource = xaResource;
        if (this._xaResource instanceof Serializable) {
            this.serializableXaResource = (Serializable)((Object)this._xaResource);
        } else {
            this.serializableXaResource = null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Transaction recovery is not possible because the resource {0} is not serializable.", (Object)xaResource);
            }
        }
    }

    public String getRMName() {
        return "Directly enlisted XA Resource";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DirectEnlistXAResourceInfo)) {
            return false;
        }
        DirectEnlistXAResourceInfo otherDirectEnlistXAResource = (DirectEnlistXAResourceInfo)o;
        if (!"Directly enlisted XA Resource".equals(otherDirectEnlistXAResource.rmName)) {
            return false;
        }
        return this.serializableXaResource == null || this.serializableXaResource.equals(otherDirectEnlistXAResource.serializableXaResource);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public XAResource getXAResource() {
        if (this.serializableXaResource != null) {
            return (XAResource)((Object)this.serializableXaResource);
        }
        return this._xaResource;
    }
}

