/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transactions;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.message.CancelRequest;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.MergedRequestKey;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTranaction;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPInviteClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPInviteServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransaction;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.TransactionDoesNotExistException;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SIPTransactionsModel {
    private static final LogMgr s_logger = Log.get(SIPTransactionsModel.class);
    private static SIPTransactionsModel s_instance = new SIPTransactionsModel();
    private static final int TRANSACTIONS_TABLE_BEGIN_NUMBER = 50;
    private Map m_clientTransactionsById = new HashMap(50);
    private Map m_clientTransactionsByBranchMethodKey = new HashMap(50);
    private Map m_serverTransactionsById = new HashMap(50);
    private Map m_serverTransactionsByBranchMethodKey = new HashMap(50);
    private Set m_mergedRequests = new HashSet(50);

    public static SIPTransactionsModel instance() {
        return s_instance;
    }

    private SIPTransactionsModel() {
    }

    public synchronized SIPClientTranaction getClientTransaction(long transactionId) throws TransactionDoesNotExistException {
        SIPClientTranaction transaction = (SIPClientTranaction)this.m_clientTransactionsById.get(new Long(transactionId));
        if (transaction == null) {
            throw new TransactionDoesNotExistException("client transaction does not exist [" + transactionId + ']');
        }
        return transaction;
    }

    public synchronized SIPClientTranaction getClientTransaction(BranchMethodKey key) {
        return (SIPClientTranaction)this.m_clientTransactionsByBranchMethodKey.get(key);
    }

    public synchronized SIPServerTransaction getServerTransaction(long transactionId) throws TransactionDoesNotExistException {
        SIPServerTransaction transaction = (SIPServerTransaction)this.m_serverTransactionsById.get(new Long(transactionId));
        if (transaction == null) {
            throw new TransactionDoesNotExistException("server transaction does not exist [" + transactionId + ']');
        }
        return transaction;
    }

    public synchronized SIPServerTransaction getServerTransaction(BranchMethodKey key, Request req) {
        SIPServerTransaction serverTransaction = (SIPServerTransaction)this.m_serverTransactionsByBranchMethodKey.get(key);
        if (serverTransaction == null) {
            return null;
        }
        if (!serverTransaction.isRequestPartOfTransaction(req)) {
            if (s_logger.isTraceDebugEnabled()) {
                s_logger.traceDebug("Warning: server transaction [" + serverTransaction.toString() + "] does not match request");
            }
            return null;
        }
        return serverTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void correlateCancelToInviteTransaction(CancelRequest cancelReq) throws SipParseException, TransactionDoesNotExistException {
        SIPInviteServerTransactionImpl st;
        BranchMethodKey transactionId = this.createTransactionId(cancelReq, "INVITE");
        SIPTransactionsModel sIPTransactionsModel = this;
        synchronized (sIPTransactionsModel) {
            Object transaction = this.m_serverTransactionsByBranchMethodKey.get(transactionId);
            if (transaction == null || !(transaction instanceof SIPInviteServerTransactionImpl)) {
                if (s_logger.isTraceDebugEnabled()) {
                    s_logger.traceDebug(this, "correlateCancelToInviteTransaction", "Cannot match INVITE transaction to CANCEL request");
                }
                throw new TransactionDoesNotExistException("no matching transaction found");
            }
            st = (SIPInviteServerTransactionImpl)transaction;
        }
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug(this, "correlateCancelToInviteTransaction", "successfully matched CANCEL to INVITE");
        }
        cancelReq.setOriginInviteTransaction(st.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIPInviteClientTransactionImpl getInviteFromCancel(Request cancelReq) throws SipParseException {
        SIPInviteClientTransactionImpl ct;
        BranchMethodKey transactionId = this.createTransactionId(cancelReq, "INVITE");
        SIPTransactionsModel sIPTransactionsModel = this;
        synchronized (sIPTransactionsModel) {
            ct = (SIPInviteClientTransactionImpl)this.m_clientTransactionsByBranchMethodKey.get(transactionId);
        }
        return ct;
    }

    public synchronized void putServerTransaction(SIPServerTransaction st) {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("adding server transaction [" + st + ']');
        }
        this.m_serverTransactionsById.put(new Long(st.getId()), st);
        this.m_serverTransactionsByBranchMethodKey.put(st.getBranchMethodId(), st);
        MergedRequestKey sourceId = st.getMergedRequestKey();
        if (sourceId != null) {
            this.m_mergedRequests.add(sourceId);
        }
    }

    public synchronized void putClientTransaction(SIPClientTranaction ct) {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("adding client transaction [" + ct + ']');
        }
        this.m_clientTransactionsById.put(new Long(ct.getId()), ct);
        this.m_clientTransactionsByBranchMethodKey.put(ct.getBranchMethodId(), ct);
    }

    public synchronized void remove(SIPServerTransaction st) {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("removing server transaction [" + st + ']');
        }
        this.m_serverTransactionsById.remove(new Long(st.getId()));
        this.m_serverTransactionsByBranchMethodKey.remove(st.getBranchMethodId());
        MergedRequestKey sourceId = st.getMergedRequestKey();
        if (sourceId != null) {
            this.m_mergedRequests.remove(sourceId);
        }
    }

    public synchronized void remove(SIPClientTranaction ct) {
        if (s_logger.isTraceDebugEnabled()) {
            s_logger.traceDebug("removing client tranaction [" + ct + ']');
        }
        this.m_clientTransactionsById.remove(new Long(ct.getId()));
        this.m_clientTransactionsByBranchMethodKey.remove(ct.getBranchMethodId());
    }

    public BranchMethodKey createTransactionId(Message msg) throws SipParseException {
        CSeqHeader cseq = msg.getCSeqHeader();
        if (cseq == null) {
            throw new SipParseException("no CSeq header");
        }
        String method = cseq.getMethod();
        if (method == null) {
            throw new SipParseException("no method in CSeq header");
        }
        return this.createTransactionId(msg, method);
    }

    private BranchMethodKey createTransactionId(Message msg, String method) throws SipParseException {
        ViaHeader via = (ViaHeader)msg.getHeader("Via", true);
        if (via == null) {
            throw new SipParseException("no Via header", null);
        }
        String branch = via.getBranch();
        if (branch == null || branch.length() == 0) {
            if (msg instanceof Request) {
                Request req = (Request)msg;
                branch = this.generateBranch(req);
            } else {
                throw new SipParseException("no branch in response", null);
            }
        }
        if (method.equals("ACK")) {
            method = "INVITE";
        }
        BranchMethodKey key = new BranchMethodKey(method, branch, via.getHost(), via.getPort());
        return key;
    }

    private String generateBranch(Request req) {
        String callId = req.getCallIdHeader().getCallId();
        String fromTag = req.getFromHeader().getTag();
        if (fromTag == null) {
            fromTag = "";
        }
        CSeqHeader cseq = req.getCSeqHeader();
        int hash = callId.hashCode() ^ fromTag.hashCode() ^ (int)cseq.getSequenceNumber();
        StringBuffer branch = new StringBuffer(23);
        branch.append("z9hG4bK");
        branch.append(hash);
        return branch.toString();
    }

    public MergedRequestKey createMergedTransactionId(Request req) {
        String fromTag = req.getFromHeader().getTag();
        String callId = req.getCallIdHeader().getCallId();
        CSeqHeader cseq = req.getCSeqHeader();
        return new MergedRequestKey(fromTag, callId, cseq);
    }

    public boolean isMergedServerTransaction(MergedRequestKey sourceId) {
        return this.m_mergedRequests.contains(sourceId);
    }
}

