/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.internal;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.springboot.container.ApplicationError;
import com.ibm.ws.app.manager.springboot.internal.SpringBootApplicationImpl;
import com.ibm.ws.app.manager.springboot.internal.SpringBootModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "type:String=spring"})
public class SpringBootRuntimeContainer
implements ModuleRuntimeContainer {
    private static final TraceComponent tc = Tr.register(SpringBootRuntimeContainer.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootRuntimeContainer");
    @Reference
    private ExecutorService executor;
    @Reference
    private FutureMonitor futureMonitor;
    @Reference
    private LibertyProcess libertyProcess;
    static final long serialVersionUID = 2060038856908188253L;

    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        return new SpringModuleMetaData((SpringBootModuleInfo)moduleInfo);
    }

    public Future<Boolean> startModule(ExtendedModuleInfo moduleInfo) throws StateChangeException {
        SpringBootModuleInfo springBootModuleInfo = (SpringBootModuleInfo)moduleInfo;
        Future result = this.futureMonitor.createFuture(Boolean.class);
        this.invokeSpringMain(result, springBootModuleInfo);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void invokeSpringMain(Future<Boolean> mainInvokeResult, SpringBootModuleInfo springBootModuleInfo) {
        Method main;
        SpringBootApplicationImpl springBootApplication = springBootModuleInfo.getSpringBootApplication();
        ClassLoader newTccl = springBootModuleInfo.getThreadContextClassLoader();
        ClassLoader previousTccl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(newTccl);
            return null;
        });
        try {
            springBootApplication.registerSpringConfigFactory();
            Class<?> springApplicationClass = springBootModuleInfo.getClassLoader().loadClass(springBootApplication.getSpringBootManifest().getSpringStartClass());
            main = springApplicationClass.getMethod("main", String[].class);
            main.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException springApplicationClass) {
            void e;
            FFDCFilter.processException((Throwable)springApplicationClass, (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootRuntimeContainer", (String)"113", (Object)this, (Object[])new Object[]{mainInvokeResult, springBootModuleInfo});
            this.futureMonitor.setResult(mainInvokeResult, (Throwable)e);
            return;
        }
        finally {
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(previousTccl);
                return null;
            });
        }
        this.executor.execute(() -> {
            ClassLoader execPreviousTccl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
            AccessController.doPrivileged(() -> {
                Thread.currentThread().setContextClassLoader(newTccl);
                return null;
            });
            try {
                String[] appArgs = this.libertyProcess.getArgs();
                if (appArgs.length == 0) {
                    appArgs = springBootApplication.getAppArgs().toArray(new String[0]);
                }
                main.invoke(null, new Object[]{appArgs});
                springBootApplication.getApplicationReadyLatch().countDown();
                this.futureMonitor.setResult(mainInvokeResult, (Object)true);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                String msgKey = null;
                if (target instanceof ApplicationError) {
                    msgKey = ((ApplicationError)target).getType().getMessageKey();
                    Tr.error((TraceComponent)tc, (String)msgKey, (Object[])new Object[0]);
                    this.futureMonitor.setResult(mainInvokeResult, target);
                } else {
                    this.futureMonitor.setResult(mainInvokeResult, e.getTargetException());
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.futureMonitor.setResult(mainInvokeResult, (Throwable)e);
            }
            finally {
                AccessController.doPrivileged(() -> {
                    Thread.currentThread().setContextClassLoader(execPreviousTccl);
                    return null;
                });
            }
        });
    }

    public void stopModule(ExtendedModuleInfo moduleInfo) {
        SpringBootModuleInfo springBootModuleInfo = (SpringBootModuleInfo)moduleInfo;
        springBootModuleInfo.getSpringBootApplication().unregisterSpringConfigFactory();
        springBootModuleInfo.getSpringBootApplication().callShutdownHooks();
        springBootModuleInfo.destroyThreadContextClassLoader();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class SpringModuleMetaData
    extends MetaDataImpl
    implements ModuleMetaData {
        private final SpringBootModuleInfo moduleInfo;
        static final long serialVersionUID = 7715172653512712298L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SpringModuleMetaData(SpringBootModuleInfo moduleInfo) {
            super(0);
            this.moduleInfo = moduleInfo;
        }

        public String getName() {
            return this.moduleInfo.getName();
        }

        public ApplicationMetaData getApplicationMetaData() {
            return ((ExtendedApplicationInfo)this.moduleInfo.getApplicationInfo()).getMetaData();
        }

        public ComponentMetaData[] getComponentMetaDatas() {
            return null;
        }

        public J2EEName getJ2EEName() {
            return ((ExtendedApplicationInfo)this.moduleInfo.getApplicationInfo()).getMetaData().getJ2EEName();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(SpringModuleMetaData.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.internal.SpringBootRuntimeContainer$SpringModuleMetaData");
        }
    }
}

