/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.opentracing.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.OpentracingUtils;
import io.openliberty.opentracing.spi.tracer.OpentracingTracerFactory;
import io.opentracing.Tracer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, service={OpentracingUserFeatureAccessService.class})
public class OpentracingUserFeatureAccessService {
    private static final TraceComponent tc = Tr.register(OpentracingUserFeatureAccessService.class, (String)"OPENTRACING", (String)"io.openliberty.opentracing.internal.resources.Opentracing");
    private static OpentracingTracerFactory opentracingTracerFactory;
    private static boolean factoryFirstUse;
    static final long serialVersionUID = 1498671239117042762L;

    @Reference
    public void setOpentracingTracerFactory(OpentracingTracerFactory opentracingTracerFactory) {
        OpentracingUserFeatureAccessService.opentracingTracerFactory = opentracingTracerFactory;
        factoryFirstUse = false;
        if (opentracingTracerFactory == null) {
            Tr.warning((TraceComponent)tc, (String)"OPENTRACING_TRACERFACTORY_NOT_PROVIDED", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    public static Tracer getTracerInstance(String appName) {
        String methodName = "getTracerInstance";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{appName});
        }
        Tracer tracer = null;
        if (opentracingTracerFactory != null) {
            try {
                tracer = opentracingTracerFactory.newInstance(appName);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.opentracing.internal.OpentracingUserFeatureAccessService", (String)"76", null, (Object[])new Object[]{appName});
                Tr.error((TraceComponent)tc, (String)"OPENTRACING_COULD_NOT_CREATE_TRACER", (Object[])new Object[]{t});
            }
        }
        if (factoryFirstUse) {
            factoryFirstUse = false;
            if (opentracingTracerFactory == null) {
                Tr.warning((TraceComponent)tc, (String)"OPENTRACING_TRACERFACTORY_NOT_PROVIDED", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)OpentracingUtils.getTracerText(tracer));
        }
        return tracer;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        factoryFirstUse = true;
    }
}

