/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.mediator;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MediatorException;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.internal.statistics.OAuthStatHelper;
import com.ibm.oauth.core.internal.statistics.OAuthStatisticsImpl;
import java.util.List;

public class OAuth20MediatorWrapper
implements OAuth20Mediator {
    List<OAuth20Mediator> mediators;
    OAuthStatisticsImpl _stats;

    public OAuth20MediatorWrapper(List<OAuth20Mediator> mediators, OAuthStatisticsImpl stats) {
        this.mediators = mediators;
        this._stats = stats;
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.init(config);
        }
    }

    @Override
    public void mediateAuthorize(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateAuthorize");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateAuthorize(attributeList);
        }
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public void mediateToken(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateToken");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateToken(attributeList);
        }
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public void mediateResource(AttributeList attributeList) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateResource");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateResource(attributeList);
        }
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public void mediateAuthorizeException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateAuthorize.exception");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateAuthorizeException(attributeList, exception);
        }
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public void mediateTokenException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateToken.exception");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateTokenException(attributeList, exception);
        }
        this._stats.addMeasurement(statHelper);
    }

    @Override
    public void mediateResourceException(AttributeList attributeList, OAuthException exception) throws OAuth20MediatorException {
        OAuthStatHelper statHelper = new OAuthStatHelper("stats.oauth20.mediator.mediateResource.exception");
        for (OAuth20Mediator mediator : this.mediators) {
            mediator.mediateResourceException(attributeList, exception);
        }
        this._stats.addMeasurement(statHelper);
    }
}

