/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.opentracing.OpentracingFilterHelper;
import com.ibm.ws.opentracing.OpentracingService;
import com.ibm.ws.opentracing.OpentracingTracerManager;
import com.ibm.ws.opentracing.OpentracingUtils;
import com.ibm.ws.opentracing.filters.SpanFilterType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(OpentracingContainerFilter.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    public static final String SERVER_SPAN_PROP_ID = OpentracingContainerFilter.class.getName() + ".Span";
    public static final String SERVER_SPAN_SKIPPED_ID = OpentracingContainerFilter.class.getName() + ".Skipped";
    public static final String EXCEPTION_KEY = OpentracingContainerFilter.class.getName() + ".Exception";
    private static final String TAG_COMPONENT_JAXRS = "jaxrs";
    @Context
    protected ResourceInfo resourceInfo;
    private OpentracingFilterHelper helper;
    static final long serialVersionUID = -6182158933851293684L;

    OpentracingContainerFilter(OpentracingFilterHelper helper) {
        this.setFilterHelper(helper);
    }

    void setFilterHelper(OpentracingFilterHelper helper) {
        this.helper = helper;
    }

    public void filter(ContainerRequestContext incomingRequestContext) throws IOException {
        String buildSpanName;
        String methodName = "filter(incoming)";
        Tracer tracer = OpentracingTracerManager.getTracer();
        if (tracer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " no tracer"), (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{OpentracingUtils.getTracerText(tracer)});
        }
        URI incomingUri = incomingRequestContext.getUriInfo().getRequestUri();
        String incomingPath = incomingRequestContext.getUriInfo().getPath();
        if (!incomingPath.startsWith("/")) {
            incomingPath = "/" + incomingPath;
        }
        String incomingURL = incomingUri.toURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " incomingURL"), (Object[])new Object[]{incomingURL});
        }
        SpanContext priorOutgoingContext = tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new MultivaluedMapToTextMap((MultivaluedMap<String, String>)incomingRequestContext.getHeaders()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " priorContext"), (Object[])new Object[]{priorOutgoingContext});
        }
        boolean process = OpentracingService.process(incomingUri, incomingPath, SpanFilterType.INCOMING);
        if (this.helper != null) {
            buildSpanName = this.helper.getBuildSpanName(incomingRequestContext, this.resourceInfo);
            if (buildSpanName == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " skipping not traced method"), (Object[])new Object[0]);
                }
                process = false;
            }
        } else {
            buildSpanName = incomingURL;
        }
        if (process) {
            Tracer.SpanBuilder spanBuilder = tracer.buildSpan(buildSpanName);
            spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server");
            spanBuilder.withTag(Tags.HTTP_URL.getKey(), incomingURL);
            spanBuilder.withTag(Tags.HTTP_METHOD.getKey(), incomingRequestContext.getMethod());
            spanBuilder.withTag(Tags.COMPONENT.getKey(), TAG_COMPONENT_JAXRS);
            if (priorOutgoingContext != null) {
                spanBuilder.asChildOf(priorOutgoingContext);
            }
            Scope scope = spanBuilder.startActive(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(methodName + " span"), (Object[])new Object[]{scope.span()});
            }
            incomingRequestContext.setProperty(SERVER_SPAN_PROP_ID, (Object)scope);
        }
        incomingRequestContext.setProperty(SERVER_SPAN_SKIPPED_ID, (Object)(!process ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext incomingRequestContext, ContainerResponseContext outgoingResponseContext) throws IOException {
        Scope scope;
        String methodName;
        block12: {
            methodName = "filter(outgoing)";
            Boolean skipped = (Boolean)incomingRequestContext.getProperty(SERVER_SPAN_SKIPPED_ID);
            if (skipped != null) {
                incomingRequestContext.removeProperty(SERVER_SPAN_SKIPPED_ID);
            }
            if (skipped != null && skipped.booleanValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " skipped"), (Object[])new Object[0]);
                }
                return;
            }
            scope = (Scope)incomingRequestContext.getProperty(SERVER_SPAN_PROP_ID);
            if (scope == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " no span"), (Object[])new Object[0]);
                }
                return;
            }
            incomingRequestContext.removeProperty(SERVER_SPAN_PROP_ID);
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " span"), (Object[])new Object[]{scope.span()});
                }
                Integer httpStatus = outgoingResponseContext.getStatus();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " httpStatus"), (Object[])new Object[]{httpStatus});
                }
                scope.span().setTag(Tags.HTTP_STATUS.getKey(), (Number)httpStatus);
                if (outgoingResponseContext.getStatus() < 400) break block12;
                MultivaluedMap headers = outgoingResponseContext.getHeaders();
                Throwable exception = (Throwable)headers.getFirst((Object)EXCEPTION_KEY);
                if (exception != null) {
                    headers.remove((Object)EXCEPTION_KEY);
                }
                OpentracingService.addSpanErrorInfo(scope.span(), exception);
            }
            catch (Throwable throwable) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " finish span"), (Object[])new Object[]{scope.span()});
                }
                scope.close();
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " finish span"), (Object[])new Object[]{scope.span()});
        }
        scope.close();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MultivaluedMapFlatIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, List<V>>> mapIterator;
        private Map.Entry<K, List<V>> mapEntry;
        private Iterator<V> mapEntryIterator;
        static final long serialVersionUID = -6974682979189613423L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapFlatIterator(Set<Map.Entry<K, List<V>>> multiValuesEntrySet) {
            this.mapIterator = multiValuesEntrySet.iterator();
            this.mapEntry = null;
            this.mapEntryIterator = null;
        }

        @Override
        @Trivial
        public boolean hasNext() {
            return this.mapEntryIterator != null && this.mapEntryIterator.hasNext() || this.mapIterator.hasNext();
        }

        @Override
        @Trivial
        public Map.Entry<K, V> next() {
            if (this.mapEntry == null || !this.mapEntryIterator.hasNext() && this.mapIterator.hasNext()) {
                this.mapEntry = this.mapIterator.next();
                this.mapEntryIterator = this.mapEntry.getValue().iterator();
            }
            if (this.mapEntryIterator.hasNext()) {
                return new AbstractMap.SimpleImmutableEntry<K, V>(this.mapEntry.getKey(), this.mapEntryIterator.next());
            }
            return new AbstractMap.SimpleImmutableEntry<K, Object>(this.mapEntry.getKey(), null);
        }

        @Override
        @Trivial
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.OpentracingContainerFilter$MultivaluedMapFlatIterator", MultivaluedMapFlatIterator.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MultivaluedMapToTextMap
    implements TextMap {
        private final MultivaluedMap<String, String> mvMap;
        static final long serialVersionUID = 6611779749445754816L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public MultivaluedMapToTextMap(MultivaluedMap<String, String> mvMap) {
            this.mvMap = mvMap;
        }

        @Trivial
        public Iterator<Map.Entry<String, String>> iterator() {
            return new MultivaluedMapFlatIterator<String, String>(this.mvMap.entrySet());
        }

        @Trivial
        public void put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.opentracing.OpentracingContainerFilter$MultivaluedMapToTextMap", MultivaluedMapToTextMap.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
        }
    }
}

