/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.config.sources.StaticConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.ConfigException;
import io.openliberty.microprofile.config.internal.common.InternalConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PropertiesConfigSource
extends InternalConfigSource
implements StaticConfigSource {
    private static final TraceComponent tc = Tr.register(PropertiesConfigSource.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final ConcurrentMap<String, String> properties;
    private final String id;
    static final long serialVersionUID = 3697370757860529L;

    @Trivial
    public PropertiesConfigSource(URL resource) {
        this(PropertiesConfigSource.loadProperties(resource), resource.toString());
    }

    @Trivial
    public PropertiesConfigSource(ConcurrentMap<String, String> properties, String id) {
        this.id = Tr.formatMessage((TraceComponent)tc, (String)"properties.file.config.source", (Object[])new Object[]{id});
        this.properties = properties;
    }

    @Trivial
    public String getName() {
        return this.id;
    }

    @Trivial
    protected int getDefaultOrdinal() {
        return 100;
    }

    public ConcurrentMap<String, String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConcurrentMap<String, String> loadProperties(URL resource) {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>();
        InputStream stream = null;
        try {
            stream = resource.openStream();
            Properties properties22 = new Properties();
            properties22.load(stream);
            Set<String> propNames = properties22.stringPropertyNames();
            for (String name : propNames) {
                props.put(name, properties22.getProperty(name));
            }
            if (stream == null) return props;
        }
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"79", null, (Object[])new Object[]{resource});
                throw new ConfigException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"85", null, (Object[])new Object[]{resource});
                    throw new ConfigException((Throwable)e2);
                }
            }
        }
        try {
            stream.close();
            return props;
        }
        catch (IOException properties22) {
            FFDCFilter.processException((Throwable)properties22, (String)"com.ibm.ws.microprofile.config.sources.PropertiesConfigSource", (String)"85", null, (Object[])new Object[]{resource});
            throw new ConfigException((Throwable)e);
        }
    }
}

