/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.HoldingExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoExclusiveLockException;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Lock {
    private static final TraceComponent tc = Tr.register(Lock.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final HashMap<Thread, Integer> _sharedThreads;
    private Thread _threadHoldingExclusiveLock;
    private Thread _threadRequestingExclusiveLock;
    private final String _traceId;
    static final long serialVersionUID = -4779934726595340645L;

    @ManualTrace
    public Lock(String ownerIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"Lock", (Object[])new Object[]{ownerIdentifier});
        }
        this._sharedThreads = new HashMap();
        this._threadHoldingExclusiveLock = null;
        this._threadRequestingExclusiveLock = null;
        this._traceId = "Lock:ownerIdentifier=" + ownerIdentifier + " @" + System.identityHashCode(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"Lock", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public void getSharedLock(int requestId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSharedLock", (Object[])new Object[]{this, requestId});
        }
        Thread currentThread = Thread.currentThread();
        Integer count = null;
        Lock lock = this;
        synchronized (lock) {
            if (!this._sharedThreads.containsKey(currentThread) && (this._threadRequestingExclusiveLock != null || this._threadHoldingExclusiveLock != null && !this._threadHoldingExclusiveLock.equals(currentThread))) {
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the exclusive lock to be released"), (Object[])new Object[0]);
                    }
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."), (Object[])new Object[0]);
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        void exc;
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"177", (Object)this, (Object[])new Object[]{requestId});
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.getSharedLock", (String)"180", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"), (Object[])new Object[0]);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is has detected that the exclusive lock has been released"), (Object[])new Object[0]);
                }
            }
            count = (count = this._sharedThreads.get(currentThread)) == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this._sharedThreads.put(currentThread, count);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Count: " + count), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void releaseSharedLock(int requestId) throws NoSharedLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseSharedLock", (Object[])new Object[]{this, requestId});
        }
        Thread currentThread = Thread.currentThread();
        int newValue = 0;
        Lock lock = this;
        synchronized (lock) {
            Integer count = this._sharedThreads.get(currentThread);
            if (count == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"releaseSharedLock", (Object)"NoSharedLockException");
                }
                throw new NoSharedLockException();
            }
            newValue = count - 1;
            if (newValue > 0) {
                count = newValue;
                this._sharedThreads.put(currentThread, count);
            } else {
                count = null;
                this._sharedThreads.remove(currentThread);
            }
            if (count == null) {
                this.notifyAll();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Count: " + this._sharedThreads.get(currentThread)), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseSharedLock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public boolean attemptExclusiveLock() throws HoldingExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"attemptExclusiveLock", (Object[])new Object[]{this});
        }
        boolean obtained = false;
        Thread currentThread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock != null && this._threadHoldingExclusiveLock.equals(currentThread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"attemptExclusiveLock", (Object)"HoldingExclusiveLockException");
                }
                throw new HoldingExclusiveLockException();
            }
            if (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                Integer suspendedSharedLockCount = this._sharedThreads.get(currentThread);
                this._sharedThreads.remove(currentThread);
                this.notifyAll();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the exclusive lock to be released"), (Object[])new Object[0]);
                }
                while (this._threadHoldingExclusiveLock != null || this._threadRequestingExclusiveLock != null) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."), (Object[])new Object[0]);
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        void exc;
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"311", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", (String)"325", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"), (Object[])new Object[0]);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " has detected that the exclusive lock has been released"), (Object[])new Object[0]);
                }
                if (suspendedSharedLockCount != null) {
                    this._sharedThreads.put(currentThread, suspendedSharedLockCount);
                }
                obtained = false;
            } else {
                this._threadRequestingExclusiveLock = currentThread;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " is waiting for the shared locks to quiesce"), (Object[])new Object[0]);
                }
                while (this._sharedThreads.size() > 1 || this._sharedThreads.size() == 1 && !this._sharedThreads.containsKey(currentThread)) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " waiting.."), (Object[])new Object[0]);
                        }
                        this.wait();
                    }
                    catch (InterruptedException suspendedSharedLockCount) {
                        void exc;
                        FFDCFilter.processException((Throwable)suspendedSharedLockCount, (String)"com.ibm.ws.recoverylog.spi.Lock", (String)"347", (Object)this, (Object[])new Object[0]);
                        FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.Lock.attemptExclusiveLock", (String)"362", (Object)this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " was interrupted unexpectedly during wait. Retesting condition"), (Object[])new Object[0]);
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Thread " + Integer.toHexString(currentThread.hashCode()) + " has detected that the shared locks have quiesced"), (Object[])new Object[0]);
                }
                this._threadHoldingExclusiveLock = currentThread;
                this._threadRequestingExclusiveLock = null;
                obtained = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"attemptExclusiveLock", (Object)("" + obtained));
        }
        return obtained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public void releaseExclusiveLock() throws NoExclusiveLockException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseExclusiveLock", (Object[])new Object[]{this});
        }
        Thread currentThread = Thread.currentThread();
        Lock lock = this;
        synchronized (lock) {
            if (this._threadHoldingExclusiveLock == null || !this._threadHoldingExclusiveLock.equals(currentThread)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"releaseExclusiveLock", (Object)"NoExclusiveLockException");
                }
                throw new NoExclusiveLockException();
            }
            this._threadHoldingExclusiveLock = null;
            this._threadRequestingExclusiveLock = null;
            this.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseExclusiveLock");
        }
    }

    public String toString() {
        return this._traceId;
    }
}

