/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.ReferenceCollection;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.StreamIsFull;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemReferenceLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemStreamLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.cache.statemodel.ListStatistics;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.list.PrioritizedCursor;
import com.ibm.ws.sib.msgstore.list.PrioritizedList;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.util.List;

public final class ReferenceStreamLink
extends LinkOwner
implements ReferenceCollection {
    private static TraceComponent tc = SibTr.register(ReferenceStreamLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _nextSequenceToIssue = 0L;
    private PrioritizedList _references = null;
    private final ListStatistics _statistics;

    public ReferenceStreamLink(LinkOwner owningStreamLink, Persistable tuple) {
        super(owningStreamLink, tuple);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, tuple});
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
        this._statistics = new ListStatistics(this);
    }

    public ReferenceStreamLink(ReferenceStream item, LinkOwner owningStreamLink, Persistable persistable) throws OutOfCacheSpace {
        super((AbstractItem)item, owningStreamLink, persistable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{owningStreamLink, item, persistable});
        }
        this._statistics = new ListStatistics(this);
        this._setWatermarks(item);
        this._references = new PrioritizedList();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void _initializeReferences() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
        }
        MessageStoreImpl _messageStore = this.getMessageStoreImpl();
        PersistentMessageStore pm = _messageStore.getPersistentMessageStore();
        try {
            List list = pm.readNonStreamItems(this.getTuple());
            for (Persistable tuple : list) {
                ItemReferenceLink link = null;
                if (tuple.getTupleType().equals(TupleTypeEnum.ITEM_REFERENCE)) {
                    link = new ItemReferenceLink(this, tuple);
                    link.restoreState(tuple);
                    if (link.isInStore()) {
                        _messageStore.register(link);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
                    }
                    throw new SevereMessageStoreException("Wrong tuple type in ReferenceStream:" + tuple.getTupleType());
                }
                long seq = tuple.getSequence();
                ReferenceStreamLink referenceStreamLink = this;
                synchronized (referenceStreamLink) {
                    if (seq >= this._nextSequenceToIssue) {
                        this._nextSequenceToIssue = seq + 1L;
                    }
                }
            }
        }
        catch (PersistenceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink._initializeReferences", (String)"147", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
            }
            throw new SevereMessageStoreException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_initializeReferences");
        }
    }

    private final PrioritizedList _references() throws SevereMessageStoreException {
        if (null == this._references) {
            this._references = new PrioritizedList();
            ((ItemStreamLink)this.getOwningStreamLink()).assertReadyForReferenceInitialisation();
            this._initializeReferences();
        }
        return this._references;
    }

    private final void _setWatermarks(ReferenceStream referenceStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)referenceStream);
        }
        long countLow = referenceStream.getCountLowWaterMark();
        long countHigh = referenceStream.getCountHighWaterMark();
        long byteLow = referenceStream.getByteLowWaterMark();
        long byteHigh = referenceStream.getByteHighWaterMark();
        this._statistics.setWatermarks(countLow, countHigh, byteLow, byteHigh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"_setWatermarks", (Object)this._statistics);
        }
    }

    public final void addReference(ItemReference reference, long lockID, Transaction transaction) throws OutOfCacheSpace, ProtocolException, StreamIsFull, TransactionException, PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addReference", (Object)new Object[]{reference, transaction});
        }
        this._references();
        MessageStoreImpl messageStore = this.getMessageStoreImpl();
        int strategy = reference.getStorageStrategy();
        long itemID = messageStore.getUniqueValue(strategy);
        TupleTypeEnum type = TupleTypeEnum.ITEM_REFERENCE;
        reference.setSizeRefsByMsgSize(messageStore.getJdbcSpillSizeMsgRefsByMsgSize());
        Persistable childPersistable = this.getTuple().createPersistable(itemID, type);
        ItemReferenceLink link = new ItemReferenceLink(reference, this, childPersistable);
        link.setParentWasSpillingAtAddTime(this.getListStatistics().isSpilling());
        messageStore.registerLink(link, (AbstractItem)reference);
        link.cmdAdd(this, lockID, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addReference");
        }
    }

    @Override
    public final void append(AbstractItemLink link) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"append", (Object)link);
        }
        this._references().append(link);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"append");
        }
    }

    @Override
    public final SevereMessageStoreException assertCanDelete(PersistentTransaction transaction) {
        SevereMessageStoreException ex = super.assertCanDelete(transaction);
        if (null != ex) {
            return ex;
        }
        int removesFromMeUnderThisTransaction = 0;
        TaskList taskList = (TaskList)transaction.getWorkList();
        if (null != taskList) {
            removesFromMeUnderThisTransaction = taskList.countRemovingItems(this);
            boolean canDelete = this.getListStatistics().canDelete(removesFromMeUnderThisTransaction);
            if (!canDelete) {
                ex = new SevereMessageStoreException("STREAM_NOT_EMPTY_SIMS0501");
            }
        }
        return ex;
    }

    @Override
    public final void checkSpillLimits() {
        this._statistics.checkSpillLimits();
    }

    protected final boolean canSoftenReference() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"canSoftenReference");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"canSoftenReference", (Object)false);
        }
        return false;
    }

    public final synchronized void ensureReferencesLoaded() throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ensureReferencesLoaded");
        }
        this._references();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ensureReferencesLoaded");
        }
    }

    @Override
    public final void eventWatermarkBreached() throws SevereMessageStoreException {
        ReferenceStream referenceStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        if (null != (referenceStream = (ReferenceStream)this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notifying eventWatermarkBreached: " + referenceStream));
            }
            referenceStream.eventWatermarkBreached();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("notified eventWatermarkBreached: " + referenceStream));
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"no referenceStream to notify");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    @Override
    public final boolean expirableExpire(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)("tran=" + transaction));
        }
        this._references();
        boolean allowed = true;
        if (this._statistics.getTotalItemCount() > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"cannot expire a non-empty stream");
            }
            allowed = false;
        } else {
            allowed = super.expirableExpire(transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"expirableExpire", (Object)allowed);
        }
        return allowed;
    }

    public final AbstractItem findById(long itemId) throws SevereMessageStoreException {
        this.getStatistics();
        return this.getMessageStoreImpl()._findById(itemId);
    }

    public final AbstractItem findFirstMatching(Filter filter) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)filter);
        }
        AbstractItem item = this._references().findFirstMatching(filter);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findFirstMatching", (Object)item);
        }
        return item;
    }

    public final AbstractItem findOldestItem() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"findOldestItem");
        }
        AbstractItem item = this._references().findOldestItem();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"findOldestItem", (Object)item);
        }
        return item;
    }

    final ItemStream getItemStream() {
        return null;
    }

    @Override
    public final ListStatistics getListStatistics() {
        return this._statistics;
    }

    public final ItemStream getOwningItemStream() throws SevereMessageStoreException {
        return ((ItemStreamLink)this.getOwningStreamLink()).getItemStream();
    }

    final ReferenceStream getReferenceStream() throws SevereMessageStoreException {
        return (ReferenceStream)this.getItem();
    }

    public final Statistics getStatistics() throws SevereMessageStoreException {
        this._references();
        return this.getListStatistics();
    }

    @Override
    public final boolean isReferenceStreamLink() {
        return true;
    }

    public final boolean isSpilling() {
        boolean spilling = false;
        if (1 != this.getTuple().getStorageStrategy()) {
            spilling = this.getListStatistics().isSpilling();
        }
        return spilling;
    }

    @Override
    protected final void itemHasBeenRestored(AbstractItem item) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored", (Object)item);
        }
        super.itemHasBeenRestored(item);
        this._setWatermarks((ReferenceStream)item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"itemHasBeenRestored");
        }
    }

    @Override
    public final void linkAvailable(AbstractItemLink link) throws SevereMessageStoreException {
        this._references().linkAvailable(link);
    }

    @Override
    public final boolean loadOwnedLinks() throws SevereMessageStoreException {
        boolean loaded = false;
        if (null == this._references) {
            this._references();
            loaded = true;
        }
        return loaded;
    }

    public final LockingCursor newLockingCursor(Filter filter, boolean jumpbackEnabled) throws PersistenceException, SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)new Object[]{filter, jumpbackEnabled});
        }
        AbstractItem item = this.getItem();
        int storageStrategy = item.getStorageStrategy();
        long lockID = this.getMessageStoreImpl().getUniqueLockID(storageStrategy);
        PrioritizedCursor cursor = this._references().newCursor(filter, lockID, jumpbackEnabled);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    public final NonLockingCursor newNonLockingCursor(Filter filter) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)filter);
        }
        PrioritizedCursor cursor = this._references().newCursor(filter, -2L, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"newNonLockingCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public final synchronized long nextSequence() {
        return this._nextSequenceToIssue++;
    }

    public final AbstractItem removeFirstMatching(Filter filter, Transaction transaction) throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)new Object[]{filter, transaction});
        }
        PrioritizedList refs = this._references();
        AbstractItem item = refs.removeFirstMatching(filter, (PersistentTransaction)transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeFirstMatching", (Object)item);
        }
        return item;
    }

    public final void setWatermarks(long countLow, long countHigh, long bytesLow, long bytesHigh) {
        this._statistics.setWatermarks(countLow, countHigh, bytesLow, bytesHigh);
    }

    @Override
    public String toString() {
        return "ReferenceStreamLink(" + this.getID() + ")" + super.toString() + " state=" + this.getState();
    }

    protected final boolean xmlHasChildren() {
        if (null != this._references) {
            return this._references.xmlHasChildren();
        }
        return false;
    }

    @Override
    protected final String xmlTagName() {
        return "referenceStream";
    }

    @Override
    protected final void xmlWriteChildrenOn(FormattedWriter writer) throws IOException {
        super.xmlWriteChildrenOn(writer);
        if (null != this._references) {
            this._references.xmlWriteChildrenOn(writer, "references");
        }
    }
}

