/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.InitialServiceManager;
import org.apache.yoko.orb.OB.InterceptorPolicy_impl;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.PIDowncall;
import org.apache.yoko.orb.OB.ParameterDesc;
import org.apache.yoko.orb.OCI.TransportInfo;
import org.apache.yoko.orb.PortableInterceptor.ClientRequestInfo_impl;
import org.apache.yoko.orb.PortableInterceptor.Current_impl;
import org.apache.yoko.orb.PortableInterceptor.ServerRequestInfo_impl;
import org.apache.yoko.orb.logging.VerboseLogging;
import org.apache.yoko.util.CollectionExtras;
import org.omg.CORBA.Any;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.IOP.IOR;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public final class PIManager {
    private final ORB orb;
    private ORBInstance orbInstance;
    private final AtomicInteger nextInterceptorId = new AtomicInteger();
    private Current_impl current;
    private final List<ClientRequestInterceptor> clientRequestInterceptors = CollectionExtras.newSynchronizedList();
    private final List<ServerRequestInterceptor> serverRequestInterceptors = CollectionExtras.newSynchronizedList();
    private final List<IORInterceptor> iorInterceptors = CollectionExtras.newSynchronizedList();
    private int numberOfStateSlots;
    private boolean allOrbInitializersHaveBeenInvoked;

    private int nextID() {
        return this.nextInterceptorId.getAndIncrement();
    }

    public PIManager(ORB orb) {
        this.orb = orb;
        this.current = null;
        this.numberOfStateSlots = 0;
        this.allOrbInitializersHaveBeenInvoked = false;
    }

    void destroy() {
        for (Interceptor interceptor : CollectionExtras.allOf((Iterable[])new Iterable[]{this.clientRequestInterceptors, this.serverRequestInterceptors, this.iorInterceptors})) {
            try {
                interceptor.destroy();
            }
            catch (RuntimeException runtimeException) {}
        }
        this.orbInstance = null;
    }

    public void addIORInterceptor(IORInterceptor interceptor, boolean insertAtHead) throws DuplicateName {
        if (VerboseLogging.IOR_LOG.isLoggable(Level.CONFIG)) {
            VerboseLogging.IOR_LOG.config("Registering " + Interceptors.describe(interceptor));
        }
        PIManager.addInterceptorToList(interceptor, this.iorInterceptors, insertAtHead);
    }

    public void addClientRequestInterceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        if (VerboseLogging.REQ_OUT_LOG.isLoggable(Level.CONFIG)) {
            VerboseLogging.REQ_OUT_LOG.config("Registering " + Interceptors.describe(interceptor));
        }
        PIManager.addInterceptorToList(interceptor, this.clientRequestInterceptors, false);
    }

    public void addServerRequestInterceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        if (VerboseLogging.REQ_IN_LOG.isLoggable(Level.CONFIG)) {
            VerboseLogging.REQ_IN_LOG.config("Registering " + Interceptors.describe(interceptor));
        }
        PIManager.addInterceptorToList(interceptor, this.serverRequestInterceptors, false);
    }

    private static <I extends Interceptor> void addInterceptorToList(I interceptor, List<I> interceptors, boolean insertAtHead) throws DuplicateName {
        String name = interceptor.name();
        if (name.length() != 0) {
            for (Interceptor existing : interceptors) {
                if (!name.equals(existing.name())) continue;
                throw new DuplicateName(name);
            }
        }
        if (insertAtHead) {
            interceptors.add(0, interceptor);
        } else {
            interceptors.add(interceptor);
        }
    }

    public int allocateSlotId() {
        return this.numberOfStateSlots++;
    }

    public void registerPolicyFactory(int type, PolicyFactory factory) {
        Assert.ensure(this.orbInstance != null);
        this.orbInstance.getPolicyFactoryManager().registerPolicyFactory(type, factory, false);
    }

    public void setORBInstance(ORBInstance orbInstance) {
        this.orbInstance = orbInstance;
        Assert.ensure(this.current == null);
        this.current = new Current_impl(this.orb);
        InitialServiceManager ism = this.orbInstance.getInitialServiceManager();
        try {
            ism.addInitialReference("PICurrent", (Object)this.current);
        }
        catch (InvalidName ex) {
            throw Assert.fail(ex);
        }
    }

    public void setupComplete() {
        this.current._OB_setMaxSlots(this.numberOfStateSlots);
        if (this.clientRequestInterceptors.isEmpty()) {
            InitialServiceManager ism = this.orbInstance.getInitialServiceManager();
            try {
                PolicyManager pm = PolicyManagerHelper.narrow((Object)ism.resolveInitialReferences("ORBPolicyManager"));
                Policy[] pl = new Policy[]{new InterceptorPolicy_impl(false)};
                pm.set_policy_overrides(pl, SetOverrideType.ADD_OVERRIDE);
            }
            catch (InvalidPolicies | InvalidName ex) {
                throw Assert.fail(ex);
            }
        }
        this.allOrbInitializersHaveBeenInvoked = true;
    }

    ClientRequestInfo clientSendRequest(PIDowncall downcall) throws LocationForward {
        ClientRequestInfo_impl info = new ClientRequestInfo_impl(this.orb, this.orbInstance, this.current, downcall);
        info._OB_request(this.clientRequestInterceptors);
        return info;
    }

    void clientReceiveReply(ClientRequestInfo info) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)0);
        impl._OB_reply();
    }

    void clientReceiveException(ClientRequestInfo info, boolean wasSystem, Exception ex, String exId) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus(wasSystem ? (short)1 : 2);
        impl._OB_setReceivedException(ex, exId);
        impl._OB_reply();
    }

    void clientReceiveLocationForward(ClientRequestInfo info, IOR ior) throws LocationForward {
        ClientRequestInfo_impl impl = (ClientRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)3);
        impl._OB_setForwardReference(ior);
        impl._OB_reply();
    }

    ServerRequestInfo serverCreateRequestInfo(String op, boolean responseExpected, Policy[] policies, byte[] adapterId, byte[] objectId, ObjectReferenceTemplate adapterTemplate, ServiceContexts requestContexts, ServiceContexts replyContexts, TransportInfo transportInfo) {
        Assert.ensure(this.current != null);
        return new ServerRequestInfo_impl(this.orb, this.nextID(), op, responseExpected, policies, adapterId, objectId, adapterTemplate, requestContexts, replyContexts, this.orbInstance, this.current, transportInfo);
    }

    void serverSetupServant(ServerRequestInfo info, Servant servant, POA poa) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_servant(servant, poa);
    }

    void serverContextSwitch(ServerRequestInfo info) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_contextSwitch();
    }

    void serverParameterDesc(ServerRequestInfo info, ParameterDesc[] argDesc, ParameterDesc retDesc, TypeCode[] exceptionTC) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_parameterDesc(argDesc, retDesc, exceptionTC);
    }

    void serverArguments(ServerRequestInfo info, NVList args) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_arguments(args);
    }

    void serverResult(ServerRequestInfo info, Any result) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_result(result);
    }

    void serverReceiveRequestServiceContexts(ServerRequestInfo info) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_requestServiceContext(this.serverRequestInterceptors);
    }

    void serverReceiveRequest(ServerRequestInfo info) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_request();
    }

    void serverSendReply(ServerRequestInfo info) {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)0);
        impl._OB_sendReply();
    }

    void serverSendLocationForward(ServerRequestInfo info, IOR ior) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus((short)3);
        impl._OB_setForwardReference(ior);
        impl._OB_sendOther();
    }

    void serverSendException(ServerRequestInfo info, boolean wasSystem, Exception ex) throws LocationForward {
        ServerRequestInfo_impl impl = (ServerRequestInfo_impl)info;
        impl._OB_setReplyStatus(wasSystem ? (short)1 : 2);
        impl._OB_setReceivedException(ex, null);
        impl._OB_sendException();
    }

    public void establishComponents(IORInfo info) {
        for (IORInterceptor interceptor : this.iorInterceptors) {
            try {
                interceptor.establish_components(info);
            }
            catch (SystemException systemException) {}
        }
    }

    public void componentsEstablished(IORInfo info) {
        for (IORInterceptor_3_0 interceptor : CollectionExtras.filterByType(this.iorInterceptors, IORInterceptor_3_0.class)) {
            try {
                interceptor.components_established(info);
            }
            catch (SystemException systemException) {}
        }
    }

    public void adapterStateChange(ObjectReferenceTemplate[] templates, short state) {
        for (IORInterceptor_3_0 interceptor : CollectionExtras.filterByType(this.iorInterceptors, IORInterceptor_3_0.class)) {
            try {
                interceptor.adapter_state_changed(templates, state);
            }
            catch (SystemException systemException) {}
        }
    }

    public void adapterManagerStateChange(String id, short state) {
        for (IORInterceptor_3_0 interceptor : CollectionExtras.filterByType(this.iorInterceptors, IORInterceptor_3_0.class)) {
            try {
                interceptor.adapter_manager_state_changed(id, state);
            }
            catch (SystemException systemException) {}
        }
    }

    public boolean haveClientInterceptors() {
        return this.allOrbInitializersHaveBeenInvoked && !this.clientRequestInterceptors.isEmpty();
    }

    public boolean haveServerInterceptors() {
        return this.allOrbInitializersHaveBeenInvoked && !this.serverRequestInterceptors.isEmpty();
    }

    static enum Interceptors {


        static String describe(ClientRequestInterceptor i) {
            return "client request interceptor " + Interceptors.describe0((Interceptor)i);
        }

        static String describe(ServerRequestInterceptor i) {
            return "server request interceptor " + Interceptors.describe0((Interceptor)i);
        }

        static String describe(IORInterceptor i) {
            return "ior interceptor " + Interceptors.describe0((Interceptor)i);
        }

        private static String describe0(Interceptor i) {
            return i.name() + " of type " + i.getClass().getName();
        }
    }
}

