/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ProducerType;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.impl.JsDestinationAddressImpl;
import com.ibm.ws.sib.mfp.impl.JsMessageHandleImpl;
import com.ibm.ws.sib.mfp.impl.JsMsgObject;
import com.ibm.ws.sib.mfp.impl.JsMsgPart;
import com.ibm.ws.sib.mfp.impl.MessageImpl;
import com.ibm.ws.sib.mfp.impl.RoutingPathList;
import com.ibm.ws.sib.mfp.impl.SchemaManager;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.schema.JsHdr2Access;
import com.ibm.ws.sib.mfp.schema.JsHdrAccess;
import com.ibm.ws.sib.mfp.schema.JsPayloadAccess;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class JsHdrsImpl
extends MessageImpl {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = SibTr.register(JsHdrsImpl.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS exceptionMessages = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private transient Long cachedMessageWaitTime = null;
    private transient Reliability cachedReliability = null;
    private transient Integer cachedPriority = null;
    private transient SIMessageHandle cachedMessageHandle = null;
    transient int deliveryCount = 0;
    protected transient boolean wasTimeToLiveChanged = false;
    private transient JsMsgPart hdr2 = null;
    private transient JsMsgPart api = null;
    private transient JsMsgPart payload = null;
    private static final byte MEDIATED_FLAG = 1;
    private static final byte MQRFH2ALLOWED_FLAG = 2;
    private transient boolean gotFlags = false;
    private transient byte flags = 0;

    JsHdrsImpl() {
    }

    JsHdrsImpl(int flag) throws MessageDecodeFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsHdrsImpl", (Object)flag);
        }
        this.setJmo(new JsMsgObject(JsHdrAccess.schema, JsPayloadAccess.schema));
        this.jmo.setPart(8, JsHdr2Access.schema);
        this.getHdr2().setChoiceField(66, 0);
        this.getHdr2().setChoiceField(68, 0);
        if (flag != 2) {
            this.getHdr2().setChoiceField(67, 0);
            this.getHdr2().setChoiceField(69, 0);
            this.getHdr2().setChoiceField(70, 0);
            this.getHdr2().setChoiceField(71, 0);
            this.getHdr2().setChoiceField(87, 0);
        }
        this.getHdr2().setChoiceField(72, 0);
        this.getHdr2().setChoiceField(74, 0);
        this.getHdr2().setChoiceField(75, 0);
        this.getHdr2().setChoiceField(76, 0);
        this.getHdr2().setChoiceField(77, 0);
        this.getHdr2().setChoiceField(78, 0);
        this.getHdr2().setChoiceField(88, 0);
        if (flag != 2) {
            this.getHdr2().setChoiceField(81, 0);
            this.getHdr2().setChoiceField(82, 0);
            this.getHdr2().setChoiceField(83, 0);
            this.getHdr2().setChoiceField(84, 0);
            this.getHdr2().setChoiceField(85, 0);
            this.getHdr2().setChoiceField(86, 0);
            this.getHdr2().setChoiceField(90, 0);
            this.getHdr2().setChoiceField(93, 0);
        }
        if (flag != 2) {
            this.jmo.setChoiceField(10, 0);
            this.jmo.getPayloadPart().setField(0, null);
            this.jmo.getPayloadPart().setChoiceField(4, 0);
            this.jmo.getPayloadPart().setChoiceField(5, 0);
            this.jmo.getPayloadPart().setChoiceField(6, 0);
        }
        if (flag != 2 && flag != 3) {
            this.setForwardRoutingPath(null);
            this.setReverseRoutingPath(null);
        }
        this.setDiscriminator(null);
        if (flag != 2) {
            this.getHdr2().setIntField(8, -1);
            this.setReliability(Reliability.NONE);
            this.setTimeToLive(0L);
            this.setTimestamp(-1L);
            this.setRedeliveredCount(0);
            this.getHdr2().setChoiceField(92, 0);
        }
        this.getHdr2().setLongField(12, 0L);
        this.jmo.setLongField(1, 0L);
        this.jmo.setField(2, null);
        this.jmo.setLongField(3, 0L);
        this.setBus(null);
        this.setSecurityUserid(null);
        this.setSecurityUseridSentBySystem(false);
        this.getHdr2().setField(16, (byte)0);
        this.getHdr2().setChoiceField(89, 0);
        this.getHdr2().setChoiceField(91, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsHdrsImpl");
        }
    }

    JsHdrsImpl(JsMsgObject inJmo) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JsHdrsImpl", (Object)"Inbound JMO");
        }
        this.setJmo(inJmo);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JsHdrsImpl");
        }
    }

    public final boolean isGuaranteedRemoteBrowse() {
        return this.getHdr2().getChoiceField(76) == 1;
    }

    public boolean isAuditSessionIdSet() {
        return this.getHdr2().getChoiceField(87) == 1;
    }

    public boolean isForwardRoutingPathEmpty() {
        if (this.getHdr2().getField(3) == null) {
            return true;
        }
        return ((byte[])this.getHdr2().getField(3)).length == 0;
    }

    public boolean isReverseRoutingPathEmpty() {
        if (this.getHdr2().getField(7) == null) {
            return true;
        }
        return ((byte[])this.getHdr2().getField(7)).length == 0;
    }

    boolean isSent() {
        return this.jmo.getField(2) != null;
    }

    public boolean isApiMessage() {
        MessageType mType = this.getJsMessageType();
        return mType == MessageType.JMS || mType == MessageType.SDO;
    }

    public boolean isControlMessage() {
        return false;
    }

    public List<String> getFingerprints() {
        ArrayList ids;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFingerprints");
        }
        if ((ids = (ArrayList)this.getHdr2().getField(62)) != null) {
            ids = new ArrayList(ids);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFingerprints", ids);
        }
        return ids;
    }

    public void addFingerprint(SIBUuid8 meUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addFingerprint", (Object)meUuid);
        }
        String meUuidString = meUuid.toString();
        if (this.getHdr2().getChoiceField(90) == 0) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(meUuidString);
            this.getHdr2().setField(62, ids);
        } else {
            List ids = (List)this.getHdr2().getField(62);
            ArrayList<String> newIds = new ArrayList<String>(ids);
            newIds.add(meUuidString);
            this.getHdr2().setField(62, newIds);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addFingerprint");
        }
    }

    public void clearFingerprints() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearFingerprints");
        }
        this.getHdr2().setChoiceField(90, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearFingerprints");
        }
    }

    public final List<SIDestinationAddress> getForwardRoutingPath() {
        List fNames = (List)this.getHdr2().getField(0);
        List fMEs = (List)this.getHdr2().getField(1);
        byte[] fLos = (byte[])this.getHdr2().getField(3);
        List fBuses = (List)this.getHdr2().getField(2);
        return new RoutingPathList(fNames, fLos, fMEs, fBuses);
    }

    public final List<SIDestinationAddress> getReverseRoutingPath() {
        List fNames = (List)this.getHdr2().getField(4);
        List fMEs = (List)this.getHdr2().getField(5);
        byte[] fLos = (byte[])this.getHdr2().getField(7);
        List fBuses = (List)this.getHdr2().getField(6);
        return new RoutingPathList(fNames, fLos, fMEs, fBuses);
    }

    public final String getDiscriminator() {
        return (String)this.jmo.getField(0);
    }

    public final Integer getPriority() {
        if (this.cachedPriority == null) {
            this.cachedPriority = (Integer)this.getHdr2().getField(8);
        }
        return this.cachedPriority;
    }

    public final Reliability getReliability() {
        if (this.cachedReliability == null) {
            Byte rType = (Byte)this.getHdr2().getField(9);
            this.cachedReliability = Reliability.getReliability(rType);
        }
        return this.cachedReliability;
    }

    public final Long getTimeToLive() {
        return (Long)this.getHdr2().getField(10);
    }

    public final Long getDeliveryDelay() {
        if (this.getHdr2().getChoiceField(92) == 0) {
            return 0L;
        }
        return this.getHdr2().getLongField(64);
    }

    public final long getRemainingTimeToLive() {
        long ttl = this.getHdr2().getLongField(10);
        if (ttl > 0L) {
            return ttl - this.getMessageWaitTime();
        }
        return -1L;
    }

    public String getReplyDiscriminator() {
        return null;
    }

    public Integer getReplyPriority() {
        return null;
    }

    public Reliability getReplyReliability() {
        return null;
    }

    public Long getReplyTimeToLive() {
        return null;
    }

    public final Long getTimestamp() {
        return (Long)this.getHdr2().getField(11);
    }

    public final Long getMessageWaitTime() {
        if (this.cachedMessageWaitTime == null) {
            this.cachedMessageWaitTime = (Long)this.getHdr2().getField(12);
        }
        return this.cachedMessageWaitTime;
    }

    public final Long getCurrentMEArrivalTimestamp() {
        return (Long)this.jmo.getField(1);
    }

    public final Integer getRedeliveredCount() {
        return (Integer)this.getHdr2().getField(13);
    }

    public String getSystemMessageId() {
        SIBUuid8 u = this.getSystemMessageSourceUuid();
        if (u != null) {
            StringBuffer buff = new StringBuffer(u.toString());
            buff.append("_");
            buff.append(Long.toString(this.getSystemMessageValue()));
            return buff.toString();
        }
        return null;
    }

    public SIBUuid8 getSystemMessageSourceUuid() {
        byte[] b = (byte[])this.jmo.getField(2);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    public long getSystemMessageValue() {
        return this.jmo.getLongField(3);
    }

    public SIMessageHandle getMessageHandle() {
        if (this.cachedMessageHandle == null) {
            byte[] b = (byte[])this.jmo.getField(2);
            this.cachedMessageHandle = b != null ? new JsMessageHandleImpl(new SIBUuid8(b), (Long)this.jmo.getField(3)) : new JsMessageHandleImpl(null, (Long)this.jmo.getField(3));
        }
        return this.cachedMessageHandle;
    }

    public final String getBus() {
        return (String)this.getHdr2().getField(14);
    }

    public final String getSecurityUserid() {
        return (String)this.jmo.getField(4);
    }

    public final boolean isSecurityUseridSentBySystem() {
        return this.jmo.getBooleanField(5);
    }

    public final ProducerType getProducerType() {
        Byte pType = (Byte)this.getHdr2().getField(15);
        return ProducerType.getProducerType(pType);
    }

    public final MessageType getJsMessageType() {
        Byte mType = (Byte)this.jmo.getField(6);
        return MessageType.getMessageType(mType);
    }

    public final boolean isMediated() {
        return this.getFlagValue((byte)1);
    }

    public final boolean isMQRFH2Allowed() {
        return this.getFlagValue((byte)2);
    }

    public final String getRMCorrelator() {
        return (String)this.getHdr2().getField(23);
    }

    public final String getARMCorrelator() {
        return (String)this.getHdr2().getField(22);
    }

    public String getAuditSessionId() {
        return (String)this.getHdr2().getField(58);
    }

    public JsDestinationAddress getRoutingDestination() {
        String name = (String)this.getHdr2().getField(19);
        if (name != null) {
            byte[] b = (byte[])this.getHdr2().getField(20);
            return new JsDestinationAddressImpl(name, false, b == null ? null : new SIBUuid8(b), (String)this.getHdr2().getField(21));
        }
        return null;
    }

    public final Byte getReportExpiry() {
        return (Byte)this.getHdr2().getField(24);
    }

    public final Byte getReportCOD() {
        return (Byte)this.getHdr2().getField(25);
    }

    public final Byte getReportCOA() {
        return (Byte)this.getHdr2().getField(26);
    }

    public final SIBUuid8 getGuaranteedSourceMessagingEngineUUID() {
        byte[] b = (byte[])this.getHdr2().getField(27);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    public final SIBUuid8 getGuaranteedTargetMessagingEngineUUID() {
        byte[] b = (byte[])this.getHdr2().getField(28);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    public final SIBUuid12 getGuaranteedTargetDestinationDefinitionUUID() {
        byte[] b = (byte[])this.getHdr2().getField(29);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    public final SIBUuid12 getGuaranteedStreamUUID() {
        byte[] b = (byte[])this.getHdr2().getField(30);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    public final SIBUuid12 getGuaranteedGatheringTargetUUID() {
        byte[] b = (byte[])this.getHdr2().getField(33);
        if (b != null) {
            return new SIBUuid12(b);
        }
        return null;
    }

    public final ProtocolType getGuaranteedProtocolType() {
        Byte value = (Byte)this.getHdr2().getField(31);
        return ProtocolType.getProtocolType(value);
    }

    public byte getGuaranteedProtocolVersion() {
        Byte value = (Byte)this.getHdr2().getField(32);
        return value == null ? (byte)0 : value;
    }

    public final String getGuaranteedCrossBusLinkName() {
        return (String)this.getHdr2().getField(34);
    }

    public final SIBUuid8 getGuaranteedCrossBusSourceBusUUID() {
        byte[] b = (byte[])this.getHdr2().getField(35);
        if (b != null) {
            return new SIBUuid8(b);
        }
        return null;
    }

    public final long getGuaranteedValueStartTick() {
        return this.getHdr2().getLongField(36);
    }

    public final long getGuaranteedValueEndTick() {
        return this.getHdr2().getLongField(37);
    }

    public final long getGuaranteedValueValueTick() {
        return this.getHdr2().getLongField(38);
    }

    public final long getGuaranteedValueCompletedPrefix() {
        return this.getHdr2().getLongField(39);
    }

    public final boolean getGuaranteedValueRequestedOnly() {
        return this.getHdr2().getBooleanField(40);
    }

    public final long getGuaranteedRemoteBrowseID() {
        return this.getHdr2().getLongField(41);
    }

    public final long getGuaranteedRemoteBrowseSequenceNumber() {
        return this.getHdr2().getLongField(42);
    }

    public final long getGuaranteedRemoteGetWaitTime() {
        return this.getHdr2().getLongField(43);
    }

    public final long getGuaranteedRemoteGetPrevTick() {
        return this.getHdr2().getLongField(44);
    }

    public final long getGuaranteedRemoteGetStartTick() {
        return this.getHdr2().getLongField(45);
    }

    public final long getGuaranteedRemoteGetValueTick() {
        return this.getHdr2().getLongField(46);
    }

    public final Integer getExceptionReason() {
        return (Integer)this.getHdr2().getField(47);
    }

    public final String[] getExceptionInserts() {
        String[] arr = null;
        List l = (List)this.getHdr2().getField(49);
        if (l != null) {
            try {
                arr = l.toArray(new String[l.size()]);
            }
            catch (ArrayStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.JsHdrsImpl.getExceptionInserts", (String)"jsm1400");
            }
        }
        return arr;
    }

    public final Long getExceptionTimestamp() {
        return (Long)this.getHdr2().getField(48);
    }

    public String getExceptionProblemDestination() {
        return (String)this.getHdr2().getField(50);
    }

    public String getExceptionProblemSubscription() {
        return (String)this.getHdr2().getField(51);
    }

    public final String getExceptionMessage() {
        if (this.getHdr2().getChoiceField(78) != 0) {
            return exceptionMessages.getFormattedMessage("DELIVERY_ERROR_SIRC_" + this.getExceptionReason().toString(), (Object[])this.getExceptionInserts(), "Failed to deliver message, rc=" + this.getExceptionReason() + ". Inserts: " + Arrays.asList(this.getExceptionInserts()));
        }
        return null;
    }

    public void setForwardRoutingPath(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath");
        }
        this.setFRP(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setForwardRoutingPath");
        }
    }

    public void setReverseRoutingPath(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath");
        }
        this.setRRP(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReverseRoutingPath");
        }
    }

    public void setDiscriminator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDiscriminator", (Object)value);
        }
        this.jmo.setField(0, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDiscriminator");
        }
    }

    public void setPriority(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPriority", (Object)value);
        }
        this.cachedPriority = value;
        this.getHdr2().setIntField(8, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPriority");
        }
    }

    public void setReliability(Reliability value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReliability", (Object)value);
        }
        this.cachedReliability = value;
        this.getHdr2().setField(9, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReliability");
        }
    }

    public void setTimeToLive(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimeToLive", (Object)value);
        }
        this.getHdr2().setLongField(10, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimeToLive");
        }
    }

    public void setDeliveryDelay(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay", (Object)value);
        }
        this.getHdr2().setLongField(64, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryDelay");
        }
    }

    public final void setRemainingTimeToLive(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRemainingTimeToLive", (Object)value);
        }
        if (value < 0L) {
            this.getHdr2().setLongField(10, 0L);
        } else if (value == 0L) {
            this.getHdr2().setLongField(10, 1L);
        } else {
            long ttl = this.getMessageWaitTime() + value;
            this.setTimeToLive(ttl);
        }
        this.wasTimeToLiveChanged = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRemainingTimeToLive");
        }
    }

    public void setReplyDiscriminator(String value) {
    }

    public void setReplyPriority(int value) {
    }

    public void setReplyReliability(Reliability value) {
    }

    public void setReplyTimeToLive(long value) {
    }

    public void clearReplyFields() {
    }

    public final void setTimestamp(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTimestamp", (Object)value);
        }
        this.getHdr2().setLongField(11, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTimestamp");
        }
    }

    public final void setMessageWaitTime(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMessageWaitTime", (Object)value);
        }
        this.cachedMessageWaitTime = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMessageWaitTime");
        }
    }

    public final void setCurrentMEArrivalTimestamp(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setCurrentMEArrivalTimestamp", (Object)value);
        }
        this.jmo.setLongField(1, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setCurrentMEArrivalTimestamp");
        }
    }

    public final void setRedeliveredCount(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRedeliveredCount", (Object)value);
        }
        this.getHdr2().setIntField(13, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRedeliveredCount");
        }
    }

    public void setDeliveryCount(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDeliveryCount", (Object)value);
        }
        this.deliveryCount = value;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDeliveryCount");
        }
    }

    public void setSystemMessageSourceUuid(SIBUuid8 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSystemMessageSourceUuid", (Object)value);
        }
        this.cachedMessageHandle = null;
        if (value != null) {
            this.jmo.setField(2, value.toByteArray());
        } else {
            this.jmo.setField(2, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSystemMessageSourceUuid");
        }
    }

    public void setSystemMessageValue(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSystemMessageValue", (Object)value);
        }
        this.cachedMessageHandle = null;
        this.jmo.setLongField(3, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSystemMessageValue");
        }
    }

    public final void setBus(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBus", (Object)value);
        }
        this.getHdr2().setField(14, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBus");
        }
    }

    public final void setSecurityUserid(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSecurityUserid", (Object)value);
        }
        this.jmo.setField(4, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSecurityUserid");
        }
    }

    public final void setSecurityUseridSentBySystem(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSecurityUseridSentBySystem", (Object)value);
        }
        this.jmo.setBooleanField(5, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSecurityUseridSentBySystem");
        }
    }

    final void setProducerType(ProducerType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProducerType", (Object)value);
        }
        this.getHdr2().setField(15, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProducerType");
        }
    }

    final void setJsMessageType(MessageType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setJsMessageType", (Object)value);
        }
        this.jmo.setField(6, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setJsMessageType");
        }
    }

    public final void setMediated(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMediated", (Object)value);
        }
        this.setFlagValue((byte)1, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMediated");
        }
    }

    public final void setMQRFH2Allowed(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMQRFH2Allowed", (Object)value);
        }
        this.setFlagValue((byte)2, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMQRFH2Allowed");
        }
    }

    public final void setRMCorrelator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRMCorrelator", (Object)value);
        }
        this.getHdr2().setField(23, value);
        if (this.getHdr2().getField(22) == null) {
            this.getHdr2().setField(22, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRMCorrelator");
        }
    }

    public final void setARMCorrelator(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setARMCorrelator", (Object)value);
        }
        this.getHdr2().setField(22, value);
        if (this.getHdr2().getField(23) == null) {
            this.getHdr2().setField(23, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setARMCorrelator");
        }
    }

    public void setAuditSessionId(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAuditSessionId", (Object)value);
        }
        this.getHdr2().setField(58, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAuditSessionId");
        }
    }

    public void setRoutingDestination(JsDestinationAddress value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRoutingDestination", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(19, value.getDestinationName());
            if (value.getME() != null) {
                this.getHdr2().setField(20, value.getME().toByteArray());
            } else {
                this.getHdr2().setField(20, null);
            }
            this.getHdr2().setField(21, value.getBusName());
        } else {
            this.getHdr2().setChoiceField(67, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRoutingDestination");
        }
    }

    public final void setReportExpiry(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportExpiry", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(24, value);
        } else {
            this.getHdr2().setChoiceField(69, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportExpiry");
        }
    }

    public final void setReportCOD(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportCOD", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(25, value);
        } else {
            this.getHdr2().setChoiceField(70, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportCOD");
        }
    }

    public final void setReportCOA(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReportCOA", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(26, value);
        } else {
            this.getHdr2().setChoiceField(71, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReportCOA");
        }
    }

    public final void setGuaranteedSourceMessagingEngineUUID(SIBUuid8 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedSourceMessagingEngineUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(27, value.toByteArray());
        } else {
            this.getHdr2().setField(27, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedSourceMessagingEngineUUID");
        }
    }

    public final void setGuaranteedTargetMessagingEngineUUID(SIBUuid8 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedTargetMessagingEngineUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(28, value.toByteArray());
        } else {
            this.getHdr2().setField(28, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedTargetMessagingEngineUUID");
        }
    }

    public final void setGuaranteedTargetDestinationDefinitionUUID(SIBUuid12 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedTargetDestinationDefinitionUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(29, value.toByteArray());
        } else {
            this.getHdr2().setField(29, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedTargetDestinationDefinitionUUID");
        }
    }

    public final void setGuaranteedStreamUUID(SIBUuid12 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedStreamUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(30, value.toByteArray());
        } else {
            this.getHdr2().setField(30, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedStreamUUID");
        }
    }

    public final void setGuaranteedGatheringTargetUUID(SIBUuid12 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedGatheringTargetUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(33, value.toByteArray());
        } else {
            this.getHdr2().setField(73, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedGatheringTargetUUID");
        }
    }

    public final void setGuaranteedProtocolType(ProtocolType value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedProtocolType", (Object)value);
        }
        this.getHdr2().setField(31, value.toByte());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedProtocolType");
        }
    }

    public void setGuaranteedProtocolVersion(byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedProtocolVersion", (Object)value);
        }
        this.getHdr2().setField(32, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedProtocolVersion");
        }
    }

    public final void setGuaranteedCrossBusLinkName(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedCrossBusLinkName", (Object)value);
        }
        this.getHdr2().setField(34, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedCrossBusLinkName");
        }
    }

    public final void setGuaranteedCrossBusSourceBusUUID(SIBUuid8 value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedCrossBusSourceBusUUID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(35, value.toByteArray());
        } else {
            this.getHdr2().setField(35, null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedCrossBusSourceBusUUID");
        }
    }

    public final void setGuaranteedValueStartTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueStartTick", (Object)value);
        }
        this.getHdr2().setLongField(36, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueStartTick");
        }
    }

    public final void setGuaranteedValueEndTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueEndTick", (Object)value);
        }
        this.getHdr2().setLongField(37, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueEndTick");
        }
    }

    public final void setGuaranteedValueValueTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueValueTick", (Object)value);
        }
        this.getHdr2().setLongField(38, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueValueTick");
        }
    }

    public final void setGuaranteedValueCompletedPrefix(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueCompletedPrefix", (Object)value);
        }
        this.getHdr2().setLongField(39, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueCompletedPrefix");
        }
    }

    public final void setGuaranteedValueRequestedOnly(boolean value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueRequestedOnly", (Object)value);
        }
        this.getHdr2().setBooleanField(40, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedValueRequestedOnly");
        }
    }

    public void clearGuaranteedRemoteBrowse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearGuaranteedRemoteBrowse");
        }
        this.getHdr2().setChoiceField(76, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearGuaranteedRemoteBrowse");
        }
    }

    public final void setGuaranteedRemoteBrowseID(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteBrowseID", (Object)value);
        }
        this.getHdr2().setLongField(41, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteBrowseID");
        }
    }

    public final void setGuaranteedRemoteBrowseSequenceNumber(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteBrowseSequenceNumber", (Object)value);
        }
        this.getHdr2().setLongField(42, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteBrowseSequenceNumber");
        }
    }

    public void clearGuaranteedRemoteGet() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearGuaranteedRemoteGet");
        }
        this.getHdr2().setChoiceField(77, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearGuaranteedRemoteGet");
        }
    }

    public final void setGuaranteedRemoteGetWaitTime(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetWaitTime", (Object)value);
        }
        this.getHdr2().setLongField(43, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetWaitTime");
        }
    }

    public final void setGuaranteedRemoteGetPrevTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetPrevTick", (Object)value);
        }
        this.getHdr2().setLongField(44, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetPrevTick");
        }
    }

    public final void setGuaranteedRemoteGetStartTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetStartTick", (Object)value);
        }
        this.getHdr2().setLongField(45, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetStartTick");
        }
    }

    public final void setGuaranteedRemoteGetValueTick(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetValueTick", (Object)value);
        }
        this.getHdr2().setLongField(46, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setGuaranteedRemoteGetValueTick");
        }
    }

    public final void setExceptionReason(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionReason", (Object)value);
        }
        boolean wasEmpty = this.getHdr2().getChoiceField(78) == 0;
        this.getHdr2().setIntField(47, value);
        if (wasEmpty) {
            this.getHdr2().setChoiceField(79, 0);
            this.getHdr2().setChoiceField(80, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionReason");
        }
    }

    public final void setExceptionInserts(String[] values) {
        boolean wasEmpty;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionInserts", (Object)values);
        }
        boolean bl = wasEmpty = this.getHdr2().getChoiceField(78) == 0;
        if (values != null) {
            this.getHdr2().setField(49, values);
        } else {
            this.getHdr2().setField(49, null);
        }
        if (wasEmpty) {
            this.getHdr2().setChoiceField(79, 0);
            this.getHdr2().setChoiceField(80, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionInserts");
        }
    }

    public final void setExceptionTimestamp(long value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionTimestamp", (Object)value);
        }
        boolean wasEmpty = this.getHdr2().getChoiceField(78) == 0;
        this.getHdr2().setLongField(48, value);
        if (wasEmpty) {
            this.getHdr2().setChoiceField(79, 0);
            this.getHdr2().setChoiceField(80, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionTimestamp");
        }
    }

    public void setExceptionProblemDestination(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionProblemDestination", (Object)value);
        }
        boolean wasEmpty = this.getHdr2().getChoiceField(78) == 0;
        this.getHdr2().setField(50, value);
        if (wasEmpty) {
            this.getHdr2().setChoiceField(80, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionProblemDestination");
        }
    }

    public void setExceptionProblemSubscription(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setExceptionProblemSubscription", (Object)value);
        }
        boolean wasEmpty = this.getHdr2().getChoiceField(78) == 0;
        this.getHdr2().setField(51, value);
        if (wasEmpty) {
            this.getHdr2().setChoiceField(79, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setExceptionProblemSubscription");
        }
    }

    public void clearExceptionData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearExceptionData");
        }
        this.getHdr2().setChoiceField(78, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearExceptionData");
        }
    }

    public String getApiUserId() {
        return null;
    }

    public byte[] getApiMessageIdAsBytes() {
        return null;
    }

    public byte[] getCorrelationIdAsBytes() {
        return null;
    }

    public void setApiUserId(String value) {
    }

    public void setApiMessageIdAsBytes(byte[] value) {
    }

    public void setCorrelationIdAsBytes(byte[] value) {
    }

    public SIBUuid12 getConnectionUuid() {
        return null;
    }

    public void setConnectionUuid(SIBUuid12 value) {
    }

    public Byte getReportException() {
        return null;
    }

    public Boolean getReportPAN() {
        return Boolean.FALSE;
    }

    public Boolean getReportNAN() {
        return Boolean.FALSE;
    }

    public Boolean getReportPassMsgId() {
        return Boolean.FALSE;
    }

    public Boolean getReportPassCorrelId() {
        return Boolean.FALSE;
    }

    public Boolean getReportDiscardMsg() {
        return Boolean.FALSE;
    }

    public Integer getReportFeedback() {
        return null;
    }

    public void setReportException(Byte value) {
    }

    public void setReportPAN(Boolean value) {
    }

    public void setReportNAN(Boolean value) {
    }

    public void setReportPassMsgId(Boolean value) {
    }

    public void setReportPassCorrelId(Boolean value) {
    }

    public void setReportDiscardMsg(Boolean value) {
    }

    public void setReportFeedback(Integer value) {
    }

    public void clearMessageProperties() {
    }

    public void clearMessagePayload() {
    }

    final int getSubtype() {
        return ((Byte)this.jmo.getField(7)).intValue();
    }

    final void setSubtype(Byte value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSubtype", (Object)value);
        }
        this.jmo.setField(7, value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSubtype");
        }
    }

    final void setSubtype(int value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSubtype", (Object)value);
        }
        this.jmo.setField(7, (byte)value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSubtype");
        }
    }

    public void clearWasRemainingTimeToLiveChanged() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearWasRemainingTimeToLiveChanged");
        }
        this.wasTimeToLiveChanged = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearWasRemainingTimeToLiveChanged");
        }
    }

    public boolean wasRemainingTimeToLiveChanged() {
        return this.wasTimeToLiveChanged;
    }

    @Override
    void updateDataFields(int why) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
        super.updateDataFields(why);
        this.setFlags();
        if (this.cachedMessageWaitTime != null) {
            this.getHdr2().setField(12, this.cachedMessageWaitTime);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataFields");
        }
    }

    void copyTransients(JsHdrsImpl copy) {
        copy.cachedMessageWaitTime = this.cachedMessageWaitTime;
        copy.cachedReliability = this.cachedReliability;
        copy.cachedPriority = this.cachedPriority;
        copy.cachedMessageHandle = this.cachedMessageHandle;
        copy.flags = this.flags;
        copy.gotFlags = this.gotFlags;
    }

    final synchronized JsMsgPart getHdr2() {
        if (this.hdr2 == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"getHdr2 will call getPart");
            }
            this.hdr2 = this.jmo.getPart(8, JsHdr2Access.schema);
        }
        return this.hdr2;
    }

    final synchronized JsMsgPart getHdr2IfFluffed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.hdr2 == null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getHdr2IfFluffed returning null");
        }
        return this.hdr2;
    }

    final synchronized JsMsgPart getApi() {
        if (this.api == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"getApi will call getPart");
            }
            this.api = this.jmo.getPart(9, JsApiAccess.schema);
        }
        return this.api;
    }

    final synchronized JsMsgPart getApiIfFluffed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.api == null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getApiIfFluffed returning null");
        }
        return this.api;
    }

    final synchronized JsMsgPart getPayload(JMFSchema schema) {
        if (this.payload == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"getPayload will call getPart");
            }
            this.payload = this.jmo.getPayloadPart().getPart(1, schema);
        }
        return this.payload;
    }

    final synchronized JsMsgPart getPayloadIfFluffed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && this.payload == null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"getPayloadIfFluffed returning null");
        }
        return this.payload;
    }

    @Override
    final synchronized void clearPartCaches() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"clearPartCaches");
        }
        this.payload = null;
        this.api = null;
        this.hdr2 = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"clearPartCaches");
        }
    }

    private final boolean getFlagValue(byte flagBit) {
        return (this.getFlags() & flagBit) != 0;
    }

    private final void setFlagValue(byte flagBit, boolean value) {
        this.flags = value ? (byte)(this.getFlags() | flagBit) : (byte)(this.getFlags() & ~flagBit);
    }

    private final byte getFlags() {
        if (!this.gotFlags) {
            this.flags = (Byte)this.getHdr2().getField(16);
            this.gotFlags = true;
        }
        return this.flags;
    }

    private final void setFlags() {
        if (this.gotFlags) {
            this.getHdr2().setField(16, this.flags);
            this.gotFlags = false;
        }
    }

    final void setFRP(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setFRP", value);
        }
        if (value == null) {
            this.getHdr2().setField(0, null);
            this.getHdr2().setField(1, null);
            this.getHdr2().setField(3, null);
            this.getHdr2().setField(2, null);
        } else {
            RoutingPathList rp = value instanceof RoutingPathList ? (RoutingPathList)value : new RoutingPathList(value);
            this.getHdr2().setField(0, rp.getNames());
            this.getHdr2().setField(1, rp.getMEs());
            this.getHdr2().setField(3, rp.getLocalOnlys());
            this.getHdr2().setField(2, rp.getBusNames());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setFRP");
        }
    }

    final void setRRP(List<SIDestinationAddress> value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRRP", value);
        }
        if (value == null) {
            this.getHdr2().setField(4, null);
            this.getHdr2().setField(5, null);
            this.getHdr2().setField(7, null);
            this.getHdr2().setField(6, null);
        } else {
            RoutingPathList rp = value instanceof RoutingPathList ? (RoutingPathList)value : new RoutingPathList(value);
            this.getHdr2().setField(4, rp.getNames());
            this.getHdr2().setField(5, rp.getMEs());
            this.getHdr2().setField(7, rp.getLocalOnlys());
            this.getHdr2().setField(6, rp.getBusNames());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRRP");
        }
    }

    public String getXctCorrelationID() {
        return (String)this.getHdr2().getField(63);
    }

    public void setXctCorrelationID(String value) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setXctCorrelationID", (Object)value);
        }
        if (value != null) {
            this.getHdr2().setField(63, value);
        } else {
            this.getHdr2().setChoiceField(91, 0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setXctCorrelationID");
        }
    }

    static {
        SchemaManager.ensureInitialized();
    }
}

