/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.handler.config.openapi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.Yaml;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser;
import com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.rest.handler.config.openapi.Config", configurationPolicy=ConfigurationPolicy.IGNORE, service={RESTHandler.class}, property={"com.ibm.wsspi.rest.handler.context.root=/openapi/platform", "com.ibm.wsspi.rest.handler.root=/config"})
public class ConfigSchemaRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(ConfigSchemaRESTHandler.class, (String)"rest.config", null);
    static final long serialVersionUID = 488513603281517799L;

    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Request method was " + request.getMethod() + " but the config schema endpoint is restricted to GET requests only."), (Object[])new Object[0]);
            }
            response.setResponseHeader("Accept", "GET");
            response.sendError(405);
            return;
        }
        OpenAPI openAPI = this.getOpenAPIDocument(response);
        if (openAPI != null) {
            String formatParam;
            String acceptHeader = request.getHeader("Accept");
            String format = "yaml";
            if (acceptHeader != null && acceptHeader.equals("application/json")) {
                format = "json";
            }
            if ((formatParam = request.getParameter("format")) != null && formatParam.equals("json")) {
                format = "json";
            }
            if (format.equals("json")) {
                response.setContentType("application/json");
                response.getWriter().write(Json.pretty((Object)openAPI));
            } else {
                response.setContentType("text/plain");
                response.getWriter().write(Yaml.pretty((Object)openAPI));
            }
        }
    }

    private OpenAPI getOpenAPIDocument(RESTResponse response) {
        OpenAPI openAPI = null;
        InputStream inputStream = ConfigSchemaRESTHandler.class.getResourceAsStream("/META-INF/openapi.yaml");
        if (inputStream != null) {
            String document = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
            openAPI = new OpenAPIV3Parser().readContents(document, null, null, null).getOpenAPI();
            response.setCharacterEncoding("UTF-8");
            if (openAPI == null) {
                if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Error retrieving openapi.yaml for config validation. Returning error code 500.", (Object[])new Object[0]);
                }
                response.setStatus(500);
            }
        } else {
            if (OpenAPIUtils.isEventEnabled((TraceComponent)tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Null inputStream for openapi.yaml. Return 500.", (Object[])new Object[0]);
            }
            response.setStatus(500);
        }
        return openAPI;
    }
}

