/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.http;

import com.ibm.ws.jbatch.utility.http.EntityWriter;
import com.ibm.ws.jbatch.utility.http.HttpUtils;
import com.ibm.ws.jbatch.utility.http.Response;
import com.ibm.ws.jbatch.utility.utils.StringUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class SimpleHttpClient {
    protected static final String batchRestContext = "/ibm/api/batch";
    private String path = "";
    private String target;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> queryParams = new HashMap<String, String>();
    private int timeout_ms = 0;

    public SimpleHttpClient setTarget(String target) {
        this.target = target;
        return this;
    }

    protected String getTarget() {
        return this.target;
    }

    public SimpleHttpClient setTimeout(int timeout_ms) {
        this.timeout_ms = timeout_ms;
        return this;
    }

    public SimpleHttpClient path(String appendPath) {
        this.path = this.path + "/" + appendPath;
        return this;
    }

    protected String getPath() {
        return this.path;
    }

    protected String getQueryString() {
        StringBuilder retMe = new StringBuilder();
        String delim = "";
        for (Map.Entry<String, String> queryParam : this.getQueryParams().entrySet()) {
            retMe.append(delim).append(queryParam.getKey() + "=" + queryParam.getValue());
            delim = "&";
        }
        return retMe.length() == 0 ? "" : "?" + retMe.toString();
    }

    protected URL getURL() throws IOException {
        return new URL(this.getTarget() + this.getPath() + this.getQueryString());
    }

    public SimpleHttpClient header(String key, String value) {
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return this;
    }

    protected Map<String, String> getHeaders() {
        return this.headers;
    }

    public SimpleHttpClient queryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public SimpleHttpClient queryParamNotNullOrEmpty(String key, String value) {
        if (value != null && value.trim().length() > 0) {
            this.queryParams.put(key, value);
        }
        return this;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Response get() throws IOException {
        HttpURLConnection con = this.setHeaders(this.getConnection("GET"));
        con.setInstanceFollowRedirects(false);
        con.connect();
        if (con.getResponseCode() == 302) {
            con = this.processRedirect(con);
        }
        return new Response(con);
    }

    public Response post(EntityWriter entityWriter) throws IOException {
        return this.withPayload("POST", entityWriter);
    }

    public Response put(EntityWriter entityWriter) throws IOException {
        return this.withPayload("PUT", entityWriter);
    }

    public Response delete() throws IOException {
        HttpURLConnection con = this.setHeaders(this.getConnection("DELETE"));
        con.setInstanceFollowRedirects(false);
        con.connect();
        if (con.getResponseCode() == 302) {
            con = this.processRedirect(con);
        }
        return new Response(con);
    }

    protected Response withPayload(String requestMethod, EntityWriter entityWriter) throws IOException {
        HttpURLConnection con = this.setHeaders(this.getConnection(requestMethod));
        if (entityWriter != null) {
            entityWriter.writeEntity(con.getOutputStream());
        }
        con.setInstanceFollowRedirects(false);
        con.connect();
        if (con.getResponseCode() == 302) {
            con = this.processRedirect(con);
        }
        return new Response(con);
    }

    protected HttpURLConnection setHeaders(HttpURLConnection con) {
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            con.setRequestProperty(header.getKey(), header.getValue());
        }
        return con;
    }

    protected HttpURLConnection getConnection(String requestMethod) throws IOException {
        HttpURLConnection con = (HttpURLConnection)this.getURL().openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestMethod(requestMethod);
        if (Boolean.getBoolean("com.ibm.ws.jbatch.utility.https.disableHostnameVerification")) {
            this.disableHostnameVerification((HttpsURLConnection)con);
        }
        if (!StringUtils.isEmpty(System.getProperty("javax.net.ssl.keyStore")) && con instanceof HttpsURLConnection) {
            ((HttpsURLConnection)con).setSSLSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
        }
        con.setConnectTimeout(this.timeout_ms);
        con.setReadTimeout(this.timeout_ms);
        return con;
    }

    protected HttpsURLConnection disableHostnameVerification(HttpsURLConnection con) {
        con.setHostnameVerifier(HttpUtils.getTrustAllHostnames());
        return con;
    }

    private HttpURLConnection processRedirect(HttpURLConnection con) throws IOException {
        String requestMethod = con.getRequestMethod();
        String target = con.getHeaderField("Location");
        int index = target.indexOf(batchRestContext);
        target = target.substring(0, index);
        this.setTarget(target);
        con = this.setHeaders(this.getConnection(requestMethod));
        con.setInstanceFollowRedirects(false);
        con.connect();
        return con;
    }
}

