/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.javaee.dd.common.Description;
import com.ibm.ws.javaee.dd.common.ResourceRef;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.ddmodel.common.DescriptionType;
import com.ibm.ws.javaee.ddmodel.common.ResourceGroup;
import com.ibm.ws.javaee.ddmodel.common.XSDTokenType;
import com.ibm.ws.javaee.ddmodel.web.common.WebAppType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ResourceRefType
extends ResourceGroup
implements ResourceRef {
    DescriptionType.ListType description;
    XSDTokenType res_type;
    ResAuthType res_auth;
    ResSharingScopeType res_sharing_scope;
    static final long serialVersionUID = -7437806156711102013L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public List<Description> getDescriptions() {
        if (this.description != null) {
            return this.description.getList();
        }
        return Collections.emptyList();
    }

    public String getType() {
        return this.res_type != null ? this.res_type.getValue() : null;
    }

    public int getAuthValue() {
        if (this.res_auth != null) {
            switch (this.res_auth.value) {
                case Application: {
                    return 1;
                }
                case Container: {
                    return 0;
                }
            }
        }
        return -1;
    }

    public int getSharingScopeValue() {
        if (this.res_sharing_scope != null) {
            switch (this.res_sharing_scope.value) {
                case Shareable: {
                    return 0;
                }
                case Unshareable: {
                    return 1;
                }
            }
        }
        return -1;
    }

    public ResourceRefType() {
        super("res-ref-name");
    }

    @Override
    public boolean isIdAllowed() {
        return true;
    }

    @Override
    public boolean handleChild(DDParser parser, String localName) throws DDParser.ParseException {
        if (super.handleChild(parser, localName)) {
            return true;
        }
        if ("description".equals(localName)) {
            DescriptionType description = new DescriptionType();
            parser.parse(description);
            this.addDescription(description);
            return true;
        }
        if ("res-type".equals(localName)) {
            XSDTokenType res_type = new XSDTokenType();
            parser.parse(res_type);
            this.res_type = res_type;
            return true;
        }
        if ("res-auth".equals(localName)) {
            ResAuthType res_auth = new ResAuthType();
            parser.parse(res_auth);
            this.res_auth = res_auth;
            return true;
        }
        if ("res-sharing-scope".equals(localName)) {
            ResSharingScopeType res_sharing_scope = new ResSharingScopeType();
            parser.parse(res_sharing_scope);
            this.res_sharing_scope = res_sharing_scope;
            return true;
        }
        return false;
    }

    private void addDescription(DescriptionType description) {
        if (this.description == null) {
            this.description = new DescriptionType.ListType();
        }
        this.description.add(description);
    }

    @Override
    public void describe(DDParser.Diagnostics diag) {
        diag.describeIfSet("description", this.description);
        diag.describeIfSet("res-type", this.res_type);
        diag.describeIfSet("res-auth", this.res_auth);
        diag.describeIfSet("res-sharing-scope", this.res_sharing_scope);
        super.describe(diag);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.common.ResourceRefType", ResourceRefType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ResSharingScopeType
    extends XSDTokenType {
        ResSharingScopeEnum value;
        static final long serialVersionUID = 6411725988798718764L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ResSharingScopeType() {
        }

        @Override
        public void finish(DDParser parser) throws DDParser.ParseException {
            super.finish(parser);
            if (!this.isNil()) {
                this.value = this.parseEnumValue(parser, ResSharingScopeEnum.class);
            }
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
            diag.describeEnum(this.value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.common.ResourceRefType$ResSharingScopeType", ResSharingScopeType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    static enum ResSharingScopeEnum {
        Shareable,
        Unshareable;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class ResAuthType
    extends XSDTokenType {
        ResAuthEnum value;
        static final long serialVersionUID = -2683783312132530032L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ResAuthType() {
        }

        @Override
        public void finish(DDParser parser) throws DDParser.ParseException {
            super.finish(parser);
            if (!this.isNil()) {
                this.value = parser.getRootParsable() instanceof WebAppType && parser.version < 23 ? this.parseEnumValue((DDParser)parser, ResAuthEnumWebAppLegacy.class).value : this.parseEnumValue(parser, ResAuthEnum.class);
            }
        }

        @Override
        public void describe(DDParser.Diagnostics diag) {
            diag.describeEnum(this.value);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.common.ResourceRefType$ResAuthType", ResAuthType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    static enum ResAuthEnumWebAppLegacy {
        CONTAINER(ResAuthEnum.Container),
        SERVLET(ResAuthEnum.Application);

        final ResAuthEnum value;

        private ResAuthEnumWebAppLegacy(ResAuthEnum value) {
            this.value = value;
        }
    }

    static enum ResAuthEnum {
        Application,
        Container;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ListType
    extends DDParser.ParsableListImplements<ResourceRefType, ResourceRef> {
        static final long serialVersionUID = -5291019565761656685L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public ResourceRefType newInstance(DDParser parser) {
            return new ResourceRefType();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.common.ResourceRefType$ListType", ListType.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }
}

