/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.internal.lifecycle;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.lifecycle.ApplicationPrereq;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, configurationPid={"com.ibm.ws.app.prereqmonitor"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class ApplicationPrereqMonitor
implements ConfigurationListener {
    public static final TraceComponent tc = Tr.register(ApplicationPrereqMonitor.class, (String[])new String[]{"applications", "app.manager"}, (String)"com.ibm.ws.app.manager.internal.resources.AppManagerMessages", (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor");
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final int version = counter.incrementAndGet();
    private final ConfigurationAdmin configurationAdmin;
    private final Set<String> declaredPrereqs;
    private final Set<String> realisedPrereqs = new TreeSet<String>();
    private boolean configModified = false;
    static final long serialVersionUID = -2649626173986823053L;

    @Activate
    public ApplicationPrereqMonitor(@Reference ConfigurationAdmin configurationAdmin, Map<String, Object> properties) {
        this.configurationAdmin = configurationAdmin;
        Object[] pids = (String[])properties.get("applicationPrereqDeclarations");
        this.declaredPrereqs = Collections.unmodifiableSet(Stream.of(pids).map(this::servicePidToConfigId).collect(Collectors.toSet()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + "\nKnown configured application Prereq Pids:" + Arrays.toString(pids) + "\nids:" + this.declaredPrereqs), (Object[])new Object[0]);
        }
    }

    @Deactivate
    void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " deactivate"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private String servicePidToConfigId(String servicePid) {
        Object[] configs;
        try {
            configs = this.configurationAdmin.listConfigurations("(service.pid=" + servicePid + ")");
            if (configs == null) {
                Tr.debug((TraceComponent)tc, (String)("No configs found matching servicePid=" + servicePid), (Object[])new Object[0]);
                return "PID not found: " + servicePid;
            }
            if (configs.length > 1) {
                throw new IllegalStateException("Non unique servicePid=" + servicePid + " matched configs=" + Arrays.toString(configs));
            }
        }
        catch (IOException | IllegalStateException | InvalidSyntaxException throwable) {
            void e;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor", (String)"102", (Object)this, (Object[])new Object[]{servicePid});
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return "Error listing prereqs:" + sw;
        }
        String id = (String)configs[0].getProperties().get("id");
        return id;
    }

    /*
     * WARNING - void declaration
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    synchronized void setApplicationPrereq(ApplicationPrereq applicationPrereq) {
        this.realisedPrereqs.add(applicationPrereq.getApplicationPrereqID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Prereq added:" + applicationPrereq.getClass().getName() + "\nConfigured:" + this.declaredPrereqs + "\n  Realised:" + this.realisedPrereqs), (Object[])new Object[0]);
        }
        if (this.configModified) {
            return;
        }
        if (this.declaredPrereqs.containsAll(this.realisedPrereqs)) {
            return;
        }
        TreeSet<String> surplusPrereqs = new TreeSet<String>(this.realisedPrereqs);
        surplusPrereqs.removeAll(this.declaredPrereqs);
        try {
            throw new IllegalStateException("Undeclared Prereqs:" + surplusPrereqs);
        }
        catch (IllegalStateException illegalStateException) {
            void illegalStateException2;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.ws.app.manager.internal.lifecycle.ApplicationPrereqMonitor", (String)"139", (Object)this, (Object[])new Object[]{applicationPrereq});
            throw illegalStateException2;
        }
    }

    synchronized void unsetApplicationPrereq(ApplicationPrereq applicationPrereq) {
        this.realisedPrereqs.remove(applicationPrereq.getApplicationPrereqID());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Prereq removed:" + applicationPrereq.getClass().getName() + "\nConfigured:" + this.declaredPrereqs + "\n  Realised:" + this.realisedPrereqs), (Object[])new Object[0]);
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + " Configuration changed, stop reporting invalid prereqs"), (Object[])new Object[0]);
        }
        this.configModified = true;
    }

    public String toString() {
        return ApplicationPrereqMonitor.class.getName() + "#" + this.version;
    }
}

