/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.messaging.mbean.MessagingEngineMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMain;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsProcessComponent;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsDestinationCache;
import com.ibm.ws.sib.admin.internal.JsMainAdminComponentImpl;
import com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.SIBLocalizationPointImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class JsMainImpl
implements JsMain {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsMainImpl";
    private static final TraceComponent tc = SibTr.register(JsMainImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.internal.CWSIDText");
    protected JsMEConfig meConfig = null;
    JsBusImpl bus = null;
    String defaultMEUUID = "DefaultMEUUID";
    ArrayList services;
    BundleContext bContext;
    ServiceRegistration<MessagingEngineMBean> mbeanServiceReg;
    private final RuntimeSecurityService runtimeSecurityService;
    private boolean _serverStarted = false;
    private boolean _serverStopping = false;
    protected Hashtable _messagingEngines = new Hashtable();

    public final RuntimeSecurityService getRuntimeSecurityService() {
        return this.runtimeSecurityService;
    }

    public JsMainImpl(BundleContext bContext, RuntimeSecurityService runtimeSecurityService) {
        String methodName = "JSMainImpl";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{this, bContext, runtimeSecurityService, this.services});
        }
        this.bContext = bContext;
        this.runtimeSecurityService = runtimeSecurityService;
        JsAdminService adminService = JsMainAdminComponentImpl.getJsAdminService();
        adminService.setAdminMain((JsMain)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public void initialize(JsMEConfig config) throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.initialize(Object)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)"");
        }
        this.meConfig = config;
        this.createMessageEngine(this.meConfig);
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            if (!(c instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)c).initialize(null);
                this.setAttributes((BaseMessagingEngineImpl)c);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)thisMethodName, (String)"1:656:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
                SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)((BaseMessagingEngineImpl)c).getName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void start() throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.start()";
        if (!TraceComponent.isAnyTracingEnabled() || tc.isEntryEnabled()) {
            // empty if block
        }
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            try {
                ((BaseMessagingEngineImpl)c).startConditional();
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("service.vendor", "IBM");
                ((Dictionary)properties).put("jmx.objectname", "WebSphere:feature=wasJmsServer,type=MessagingEngine,name=" + ((BaseMessagingEngineImpl)c)._name);
                this.mbeanServiceReg = this.bContext.registerService(MessagingEngineMBean.class.getName(), (Object)c, properties);
            }
            catch (Exception w) {
                FFDCFilter.processException((Throwable)w, (String)thisMethodName, (String)"1:725:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)w);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)w);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void serverStarted() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.serverStarted()";
        if (!TraceComponent.isAnyTracingEnabled() || tc.isEntryEnabled()) {
            // empty if block
        }
        this._serverStarted = true;
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            if (!(c instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)c).serverStarted();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)thisMethodName, (String)"1:772:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
                SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)((BaseMessagingEngineImpl)c).getName());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void serverStopping() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.serverStopping()";
        if (!TraceComponent.isAnyTracingEnabled() || tc.isEntryEnabled()) {
            // empty if block
        }
        this._serverStopping = true;
        this._serverStarted = false;
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            if (!(c instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)c).serverStopping();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)thisMethodName, (String)"1:810:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void stop() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stop()";
        if (!TraceComponent.isAnyTracingEnabled() || tc.isEntryEnabled()) {
            // empty if block
        }
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            try {
                ((BaseMessagingEngineImpl)c).stopConditional(0);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)thisMethodName, (String)"1:854:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void destroy() throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.destroy()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)"");
        }
        Enumeration meEnum = this._messagingEngines.elements();
        while (meEnum.hasMoreElements()) {
            Object o = meEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            if (!(c instanceof BaseMessagingEngineImpl)) continue;
            try {
                ((BaseMessagingEngineImpl)c).destroy();
                this.mbeanServiceReg.unregister();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)thisMethodName, (String)"1:910:1.108", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        }
        this._messagingEngines = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    private MessagingEngine createMessageEngine(JsMEConfig me) throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.createMessageEngine(JsMEConfig)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)"replace ME name here");
        }
        JsMessagingEngineImpl engineImpl = null;
        this.bus = new JsBusImpl(me, this, me.getSIBus().getName());
        engineImpl = new JsMessagingEngineImpl(this, this.bus, me);
        MessagingEngine engine = new MessagingEngine(me, engineImpl);
        this._messagingEngines.put(this.defaultMEUUID, engine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)engine.toString());
        }
        return engine;
    }

    private JsBusImpl getBusProxy(JsMEConfig me) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getBusProxy(ConfigObject)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)"ME Name");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return this.bus;
    }

    private JsBusImpl getBusProxy(String name) throws SIBExceptionBusNotFound {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getBusProxy(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return this.bus;
    }

    public JsBus getBus(String busName) throws SIBExceptionBusNotFound {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getBus(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return this.bus;
    }

    public JsBus getDefinedBus(String busName) throws SIBExceptionBusNotFound {
        String thisMethodName = "getDefinedBus";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return this.bus;
    }

    public JsMessagingEngineImpl getMessagingEngine(String name) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getMessagingEngine(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)name);
        }
        Enumeration vEnum = this._messagingEngines.elements();
        JsMessagingEngineImpl foundMessagingEngine = null;
        while (vEnum.hasMoreElements() && foundMessagingEngine == null) {
            Object o = vEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            foundMessagingEngine = (JsMessagingEngineImpl)c;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return foundMessagingEngine;
    }

    public JsMessagingEngine getMessagingEngine(String busName, String engine) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getMessagingEngine(String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, engine});
        }
        AuditManager auditManager = new AuditManager();
        auditManager.setJMSBusName(busName);
        auditManager.setJMSMessagingEngine(engine);
        Enumeration vEnum = this._messagingEngines.elements();
        JsMessagingEngine foundMessagingEngine = null;
        if (vEnum.hasMoreElements() && foundMessagingEngine == null) {
            JsMessagingEngine c;
            Object o = vEnum.nextElement();
            foundMessagingEngine = c = ((MessagingEngine)o).getRuntime();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return foundMessagingEngine;
    }

    public Enumeration listMessagingEngines() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.listMessagingEngines()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        Vector<JsMessagingEngine> v = new Vector<JsMessagingEngine>();
        Enumeration vEnum = this._messagingEngines.elements();
        while (vEnum.hasMoreElements()) {
            Object o = vEnum.nextElement();
            JsMessagingEngine c = ((MessagingEngine)o).getRuntime();
            if (!(c instanceof BaseMessagingEngineImpl)) continue;
            v.addElement(c);
        }
        Enumeration elements = v.elements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return elements;
    }

    public Enumeration listMessagingEngines(String busName) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.listMessagingEngines(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)busName);
        }
        Vector v = new Vector();
        Enumeration e = this.listMessagingEngines();
        while (e.hasMoreElements()) {
            Object c = e.nextElement();
            if (!((BaseMessagingEngineImpl)c).getBusName().equals(busName)) continue;
            v.addElement(c);
        }
        Enumeration elements = v.elements();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return elements;
    }

    public Set getMessagingEngineSet(String busName) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getMessagingEngineSet(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)busName);
        }
        HashSet<String> retSet = new HashSet<String>();
        if (this.meConfig != null) {
            String meName = this.meConfig.getMessagingEngine().getName();
            JsMessagingEngineImpl engineImpl = this.getMessagingEngine(meName);
            retSet.add(engineImpl.getUuid().toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = new Integer(retSet.size());
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)i.toString());
        }
        return retSet;
    }

    public String getLibertyMEUuid() {
        JsMessagingEngineImpl engineImpl = this.getMessagingEngine(this.meConfig.getMessagingEngine().getName());
        return engineImpl.getUuid();
    }

    public String[] showMessagingEngines() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.showMessagingEngines()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        String[] list = new String[this._messagingEngines.size()];
        Enumeration e = this.listMessagingEngines();
        int i = 0;
        while (e.hasMoreElements()) {
            Object c = e.nextElement();
            list[i++] = ((BaseMessagingEngineImpl)c).getBusName() + ":" + ((BaseMessagingEngineImpl)c).getName() + ":" + ((BaseMessagingEngineImpl)c).getState();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return list;
    }

    public void startMessagingEngine(String busName, String name) throws Exception {
        BaseMessagingEngineImpl me;
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.startMessagingEngine(String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name});
        }
        if ((me = (BaseMessagingEngineImpl)this.getMessagingEngine(busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + busName + " name=" + name + ">"));
            }
            throw new Exception("The messaging engine <bus=" + busName + " name=" + name + "> does not exist");
        }
        me.startConditional();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void stopMessagingEngine(String busName, String name) throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name});
        }
        this.stopMessagingEngine(busName, name, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public void stopMessagingEngine(String busName, String name, String mode) throws Exception {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name, mode});
        }
        int iMode = Integer.parseInt(mode);
        this.stopMessagingEngine(busName, name, iMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    private void stopMessagingEngine(String busName, String name, int mode) throws Exception {
        BaseMessagingEngineImpl me;
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String, int)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{busName, name, Integer.toString(mode)});
        }
        if ((me = (BaseMessagingEngineImpl)this.getMessagingEngine(busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + busName + " name=" + name + ">"));
            }
            throw new Exception("The messaging engine <bus=" + busName + " name=" + name + "> does not exist");
        }
        me.stopConditional(mode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    protected void setAttributes(BaseMessagingEngineImpl c) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.setAttributes(BaseMessagingEngineImpl)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)new Object[]{c.getBusName(), c.getName()});
        }
        c.setConfig(c);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
    }

    public JsProcessComponent getProcessComponent(String className) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getProcessComponent(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)className);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return null;
    }

    public boolean isServerStarted() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.isServerStarted()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Boolean(this._serverStarted));
        }
        return this._serverStarted;
    }

    public boolean isServerStopping() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.isServerStopping()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Boolean(this._serverStopping));
        }
        return this._serverStopping;
    }

    public boolean isServerInRecoveryMode() {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.isServerInRecoveryMode()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        boolean ret = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName, (Object)new Boolean(ret));
        }
        return ret;
    }

    public Object getService(Class c) {
        String thisMethodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.getService(Class)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)thisMethodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)thisMethodName);
        }
        return null;
    }

    public List<String> listDefinedBuses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listDefinedBuses", (Object)this);
        }
        List<String> buses = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listDefinedBuses", buses);
        }
        return buses;
    }

    public void alterDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization : ", (Object)config);
        String meName = this.meConfig.getMessagingEngine().getName();
        JsMessagingEngineImpl engine = this.getMessagingEngine(meName);
        SIBLocalizationPointImpl lpConfig = new SIBLocalizationPointImpl();
        lpConfig.setIdentifier(config.getName() + "@" + meName);
        if (!config.isAlias()) {
            SIBDestination d = (SIBDestination)config;
            lpConfig.setHighMsgThreshold(d.getHighMessageThreshold());
            engine.alterLocalizationPoint(config, (LWMConfig)lpConfig);
        } else {
            AliasDestination aliasDest = (AliasDestination)config;
            engine.alterLocalizationPoint((BaseDestination)aliasDest, (LWMConfig)lpConfig);
        }
        SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization : ", (Object)config);
    }

    public void createDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)this);
        try {
            String meName = this.meConfig.getMessagingEngine().getName();
            JsDestinationCache dCache = this.bus.getDestinationCache();
            BaseDestinationDefinition dd = dCache.addNewDestinationToCache(config);
            if (!config.isAlias()) {
                JsMessagingEngineImpl engine = this.getMessagingEngine(meName);
                SIBLocalizationPointImpl lpConfig = new SIBLocalizationPointImpl();
                lpConfig.setIdentifier(config.getName() + "@" + meName);
                SIBDestination d = (SIBDestination)config;
                lpConfig.setHighMsgThreshold(d.getHighMessageThreshold());
                engine.addLocalizationPoint((LWMConfig)lpConfig, (DestinationDefinition)dd);
                ArrayList<BaseDestinationDefinition> list = new ArrayList<BaseDestinationDefinition>();
                list.add(dd);
                this.bus.getDestinationCache().populateUuidCache(list);
            }
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization for destination: ", (Object)config.getName());
    }

    public void deleteDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization ", (Object)config.getName());
        try {
            JsMessagingEngineImpl me = this.getMessagingEngine(this.meConfig.getMessagingEngine().getName());
            me.deleteLocalizationPoint(this.bus, (LWMConfig)config);
            JsDestinationCache cache = this.bus.getDestinationCache();
            cache.deleteDestination(this.bus.getName(), config.getName());
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization ", (Object)config.getName());
    }

    public void reloadEngine(long highMessageThreshold) throws Exception {
        throw new SINotSupportedException();
    }

    protected class MessagingEngine {
        private JsMEConfig _meConfig = null;
        private JsMessagingEngine _me = null;

        MessagingEngine(JsMEConfig meConfig, JsMessagingEngine me) {
            this._meConfig = meConfig;
            this._me = me;
        }

        JsMEConfig getConfig() {
            return this._meConfig;
        }

        void setConfig(JsMEConfig newConfig) {
            this._meConfig = newConfig;
        }

        public JsMessagingEngine getRuntime() {
            return this._me;
        }
    }

    class ComponentList {
        private final String _className;
        private final JsProcessComponent _componentRef;

        ComponentList(String className, JsProcessComponent c) {
            this._className = className;
            this._componentRef = c;
        }

        String getClassName() {
            return this._className;
        }

        JsProcessComponent getRef() {
            return this._componentRef;
        }
    }
}

