/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionVersionException;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.impl.AsynchConsumer;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.RemoteQPConsumerKey;
import com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINonDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JSLocalConsumerPoint
extends ReentrantLock
implements DispatchableConsumerPoint,
LocalConsumerPoint,
MessageEventListener,
AlarmListener {
    private static final long serialVersionUID = 6225084023637058815L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register(JSLocalConsumerPoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final int NO_LOCAL_BATCH_SIZE = 10;
    private final SIMPTransactionManager _txManager;
    private final MessageProcessor _messageProcessor;
    private ConsumableKey _consumerKey;
    private final Condition _waiter;
    private final ConsumerSessionImpl _consumerSession;
    private JSConsumerManager _consumerDispatcher;
    private boolean _waitingToStart;
    private boolean _stopped = true;
    private boolean _stoppedByRequest = true;
    private boolean _stoppedForReceiveAllowed = false;
    private boolean _transacted = true;
    private Reliability _unrecoverableOptions = Reliability.NONE;
    private Reliability _baseUnrecoverableOptions = Reliability.NONE;
    private volatile boolean _closed = false;
    private volatile boolean _closing = false;
    private final AsynchConsumer _asynchConsumer = new AsynchConsumer();
    private final DestinationHandler _destinationAttachedTo;
    private Object _asynchConsumerBusyLock;
    private ExternalConsumerLock _externalConsumerLock = null;
    private volatile boolean _interruptConsumer = false;
    private boolean _asynchConsumerRegistered = false;
    private int _maxBatchSize = 0;
    private volatile int _maxActiveMessages = 0;
    private int _currentActiveMessages = 0;
    private boolean _consumerSuspended = false;
    private int _suspendFlags = 0;
    private Object _maxActiveMessageLock = null;
    private int _activeMsgBlockInterval = -1;
    private ActiveMsgBlockAlarm _activeMsgBlockAlarm = null;
    private boolean _bifurcatable = false;
    private boolean _inLine = false;
    private boolean _waiting = false;
    private boolean _ready = false;
    private SIMPMessage _attachedMessage = null;
    private boolean _msgOnItemStream = false;
    private boolean _msgAttached = false;
    private boolean _msgLocked = false;
    private final JSLockedMessageEnumeration _allLockedMessages;
    private final SIBUuid12 _connectionUuid;
    private JSKeyGroup _keyGroup = null;
    private OrderingContextImpl _orderingGroup = null;
    private JSLocalConsumerPoint _transferredConsumer;
    boolean _drainQueue;
    private volatile boolean _lockRequested = false;
    private TransactionCommon _autoCommitTransaction = null;
    private boolean _hasLocalQP;
    private SingleLockedMessageEnumerationImpl _singleLockedMessageEnum = null;
    private boolean _isolatedRun = false;
    private List<SIMPMessage> _hiddenMessages = new ArrayList<SIMPMessage>();
    private int _maxSequentialFailuresThreshold = 0;
    private long _hiddenMessageDelay = 0L;
    private int _sequentialMessageCounter = 0;
    private volatile boolean _consumerStoppable = false;
    private boolean _startSinceSequentialStop = false;
    private MPAlarmManager _alarmManager = null;
    private boolean _hiddenMsgAlarmRegistered = false;
    private boolean _consumerStopThreadRunning = false;
    private Throwable _notifiedException = null;
    private boolean _runningAsynchConsumer = false;
    private boolean _runAsynchConsumerInterupted = false;
    private boolean _gatherMessages = false;

    JSLocalConsumerPoint(DestinationHandler destination, JsDestinationAddress jsDestAddr, ConsumerDispatcherState state, ConsumerSessionImpl consumerSession, Reliability unrecoverableReliability, boolean bifurcatable, boolean gatherMessages) throws SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException, SIIncorrectCallException, SISessionDroppedException, SISessionUnavailableException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException, SINonDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JSLocalConsumerPoint", (Object)new Object[]{destination, jsDestAddr, state, consumerSession, unrecoverableReliability, bifurcatable, gatherMessages});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Constructing local consumer point " + this));
        }
        this._consumerSession = consumerSession;
        ConnectionImpl conn = (ConnectionImpl)consumerSession.getConnectionInternal();
        this._destinationAttachedTo = destination;
        this._asynchConsumerBusyLock = this._asynchConsumer;
        this._maxActiveMessageLock = new Object();
        this._messageProcessor = conn.getMessageProcessor();
        this._txManager = this._messageProcessor.getTXManager();
        this._connectionUuid = consumerSession.getConnectionUuid();
        this._bifurcatable = bifurcatable;
        this._gatherMessages = gatherMessages;
        this._waiter = this.newCondition();
        this._alarmManager = this._messageProcessor.getAlarmManager();
        if (unrecoverableReliability != null) {
            this.setBaseRecoverability(unrecoverableReliability);
        }
        try {
            if (destination.isPubSub()) {
                if (state.isDurable()) {
                    this._consumerKey = destination.attachToDurableSubscription(this, state);
                    this._consumerDispatcher = this._consumerKey.getConsumerManager();
                } else {
                    this._consumerKey = (ConsumableKey)destination.createSubscriptionConsumerDispatcherAndAttachCP(this, state);
                    this._consumerDispatcher = this._consumerKey.getConsumerManager();
                }
            } else {
                this._consumerDispatcher = (JSConsumerManager)destination.chooseConsumerManager(gatherMessages ? destination.getUuid() : null, jsDestAddr.getME(), null);
                if (this._consumerDispatcher == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("ConsumerDispatcher not found (" + jsDestAddr.getME() + ")"));
                    }
                    SIMPNoLocalisationsException e = new SIMPNoLocalisationsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_26", new Object[]{jsDestAddr.getDestinationName()}, null));
                    e.setExceptionReason(26);
                    e.setExceptionInserts(new String[]{jsDestAddr.getDestinationName()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"JSLocalConsumerPoint", (Object)e);
                    }
                    throw e;
                }
                JSConsumerSet consumerSet = null;
                this._consumerKey = (ConsumableKey)this._consumerDispatcher.attachConsumerPoint(this, state.getSelectionCriteria(), consumerSession.getConnectionUuid(), consumerSession.getReadAhead(), consumerSession.getForwardScanning(), consumerSet);
            }
        }
        catch (SIMPConnectionVersionException e) {
            SIIncorrectCallException e2 = new SIIncorrectCallException((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"JSLocalConsumerPoint", (Object)((Object)e2));
            }
            throw e2;
        }
        if (!this.ignoreInitialIndoubts()) {
            this._consumerDispatcher.checkInitialIndoubts(this);
        }
        if (!(this._consumerKey instanceof RemoteQPConsumerKey)) {
            this._hasLocalQP = true;
        }
        this._allLockedMessages = new JSLockedMessageEnumeration(this, this._consumerKey, this._messageProcessor);
        this.checkReceiveAllowed();
        this._autoCommitTransaction = this._messageProcessor.getTXManager().createAutoCommitTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JSLocalConsumerPoint", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(SIMPMessage msg, boolean isOnItemStream) {
        boolean msgTaken;
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{this, msg, isOnItemStream, this});
            }
            msgTaken = false;
            boolean deliverToAsynchCon = false;
            boolean inLineAsynchCon = false;
            JSKeyGroup cachedKeyGroup = this._keyGroup;
            this._lockRequested = true;
            if (cachedKeyGroup != null) {
                cachedKeyGroup.lock();
            }
            try {
                this.lock();
                try {
                    this._lockRequested = false;
                    boolean msgLockingError = false;
                    try {
                        msgTaken = this.takeMessage(msg, isOnItemStream);
                    }
                    catch (SIResourceException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        msgLockingError = true;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("asynch consumer reg: " + Boolean.valueOf(this._asynchConsumerRegistered) + ", isolatedRun: " + Boolean.valueOf(this._isolatedRun)));
                    }
                    if (msgTaken || msgLockingError) {
                        deliverToAsynchCon = this._asynchConsumerRegistered && !this._isolatedRun;
                    }
                    inLineAsynchCon = this._inLine;
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                if (cachedKeyGroup != null) {
                    cachedKeyGroup.unlock();
                }
            }
            if (deliverToAsynchCon) {
                if (inLineAsynchCon && !msg.isReavailable()) {
                    try {
                        this.runAsynchConsumer(false);
                    }
                    catch (Throwable e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.put", (String)"1:817:1.22.5.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Throwable)e);
                        try {
                            this.closeSession(e);
                        }
                        catch (Exception ee) {
                            SibTr.exception((TraceComponent)tc, (Exception)ee);
                        }
                        if (e instanceof ThreadDeath) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"put", (Object)e);
                            }
                            throw (ThreadDeath)e;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"put", (Object)e);
                        }
                        break block26;
                    }
                }
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)msgTaken);
        }
        return msgTaken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean takeMessage(SIMPMessage msg, boolean isOnItemStream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"takeMessage", (Object)new Object[]{this, msg, isOnItemStream});
        }
        boolean msgTaken = false;
        if (this._ready && this._keyGroup == null || this._keyGroup != null && this._keyGroup.isGroupReady()) {
            boolean msgAccepted;
            this._ready = false;
            if (this._keyGroup != null) {
                this._keyGroup.groupNotReady();
            }
            if (!(msgAccepted = this.prepareAddActiveMessage())) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The consumer set is already suspended ");
                }
            } else {
                boolean activeMessageAttached = false;
                try {
                    msgTaken = true;
                    try {
                        activeMessageAttached = this.attachAndLockMsg(msg, isOnItemStream);
                    }
                    catch (SIResourceException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        activeMessageAttached = false;
                        this.checkWaiting();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"takeMessage", (Object)((Object)e));
                        }
                        throw e;
                    }
                    if (activeMessageAttached) {
                        this.commitAddActiveMessage();
                    }
                    this.checkWaiting();
                }
                finally {
                    if (!activeMessageAttached) {
                        this.rollbackAddActiveMessage();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"takeMessage", (Object)msgTaken);
        }
        return msgTaken;
    }

    private void checkWaiting() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkWaiting");
        }
        if (!this._waiting && !this._asynchConsumerRegistered) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.checkWaiting", "1:985:1.22.5.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.checkWaiting", (String)"1:991:1.22.5.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.checkWaiting", "1:998:1.22.5.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkWaiting", (Object)((Object)e));
            }
            throw e;
        }
        if (this._waiting || this._isolatedRun) {
            this._waiter.signal();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkWaiting");
        }
    }

    private boolean attachAndLockMsg(SIMPMessage msgItem, boolean isOnItemStream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachAndLockMsg", (Object)new Object[]{msgItem, isOnItemStream, this});
        }
        if (this._msgAttached) {
            String text = "Message already attached [";
            if (this._attachedMessage != null) {
                text = text + this._attachedMessage.getMessage().getMessageHandle();
            }
            text = text + "," + msgItem.getMessage().getMessageHandle() + "]";
            SIErrorException e = new SIErrorException(text);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.attachAndLockMsg", (String)"1:1057:1.22.5.1", (Object)this);
        }
        if (isOnItemStream) {
            if (this._consumerSession.getForwardScanning()) {
                this._msgLocked = false;
                this._msgAttached = true;
                this._msgOnItemStream = true;
                this._attachedMessage = null;
            } else {
                LockingCursor cursor = this._consumerKey.getGetCursor(msgItem);
                try {
                    this._msgLocked = msgItem.lockItemIfAvailable(cursor.getLockID());
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.attachAndLockMsg", (String)"1:1094:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    this._msgLocked = false;
                    this._msgAttached = true;
                    this._msgOnItemStream = true;
                    this._attachedMessage = null;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachAndLockMsg", (Object)((Object)e));
                    }
                    throw new SIResourceException((Throwable)e);
                }
                if (this._msgLocked) {
                    this._msgAttached = true;
                    this._msgOnItemStream = true;
                    this._attachedMessage = msgItem;
                } else {
                    this._msgAttached = true;
                    this._msgOnItemStream = true;
                    this._attachedMessage = null;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Missed the message!");
                    }
                }
            }
        } else {
            this._msgLocked = false;
            this._msgAttached = true;
            this._msgOnItemStream = false;
            this._attachedMessage = msgItem;
        }
        if (this._msgAttached && this._keyGroup != null) {
            this._keyGroup.attachMessage(this._consumerKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachAndLockMsg", (Object)(this._attachedMessage != null ? 1 : 0));
        }
        return this._attachedMessage != null;
    }

    SIMPMessage getAttachedMessage() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedMessage", (Object)this);
        }
        SIMPMessage msg = null;
        if (this._msgAttached) {
            msg = this._msgOnItemStream && !this._msgLocked ? this.getEligibleMsgLocked(null) : this._attachedMessage;
            this._msgAttached = false;
            this._msgLocked = false;
            this._attachedMessage = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttachedMessage", (Object)msg);
        }
        return msg;
    }

    private boolean checkReceiveAllowed() throws SISessionUnavailableException, SIResourceException {
        boolean allowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReceiveAllowed");
        }
        if (!(allowed = this._destinationAttachedTo.isReceiveAllowed())) {
            this._stoppedForReceiveAllowed = true;
            if (!this._stopped) {
                this.internalStop();
            }
        } else {
            this._stoppedForReceiveAllowed = false;
            if (this._stopped && !this._stoppedByRequest) {
                this.internalStart(false);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReceiveAllowed", (Object)allowed);
        }
        return allowed;
    }

    private void checkReceiveState() throws SIIncorrectCallException, SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkReceiveState");
        }
        this.checkNotClosed();
        if (this._asynchConsumerRegistered) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkReceiveState", (Object)"asynchConsumerRegistered == true ");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0171", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (this._waiting) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0178", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkReceiveState", (Object)"receive already in progress");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkReceiveState");
        }
    }

    private void removeUnwantedMsgs(List<SIMPMessage> unwantedMsgList, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)new Object[]{this, unwantedMsgList, tran});
        }
        LocalTransaction localTran = null;
        Transaction msTran = null;
        if (tran == null) {
            localTran = this._txManager.createLocalTransaction(true);
            msTran = (Transaction)localTran;
        } else {
            msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
        }
        Iterator<SIMPMessage> it = unwantedMsgList.iterator();
        while (it.hasNext()) {
            try {
                SIMPMessage unwanted = it.next();
                unwanted.remove(msTran, this._consumerKey.getGetCursor(unwanted).getLockID());
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeUnwantedMsgs", (String)"1:1340:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1348:1.22.5.1", SIMPUtils.getStackTrace(e), this._consumerDispatcher.getDestination().getName()});
                this._waiting = false;
                this.unsetReady();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1365:1.22.5.1", e, this._consumerDispatcher.getDestination().getName()}, null), (Throwable)e);
            }
        }
        try {
            if (localTran != null) {
                localTran.commit();
            }
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeUnwantedMsgs", (String)"1:1387:1.22.5.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            this._waiting = false;
            this.unsetReady();
            try {
                localTran.rollback();
            }
            catch (SIException ee) {
                FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeUnwantedMsgs", (String)"1:1408:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1416:1.22.5.1", SIMPUtils.getStackTrace(ee)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)ee));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1428:1.22.5.1", ee}, null), (Throwable)ee);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1441:1.22.5.1", SIMPUtils.getStackTrace(e)});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1449:1.22.5.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeUnwantedMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SIMPMessage getEligibleMsgLocked(TransactionCommon tranImpl) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEligibleMsgLocked", (Object)new Object[]{this, tranImpl});
        }
        SIMPMessage msg = null;
        boolean msgAccepted = this.prepareAddActiveMessage();
        if (!msgAccepted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"The consumer (or its set) is currently maxed out");
            }
        } else {
            try {
                msg = this.retrieveMsgLocked();
                if (msg != null && this._consumerDispatcher.getConsumerDispatcherState().isNoLocal()) {
                    LinkedList<SIMPMessage> markedForDeletion = new LinkedList<SIMPMessage>();
                    int msgCount = 0;
                    while (msg != null && this._connectionUuid.equals((Object)msg.getProducerConnectionUuid())) {
                        markedForDeletion.add(msg);
                        if (++msgCount >= 10) {
                            this.removeUnwantedMsgs(markedForDeletion, null);
                            markedForDeletion.clear();
                            msgCount = 0;
                        }
                        msg = this.retrieveMsgLocked();
                    }
                    if (!markedForDeletion.isEmpty()) {
                        TransactionCommon tran = null;
                        if (tranImpl != null && msg != null) {
                            tran = tranImpl;
                        }
                        this.removeUnwantedMsgs(markedForDeletion, tran);
                    }
                }
            }
            finally {
                if (msg != null) {
                    this.commitAddActiveMessage();
                } else {
                    this.rollbackAddActiveMessage();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEligibleMsgLocked", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsMessage receive(long originalTimeout, TransactionCommon transaction) throws SISessionUnavailableException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        long startTimeMillis;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receive", (Object)new Object[]{this, originalTimeout, transaction});
        }
        if (transaction != null && !transaction.isAlive()) {
            SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{this._destinationAttachedTo}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)e));
            }
            throw e;
        }
        boolean timeToRun = true;
        SIMPMessage msg = null;
        long timeout = originalTimeout;
        long currentTimeMillis = startTimeMillis = System.currentTimeMillis();
        boolean messageLocked = false;
        boolean wasMessageOnStream = false;
        boolean localTranCreated = false;
        LocalTransaction localTran = null;
        while (timeToRun) {
            this.lock();
            try {
                this.checkReceiveState();
                if (this._destinationAttachedTo.isOrdered() && !this._consumerDispatcher.isNewTransactionAllowed(transaction)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"receive", (Object)"SISessionUnavailableException - transaction active");
                    }
                    throw new SISessionUnavailableException(nls.getFormattedMessage("ORDERED_TRANSACTED_RECEIVE_ERROR_CWSIP0180", new Object[]{this._destinationAttachedTo.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                this._waiting = true;
                this._transacted = transaction != null;
                if (this._stopped || (this._suspendFlags & 1) > 0) {
                    this._waitingToStart = true;
                } else {
                    this.setReady();
                    msg = this.getEligibleMsgLocked(transaction);
                    if (msg != null) {
                        messageLocked = true;
                        timeToRun = false;
                        this.unsetReady();
                    }
                }
                if (msg == null || this._gatherMessages) {
                    timeout = this._consumerKey.waiting(timeout, true);
                    if (originalTimeout == -1L) {
                        originalTimeout = timeout - (System.currentTimeMillis() - startTimeMillis);
                    }
                }
                if (timeout == -1L) {
                    timeToRun = false;
                }
                if (msg == null && timeToRun) {
                    try {
                        if (timeout == 0L) {
                            this._waiter.await();
                        } else {
                            this._waiter.await(timeout, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this._waitingToStart = false;
                this._waiting = false;
                this.unsetReady();
                if (this._msgAttached) {
                    wasMessageOnStream = this._msgOnItemStream;
                    msg = this.getAttachedMessage();
                    if (msg != null) {
                        if (wasMessageOnStream) {
                            messageLocked = true;
                        }
                        timeToRun = false;
                    }
                } else if (this._notifiedException != null) {
                    Throwable e = this._notifiedException;
                    this._notifiedException = null;
                    SibTr.exception((TraceComponent)tc, (Throwable)e);
                    if (e instanceof SISessionUnavailableException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receive", (Object)e);
                        }
                        throw (SISessionUnavailableException)e;
                    }
                    if (e instanceof SIIncorrectCallException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receive", (Object)e);
                        }
                        throw (SIIncorrectCallException)e;
                    }
                    if (e instanceof SIResourceException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receive", (Object)e);
                        }
                        throw (SIResourceException)e;
                    }
                    if (e instanceof SINotPossibleInCurrentConfigurationException) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"receive", (Object)e);
                        }
                        throw (SINotPossibleInCurrentConfigurationException)e;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"receive", (Object)e);
                    }
                    throw new SIErrorException(e);
                }
            }
            finally {
                this.unlock();
            }
            if (!timeToRun || timeout == 0L || (timeout = originalTimeout - ((currentTimeMillis = System.currentTimeMillis()) - startTimeMillis)) > 0L) continue;
            timeToRun = false;
        }
        JsMessage returnMsg = null;
        if (msg != null) {
            try {
                returnMsg = (messageLocked || this._consumerDispatcher.isPubSub()) && ((ConnectionImpl)this._consumerSession.getConnection()).getMessageCopiedWhenReceived() ? msg.getMessage().getReceived() : msg.getMessage();
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.receive", (String)"1:1856:1.22.5.1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1862:1.22.5.1", SIMPUtils.getStackTrace(e)});
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:1875:1.22.5.1", e}, null), (Throwable)e);
            }
            if (!msg.isItemReference() && (msg.getReportCOD() != null || msg.isFromRemoteME())) {
                if (!messageLocked) {
                    ((MessageItem)msg).beforeCompletion(this._autoCommitTransaction);
                } else {
                    if (transaction == null) {
                        localTran = this._txManager.createLocalTransaction(false);
                        transaction = localTran;
                        localTranCreated = true;
                    }
                    transaction.registerCallback((TransactionCallback)msg);
                }
            }
            if (returnMsg != null && messageLocked) {
                if (msg.guessRedeliveredCount() != 0) {
                    returnMsg.setRedeliveredCount(msg.guessRedeliveredCount());
                }
                long waitTime = msg.updateStatisticsMessageWaitTime();
                if (((ConnectionImpl)this._consumerSession.getConnection()).getSetWaitTimeInMessage()) {
                    returnMsg.setMessageWaitTime(waitTime);
                }
            }
            try {
                if (messageLocked) {
                    if (transaction == null) {
                        transaction = this._autoCommitTransaction;
                    }
                    Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
                    if (this._destinationAttachedTo.isOrdered()) {
                        this._consumerDispatcher.setCurrentTransaction(transaction, null);
                    }
                    if (this._consumerKey.getConsumerSet() != null || this._bifurcatable && this._maxActiveMessages != 0) {
                        transaction.registerCallback((TransactionCallback)this);
                    }
                    msg.remove(msTran, this._consumerKey.getGetCursor(msg).getLockID());
                    if (localTranCreated) {
                        localTran.commit();
                        transaction = null;
                    }
                } else if (this._consumerKey.getConsumerSet() != null || this._bifurcatable && this._maxActiveMessages != 0) {
                    this.removeActiveMessages(1);
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.receive", (String)"1:2010:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:2018:1.22.5.1", SIMPUtils.getStackTrace(e), this._consumerDispatcher.getDestination().getName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"receive", (Object)((Object)e));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:2030:1.22.5.1", e, this._consumerDispatcher.getDestination().getName()}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && returnMsg != null) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("verboseMsg OUT : " + returnMsg.toVerboseString()));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receive", msg);
        }
        return returnMsg;
    }

    protected void waitingNotify() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitingNotify");
        }
        this.lock();
        try {
            if (this._waiting) {
                this._waiter.signal();
            }
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitingNotify");
        }
    }

    private SIMPMessage retrieveMsgLocked() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)new Object[]{this});
        }
        SIMPMessage msg = null;
        try {
            msg = this._consumerKey.getMessageLocked();
            if (msg != null) {
                msg.eventLocked();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.retrieveMsgLocked", (String)"1:2101:1.22.5.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:2108:1.22.5.1", SIMPUtils.getStackTrace(e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:2119:1.22.5.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMsgLocked", (Object)msg);
        }
        return msg;
    }

    private void checkParams(int maxActiveMessages, long messageLockExpiry, int maxBatchSize) throws SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkParams", (Object)new Object[]{maxActiveMessages, messageLockExpiry, maxBatchSize});
        }
        if (maxActiveMessages < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException maxActiveMessages < 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0141", new Object[]{maxActiveMessages}, null));
        }
        if (messageLockExpiry < 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException messageLockExpiry < 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0142", new Object[]{messageLockExpiry}, null));
        }
        if (maxBatchSize <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkParams", (Object)"SIIncorrectCallException maxBatchSize <= 0");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("REG_ASYNCH_CONSUMER_ERROR_CWSIR0143", new Object[]{maxBatchSize}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkParams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAsynchConsumer(AsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, Reliability unrecoverableReliability, boolean inLine, OrderingContextImpl orderingGroup, ExternalConsumerLock optionalCallbackBusyLock) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)new Object[]{this, callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, orderingGroup, optionalCallbackBusyLock});
        }
        this.checkParams(maxActiveMessages, messageLockExpiry, maxBatchSize);
        if (optionalCallbackBusyLock != null) {
            this._asynchConsumerBusyLock = optionalCallbackBusyLock;
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this.lock();
            try {
                this.checkNotClosed();
                if (!this._stopped) {
                    SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_RUN_ERROR_CWSIP0176", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)((Object)e));
                    }
                    throw e;
                }
                if (this._waiting) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)"waiting == true");
                    }
                    throw new SIIncorrectCallException(nls.getFormattedMessage("RECEIVE_USAGE_ERROR_CWSIP0174", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (unrecoverableReliability != null) {
                    this.setUnrecoverability(unrecoverableReliability);
                }
                this._asynchConsumer.registerCallback(callback);
                if (callback != null) {
                    if (this._destinationAttachedTo.isOrdered() && maxBatchSize > 1) {
                        this._maxBatchSize = 1;
                        SibTr.warning((TraceComponent)tc, (SibTr.Suppressor)SibTr.Suppressor.ALL_AFTER_FIRST_SIMILAR_INSERTS, (String)"MAX_BATCH_SIZE_OVERRIDE_WARNING_CWSIP0181", (Object)new Object[]{this._destinationAttachedTo.getName()});
                    } else {
                        this._maxBatchSize = maxBatchSize;
                    }
                    this._inLine = inLine;
                    this._maxActiveMessages = maxActiveMessages;
                    if (this._maxActiveMessages > 0) {
                        this._activeMsgBlockInterval = -1;
                        Object value = this._destinationAttachedTo.getContextValue("MsgBlockWarningInterval");
                        if (value != null && value instanceof Integer) {
                            this._activeMsgBlockInterval = (Integer)value;
                            if (this._activeMsgBlockInterval < 0) {
                                this._activeMsgBlockInterval = -1;
                            }
                        }
                    }
                    this._currentActiveMessages = 0;
                    this._allLockedMessages.setMessageLockExpiry(messageLockExpiry);
                    this._asynchConsumerRegistered = true;
                    this._transacted = true;
                    if (orderingGroup != null && !this._destinationAttachedTo.isPubSub() && !this._consumerSession.getReadAhead() && this._orderingGroup != orderingGroup) {
                        if (this._orderingGroup != null) {
                            this._consumerKey.leaveKeyGroup();
                        }
                        this._orderingGroup = orderingGroup;
                        try {
                            this._keyGroup = (LocalQPConsumerKeyGroup)this._consumerDispatcher.joinKeyGroup(this._consumerKey, orderingGroup);
                        }
                        catch (SIResourceException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.registerAsynchConsumer", (String)"1:2367:1.22.5.1", (Object)this);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer", (Object)"SIIncorrectCallException");
                            }
                            throw new SIIncorrectCallException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2376:1.22.5.1", SIMPUtils.getStackTrace(e)}, null));
                        }
                        if (this._keyGroup != null && optionalCallbackBusyLock == null) {
                            this._asynchConsumerBusyLock = this._keyGroup.getAsynchGroupLock();
                        }
                    }
                } else {
                    this._asynchConsumerRegistered = false;
                    this.resetBaseUnrecoverability();
                    this._inLine = false;
                    if (this._orderingGroup != null) {
                        this._consumerKey.leaveKeyGroup();
                        this._keyGroup = null;
                        this._asynchConsumerBusyLock = this._asynchConsumer;
                        this._orderingGroup = null;
                    }
                }
                this._externalConsumerLock = optionalCallbackBusyLock;
            }
            finally {
                this.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerAsynchConsumer");
        }
    }

    boolean processAttachedMsgs() throws SIResourceException, SISessionDroppedException {
        ConsumableKey attachedKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAttachedMsgs", (Object)this);
        }
        SIMPMessage msg = null;
        this.lock();
        try {
            msg = this.getAttachedMessage();
        }
        finally {
            this.unlock();
        }
        if (this._keyGroup != null && (attachedKey = this._keyGroup.getAttachedMember()) != null && attachedKey != this._consumerKey) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs");
            }
            return ((JSLocalConsumerPoint)attachedKey.getConsumerPoint()).processAttachedMsgs();
        }
        if (msg != null) {
            if (!this._msgOnItemStream && !this._bifurcatable) {
                if (!msg.isItemReference() && msg.getReportCOD() != null) {
                    ((MessageItem)msg).beforeCompletion(this._autoCommitTransaction);
                }
                if (this._singleLockedMessageEnum != null) {
                    this._singleLockedMessageEnum.newMessage(msg);
                } else {
                    this._singleLockedMessageEnum = new SingleLockedMessageEnumerationImpl(this, msg);
                }
                this._asynchConsumer.processMsgs((LockedMessageEnumeration)this._singleLockedMessageEnum, (ConsumerSession)this._consumerSession);
                this.removeActiveMessages(1);
                this._singleLockedMessageEnum.clearMessage();
            } else {
                boolean isRecoverable = true;
                if (this._unrecoverableOptions != Reliability.NONE && msg.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
                    isRecoverable = false;
                }
                this.registerForEvents(msg);
                this._allLockedMessages.addNewMessage(msg, this._msgOnItemStream, isRecoverable);
                this._asynchConsumer.processMsgs((LockedMessageEnumeration)this._allLockedMessages, (ConsumerSession)this._consumerSession);
                this._allLockedMessages.resetCallbackCursor();
            }
            if (this._externalConsumerLock != null) {
                this._interruptConsumer = this._externalConsumerLock.isLockYieldRequested();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs", (Object)Boolean.TRUE);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAttachedMsgs", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSLocalConsumerPoint processQueuedMsgs(boolean isolatedRun) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processQueuedMsgs", (Object)new Object[]{this, isolatedRun});
        }
        JSLocalConsumerPoint actualConsumer = this;
        boolean started = true;
        this._drainQueue = true;
        long timeout = 0L;
        if (isolatedRun) {
            timeout = -1L;
        }
        int numOfMsgs = 0;
        boolean isolatedWait = false;
        this._transferredConsumer = null;
        if (this._lockRequested) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Yield requested");
            }
            Thread.yield();
        }
        ConsumableKey attachedKey = null;
        if (this._keyGroup != null) {
            this._keyGroup.lock();
        }
        try {
            this.lock();
            try {
                if (this._closed || this.isSuspended() || !this._asynchConsumerRegistered) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"processQueuedMsgs", (Object)("Closed:" + this._closed + " Suspended:" + this._consumerSuspended));
                    }
                    started = false;
                    this._drainQueue = false;
                } else {
                    if (this._keyGroup != null) {
                        attachedKey = this._keyGroup.getAttachedMember();
                    } else if (this._msgAttached) {
                        attachedKey = this._consumerKey;
                    }
                    if (attachedKey == null && this._drainQueue) {
                        numOfMsgs = this.lockMessages(isolatedRun);
                        if (this._transferredConsumer != null) {
                            actualConsumer = this._transferredConsumer;
                        }
                        if (this._ready && this._keyGroup == null || this._keyGroup != null && this._keyGroup.isGroupReady()) {
                            timeout = this._consumerKey.waiting(timeout, true);
                            isolatedWait = this._isolatedRun;
                        } else if (this._gatherMessages) {
                            this._consumerKey.waiting(timeout, true);
                        }
                    }
                }
            }
            finally {
                this.unlock();
            }
        }
        finally {
            if (this._keyGroup != null) {
                this._keyGroup.unlock();
            }
        }
        if (attachedKey != null) {
            ((JSLocalConsumerPoint)attachedKey.getConsumerPoint()).processAttachedMsgs();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processQueuedMsgs", (Object)actualConsumer);
            }
            return (JSLocalConsumerPoint)attachedKey.getConsumerPoint();
        }
        if (started && numOfMsgs > 0 && actualConsumer == this) {
            this._asynchConsumer.processMsgs((LockedMessageEnumeration)this._allLockedMessages, (ConsumerSession)this._consumerSession);
            this._allLockedMessages.resetCallbackCursor();
            this._drainQueue = !isolatedRun;
        }
        if (actualConsumer != this) {
            actualConsumer.processTransferredMsg();
        }
        if (isolatedWait) {
            this.lock();
            try {
                if (!this._msgAttached) {
                    try {
                        if (timeout == 0L) {
                            this._waiter.await();
                        } else {
                            this._waiter.await(timeout, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.unsetReady();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Finished isolatedrun request set to FALSE");
                }
                this._isolatedRun = false;
            }
            finally {
                this.unlock();
            }
            this.processAttachedMsgs();
        }
        if (this._externalConsumerLock != null && !this._interruptConsumer) {
            this._interruptConsumer = this._externalConsumerLock.isLockYieldRequested();
        }
        if (!this._drainQueue) {
            actualConsumer = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processQueuedMsgs", (Object)actualConsumer);
        }
        return actualConsumer;
    }

    protected void processTransferredMsg() throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processTransferredMsg", (Object)this);
        }
        this._asynchConsumer.processMsgs((LockedMessageEnumeration)this._allLockedMessages, (ConsumerSession)this._consumerSession);
        this._allLockedMessages.resetCallbackCursor();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processTransferredMsg");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lockMessages(boolean isolatedRun) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lockMessages", (Object)new Object[]{this, isolatedRun});
        }
        int numOfMsgs = 0;
        this._transferredConsumer = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("GatherMessages: " + Boolean.valueOf(this._gatherMessages) + ", instance isolatedRun: " + Boolean.valueOf(this._isolatedRun) + ", _hasLocalQP: " + Boolean.valueOf(this._hasLocalQP)));
        }
        if (!isolatedRun || !this._hasLocalQP || this._gatherMessages) {
            if (this._stopped && !isolatedRun) {
                this.unsetReady();
                this._drainQueue = false;
            } else {
                try {
                    this.setReady();
                }
                catch (SINotPossibleInCurrentConfigurationException e) {
                    this._drainQueue = false;
                }
            }
            if (isolatedRun) {
                this._isolatedRun = isolatedRun;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Instance isolatedRun: " + Boolean.valueOf(this._isolatedRun)));
            }
        }
        if (this._keyGroup != null && !this._keyGroup.isStarted()) {
            this._drainQueue = false;
        }
        boolean consumerReady = true;
        int currentMaxBatchSize = this._maxBatchSize;
        if (this._consumerStoppable && currentMaxBatchSize > 1 && this._hiddenMessages.size() > 0) {
            int remainingHiddenSpace = this._maxSequentialFailuresThreshold - this._hiddenMessages.size();
            if (remainingHiddenSpace < 1) {
                remainingHiddenSpace = 1;
            }
            if (remainingHiddenSpace < currentMaxBatchSize) {
                currentMaxBatchSize = remainingHiddenSpace;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"lockMessages", (Object)("Cropped maxBatchSize to " + currentMaxBatchSize));
            }
        }
        while (!(numOfMsgs >= currentMaxBatchSize || !this._drainQueue || this._lockRequested && numOfMsgs != 0 || this._interruptConsumer && numOfMsgs != 0 || this._transferredConsumer != null)) {
            SIMPMessage msg = null;
            if (this._keyGroup != null) {
                this._keyGroup.setConsumerActive(true);
            }
            if ((msg = this.getEligibleMsgLocked(null)) != null) {
                JSLocalConsumerPoint matchingConsumer = this;
                if (this._keyGroup != null) {
                    matchingConsumer = (JSLocalConsumerPoint)this._keyGroup.getMatchingMember(this._consumerKey).getConsumerPoint();
                    this._keyGroup.setConsumerActive(false);
                }
                if (matchingConsumer == this) {
                    if (consumerReady) {
                        consumerReady = false;
                        this.unsetReady();
                    }
                    boolean isRecoverable = true;
                    if (this._unrecoverableOptions != Reliability.NONE && msg.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
                        isRecoverable = false;
                    }
                    this.registerForEvents(msg);
                    this._allLockedMessages.addNewMessage(msg, true, isRecoverable);
                    ++numOfMsgs;
                    if (this._externalConsumerLock != null) {
                        this._interruptConsumer = this._externalConsumerLock.isLockYieldRequested();
                    }
                } else {
                    if (numOfMsgs > 0) {
                        try {
                            msg.unlockMsg(msg.getLockID(), null, true);
                            msg = null;
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.lockMessages", (String)"1:2995:1.22.5.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"lockMessages", (Object)((Object)e));
                            }
                            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:3008:1.22.5.1", e}, null), (Throwable)e);
                        }
                    }
                    ++numOfMsgs;
                    this._transferredConsumer = matchingConsumer;
                    this._transferredConsumer.lock();
                    try {
                        this._transferredConsumer.unsetReady();
                        this._transferredConsumer.addLockedMessage(msg);
                    }
                    finally {
                        this._transferredConsumer.unlock();
                    }
                    if (this._externalConsumerLock != null) {
                        this._interruptConsumer = this._externalConsumerLock.isLockYieldRequested();
                    }
                }
            }
            if (msg == null) {
                this._drainQueue = false;
            }
            if (this._externalConsumerLock == null) continue;
            this._interruptConsumer = this._externalConsumerLock.isLockYieldRequested();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Instance isolatedRun: " + Boolean.valueOf(this._isolatedRun) + ", method isolatedRun: " + Boolean.valueOf(isolatedRun) + ", ready: " + Boolean.valueOf(this._ready)));
        }
        if (isolatedRun && !this._ready) {
            this._isolatedRun = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lockMessages", (Object)numOfMsgs);
        }
        return numOfMsgs;
    }

    protected void addLockedMessage(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLockedMessage", (Object)new Object[]{this, msg});
        }
        this.unsetReady();
        boolean isRecoverable = true;
        if (this._unrecoverableOptions != Reliability.NONE && msg.getReliability().compareTo((Object)this._unrecoverableOptions) <= 0) {
            isRecoverable = false;
        }
        this._allLockedMessages.addNewMessage(msg, true, isRecoverable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLockedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runIsolatedAsynch(boolean deliverImmediately) throws SIIncorrectCallException, SISessionUnavailableException, SIResourceException {
        block25: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)new Object[]{this, deliverImmediately});
            }
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                this.lock();
                try {
                    this.checkNotClosed();
                    if (!this._asynchConsumerRegistered) {
                        SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_ERROR_CWSIP0175", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)((Object)e));
                        }
                        throw e;
                    }
                    if (!this._stopped) {
                        SIIncorrectCallException e = new SIIncorrectCallException(nls.getFormattedMessage("ASYNCH_CONSUMER_RUN_ERROR_CWSIP0176", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)((Object)e));
                        }
                        throw e;
                    }
                    if (this._stoppedForReceiveAllowed) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)"Receive not allowed");
                        }
                        return;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            if (deliverImmediately) {
                try {
                    this.runAsynchConsumer(true);
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.runIsolatedAsynch", (String)"1:3182:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Throwable)e);
                    try {
                        this._consumerSession.close();
                    }
                    catch (Exception ee) {
                        SibTr.exception((TraceComponent)tc, (Exception)ee);
                    }
                    if (e instanceof ThreadDeath) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)e);
                        }
                        throw (ThreadDeath)e;
                    }
                    SISessionDroppedException sessionDroppedException = new SISessionDroppedException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null), e);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)((Object)sessionDroppedException));
                    }
                    throw sessionDroppedException;
                }
            }
            try {
                this._messageProcessor.startNewThread(new AsynchThread(this, true));
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block25;
                SibTr.debug((TraceComponent)tc, (String)"runIsolatedAsynch", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runIsolatedAsynch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsynchConsumer(boolean isolatedRun) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runAsynchConsumer", (Object)new Object[]{this, isolatedRun});
        }
        JSLocalConsumerPoint nextConsumer = this;
        boolean firstTimeRound = true;
        do {
            if (this._interruptConsumer) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"External yield requested");
                }
                Thread.yield();
                if (!this._stopped && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Yield appears to have been ignored");
                }
            }
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                if (!this._runningAsynchConsumer || !firstTimeRound && this._runningAsynchConsumer) {
                    if (this._stopped && !isolatedRun || !this._stopped && isolatedRun || this._closed || !this._asynchConsumerRegistered) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("We've been interferred with: " + this._stopped + ", " + this._closed + ", " + this._asynchConsumerRegistered));
                        }
                        nextConsumer = null;
                        this._runningAsynchConsumer = false;
                    } else {
                        if (firstTimeRound) {
                            firstTimeRound = false;
                            boolean msgDelivered = this.processAttachedMsgs();
                            if (!msgDelivered || !isolatedRun) {
                                nextConsumer = this.processQueuedMsgs(isolatedRun);
                            }
                        }
                        if (!isolatedRun && nextConsumer != null) {
                            nextConsumer = nextConsumer.processQueuedMsgs(isolatedRun);
                        }
                        this._runningAsynchConsumer = nextConsumer != null;
                    }
                    if (!this._runningAsynchConsumer && this._runAsynchConsumerInterupted) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"We've been told to stop, wake up whoever asked us");
                        }
                        this._runAsynchConsumerInterupted = false;
                        this._asynchConsumerBusyLock.notifyAll();
                    }
                } else {
                    nextConsumer = null;
                }
            }
        } while (nextConsumer != null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runAsynchConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close", (Object)this);
        }
        this._interruptConsumer = true;
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            if (this._closed || this._closing) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"close", (Object)"Already Closed");
                }
                return;
            }
            this._lockRequested = true;
            if (this._keyGroup != null) {
                this._keyGroup.lock();
            }
            try {
                this.lock();
                try {
                    this._lockRequested = false;
                    this._consumerKey.stop();
                    this.unsetReady();
                    this._closing = true;
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                if (this._keyGroup != null) {
                    this._keyGroup.unlock();
                }
            }
            if (this._asynchConsumerRegistered) {
                if (!this._asynchConsumer.isAsynchConsumerRunning()) {
                    try {
                        this.processAttachedMsgs();
                    }
                    catch (SISessionDroppedException sISessionDroppedException) {
                        // empty catch block
                    }
                }
                if (this._keyGroup != null) {
                    this._consumerKey.leaveKeyGroup();
                    this._keyGroup = null;
                }
            }
            this.lock();
            try {
                JSLockedMessageEnumeration jSLockedMessageEnumeration = this._allLockedMessages;
                synchronized (jSLockedMessageEnumeration) {
                    try {
                        this._allLockedMessages.unlockAll();
                    }
                    catch (SIMPMessageNotLockedException sIMPMessageNotLockedException) {
                    }
                    catch (SISessionDroppedException sISessionDroppedException) {
                        // empty catch block
                    }
                    this._closed = true;
                }
                if (this._waiting) {
                    this._waiter.signal();
                }
            }
            finally {
                this.unlock();
            }
            this._interruptConsumer = false;
            if (this._runningAsynchConsumer && !this._asynchConsumer.isAsynchConsumerRunning()) {
                this._runAsynchConsumerInterupted = true;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Waiting for runAsynchConsumer to complete");
                    }
                    this._asynchConsumerBusyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.unlockAllHiddenMessages();
        this._consumerKey.detach();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public boolean isClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isClosed", (Object)this);
            SibTr.exit((TraceComponent)tc, (String)"isClosed", (Object)this._closed);
        }
        return this._closed;
    }

    private boolean isSuspended() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSuspended", (Object)this);
        }
        boolean suspended = true;
        if (!this._consumerSuspended) {
            if (this._consumerKey.isConsumerSetSuspended()) {
                this.suspendConsumer(8);
            } else {
                suspended = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSuspended", (Object)suspended);
        }
        return suspended;
    }

    @Override
    public void start(boolean deliverImmediately) throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)new Object[]{deliverImmediately, this});
        }
        this._stoppedByRequest = false;
        this.internalStart(deliverImmediately);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStart(boolean deliverImmediately) throws SISessionUnavailableException {
        block28: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"internalStart", (Object)new Object[]{deliverImmediately, this});
            }
            boolean spinOffANewThread = false;
            Object object = this._asynchConsumerBusyLock;
            synchronized (object) {
                this._interruptConsumer = false;
                if (this._keyGroup != null) {
                    this._keyGroup.lock();
                }
                try {
                    this.lock();
                    try {
                        this.checkNotClosed();
                        this._startSinceSequentialStop = true;
                        if (!this._stoppedForReceiveAllowed) {
                            this._stopped = false;
                            this._consumerKey.start();
                            if (this._waitingToStart) {
                                this._waiter.signal();
                            }
                        }
                    }
                    finally {
                        this.unlock();
                    }
                }
                finally {
                    if (this._keyGroup != null) {
                        this._keyGroup.unlock();
                    }
                }
                if (this._asynchConsumerRegistered && !this._asynchConsumer.isAsynchConsumerRunning()) {
                    if (deliverImmediately) {
                        try {
                            this.runAsynchConsumer(false);
                        }
                        catch (Throwable e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.internalStart", (String)"1:3784:1.22.5.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Throwable)e);
                            try {
                                this._consumerSession.close();
                            }
                            catch (Exception ee) {
                                SibTr.exception((TraceComponent)tc, (Exception)ee);
                            }
                            if (e instanceof ThreadDeath) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"internalStart", (Object)e);
                                }
                                throw (ThreadDeath)e;
                            }
                            SISessionDroppedException sessionDroppedException = new SISessionDroppedException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null), e);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"internalStart", (Object)((Object)sessionDroppedException));
                            }
                            throw sessionDroppedException;
                        }
                    }
                    spinOffANewThread = true;
                }
            }
            if (spinOffANewThread) {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.internalStart", (String)"1:3845:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block28;
                    SibTr.exit((TraceComponent)tc, (String)"internalStart", (Object)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalStart");
        }
    }

    @Override
    public void checkForMessages() {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkForMessages", (Object)this);
            }
            try {
                this._messageProcessor.startNewThread(new AsynchThread(this, false));
            }
            catch (InterruptedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.checkForMessages", (String)"1:3881:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block4;
                SibTr.exit((TraceComponent)tc, (String)"checkForMessages", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkForMessages");
        }
    }

    @Override
    public void stop() throws SISessionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)this);
        }
        this._stoppedByRequest = true;
        this.internalStop();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalStop() throws SISessionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalStop", (Object)this);
        }
        this._interruptConsumer = true;
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this._lockRequested = true;
            if (this._keyGroup != null) {
                this._keyGroup.lock();
            }
            try {
                this.lock();
                try {
                    this._lockRequested = false;
                    this.checkNotClosed();
                    this._stopped = true;
                    this._consumerKey.stop();
                    this.unsetReady();
                    if (this._waiting) {
                        this._waitingToStart = true;
                    }
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                if (this._keyGroup != null) {
                    this._keyGroup.unlock();
                }
            }
            if (this._asynchConsumerRegistered && !this._asynchConsumer.isAsynchConsumerRunning()) {
                this.processAttachedMsgs();
            }
            this._interruptConsumer = false;
            if (this._runningAsynchConsumer && !this._asynchConsumer.isAsynchConsumerRunning()) {
                this._runAsynchConsumerInterupted = true;
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Waiting for runAsynchConsumer to complete");
                    }
                    this._asynchConsumerBusyLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalStop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll() throws SISessionUnavailableException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)this);
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this.lock();
            try {
                this.checkNotClosed();
                try {
                    this._allLockedMessages.unlockAll();
                }
                catch (SIMPMessageNotLockedException sIMPMessageNotLockedException) {
                    // empty catch block
                }
            }
            finally {
                this.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll");
        }
    }

    private void setBaseRecoverability(Reliability unrecoverableReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBaseRecoverability", (Object)new Object[]{this, unrecoverableReliability});
        }
        this.setUnrecoverability(unrecoverableReliability);
        this._baseUnrecoverableOptions = this._unrecoverableOptions;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBaseRecoverability");
        }
    }

    private void resetBaseUnrecoverability() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetBaseUnrecoverability", (Object)this);
        }
        this._unrecoverableOptions = this._baseUnrecoverableOptions;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetBaseUnrecoverability");
        }
    }

    private void setUnrecoverability(Reliability unrecoverableReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUnrecoverability", (Object)new Object[]{this, unrecoverableReliability});
        }
        this._unrecoverableOptions = unrecoverableReliability;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setUnrecoverability");
        }
    }

    private void setReady() throws SINotPossibleInCurrentConfigurationException {
        Reliability unrecoverable = Reliability.ASSURED_PERSISTENT;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReady", (Object)this);
        }
        if (this._transacted) {
            unrecoverable = this._unrecoverableOptions;
        }
        this._ready = true;
        if (this._keyGroup != null) {
            this._keyGroup.groupReady();
        }
        this._consumerKey.ready(unrecoverable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReady");
        }
    }

    protected void unsetReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsetReady", (Object)this);
        }
        this._ready = false;
        if (this._keyGroup != null) {
            this._keyGroup.groupNotReady();
        }
        if (this._consumerKey != null) {
            this._consumerKey.notReady();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsetReady");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIBusMessage[] processMsgSet(SIMessageHandle[] msgHandles, TransactionCommon transaction, BifurcatedConsumerSessionImpl owner, boolean unlock, boolean delete, boolean read, boolean incrementLockCount) throws SISessionUnavailableException, SIMPMessageNotLockedException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(msgHandles), transaction, owner, unlock, delete, read});
        }
        if (this._closed || this._closing) {
            this.lock();
            try {
                this.checkNotClosed();
            }
            finally {
                this.unlock();
            }
        }
        int numMsgs = 0;
        SIBusMessage[] messages = null;
        if (msgHandles != null && msgHandles.length > 0) {
            numMsgs = msgHandles.length;
        }
        if (numMsgs > 0) {
            messages = this._allLockedMessages.processMsgSet(msgHandles, transaction, owner, unlock, delete, read, incrementLockCount);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMsgSet", messages);
        }
        return messages;
    }

    @Override
    public ConsumerSessionImpl getConsumerSession() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerSession");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerSession", (Object)this._consumerSession);
        }
        return this._consumerSession;
    }

    @Override
    public JSConsumerManager getConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerManager");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerManager", (Object)this._consumerDispatcher);
        }
        return this._consumerDispatcher;
    }

    @Override
    public void notifyException(Throwable exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyException", (Object)new Object[]{this, exception});
        }
        if (this._asynchConsumerRegistered) {
            this._asynchConsumer.notifyExceptionListeners(exception, (ConsumerSession)this._consumerSession);
        }
        this.lock();
        try {
            if (this._waiting) {
                this._notifiedException = exception;
                this._waiter.signal();
            }
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    @Override
    public void notifyReceiveAllowed(boolean isAllowed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{isAllowed, this});
        }
        this.lock();
        try {
            try {
                this.checkReceiveAllowed();
            }
            catch (SISessionUnavailableException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.notifyReceiveAllowed", (String)"1:4287:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.notifyReceiveAllowed", (String)"1:4298:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    @Override
    public void checkNotClosed() throws SISessionUnavailableException {
        if (this._closed || this._closing && !this._asynchConsumer.isAsynchConsumerRunning()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
            }
            if (this._consumerKey.isClosedDueToDelete()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"SISessionDroppedException - deleted");
                }
                throw new SISessionDroppedException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP00221", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
            }
            if (this._consumerKey.isClosedDueToReceiveExclusive()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"SISessionDroppedException - receive Exclusive");
                }
                throw new SISessionDroppedException(nls.getFormattedMessage("DESTINATION_EXCLUSIVE_ERROR_CWSIP00222", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
            }
            if (this._consumerKey.isClosedDueToLocalizationUnreachable()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"SISessionDroppedException - localisation unreachable");
                }
                throw new SISessionDroppedException(nls.getFormattedMessage("DESTINATION_UNREACHABLE_ERROR_CWSIP00223", new Object[]{this._consumerDispatcher.getDestination().getName(), this._consumerDispatcher.getMessageProcessor().getMessagingEngineName()}, null));
            }
            SISessionUnavailableException e = new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"consumer closed");
            }
            throw e;
        }
    }

    @Override
    public boolean destinationMatches(DestinationHandler destinationHandlerToCompare, JSConsumerManager consumerDispatcher) {
        boolean matches;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationMatches", (Object)new Object[]{this, destinationHandlerToCompare, consumerDispatcher});
        }
        boolean bl = matches = this._destinationAttachedTo == destinationHandlerToCompare;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationMatches", (Object)matches);
        }
        return matches;
    }

    @Override
    public DestinationHandler getNamedDestination(ConsumerDispatcher cd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination", (Object)cd);
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)this._destinationAttachedTo);
        }
        return this._destinationAttachedTo;
    }

    protected TransactionCommon getAutoCommitTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAutoCommitTransaction", (Object)this);
        }
        ExternalAutoCommitTransaction tran = this._messageProcessor.getTXManager().createAutoCommitTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAutoCommitTransaction", (Object)tran);
        }
        return tran;
    }

    @Override
    public SIBusMessage relockMessageUnderAsynchCursor() throws SISessionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor");
        }
        this.checkNotClosed();
        SIBusMessage msg = this._allLockedMessages.relockSavedMsg();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor", (Object)msg);
        }
        return msg;
    }

    private boolean prepareAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage");
        }
        boolean messageAccepted = true;
        if (this._consumerSuspended) {
            messageAccepted = false;
        } else if (!this._consumerKey.prepareAddActiveMessage()) {
            messageAccepted = false;
            this.suspendConsumer(8);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepareAddActiveMessage", (Object)new Object[]{messageAccepted});
        }
        return messageAccepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
        this._consumerKey.commitAddActiveMessage();
        if (this._bifurcatable && this._maxActiveMessages != 0) {
            Object object = this._maxActiveMessageLock;
            synchronized (object) {
                ++this._currentActiveMessages;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("_currentActiveMessages: " + this._currentActiveMessages));
                }
                if (this._currentActiveMessages == this._maxActiveMessages) {
                    this.suspendConsumer(2);
                    if (this._activeMsgBlockInterval > -1) {
                        if (this._activeMsgBlockAlarm == null) {
                            this._activeMsgBlockAlarm = new ActiveMsgBlockAlarm();
                        }
                        this._activeMsgBlockAlarm.startAlarm();
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitAddActiveMessage");
        }
    }

    private void rollbackAddActiveMessage() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
        this._consumerKey.rollbackAddActiveMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollbackAddActiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveMessages(int messages) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeActiveMessages", (Object)new Object[]{messages, this._currentActiveMessages, this._maxActiveMessages, this._consumerSuspended, this._bifurcatable});
        }
        this._consumerKey.removeActiveMessages(messages);
        if (this._bifurcatable && this._maxActiveMessages != 0) {
            boolean threasholdCrossed = false;
            Object object = this._maxActiveMessageLock;
            synchronized (object) {
                this._currentActiveMessages -= messages;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("_currentActiveMessages: " + this._currentActiveMessages));
                }
                if (this._currentActiveMessages == this._maxActiveMessages - messages) {
                    threasholdCrossed = true;
                }
                if (this._currentActiveMessages < 0) {
                    SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeActiveMessages", "1:4657:1.22.5.1", this._currentActiveMessages}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeActiveMessages", (String)"1:4664:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.removeActiveMessages", "1:4671:1.22.5.1"});
                }
            }
            if (threasholdCrossed) {
                this.lock();
                try {
                    object = this._maxActiveMessageLock;
                    synchronized (object) {
                        if (this._currentActiveMessages < this._maxActiveMessages) {
                            this.resumeConsumer(2);
                            if (this._activeMsgBlockAlarm != null) {
                                this._activeMsgBlockAlarm.cancelAlarm();
                            }
                        }
                    }
                }
                finally {
                    this.unlock();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeActiveMessages");
        }
    }

    @Override
    public boolean isCountingActiveMessages() {
        boolean isCounting = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isCountingActiveMessages");
        }
        if (this._bifurcatable && this._maxActiveMessages != 0 || this._consumerKey.getConsumerSet() != null) {
            isCounting = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isCountingActiveMessages", (Object)isCounting);
        }
        return isCounting;
    }

    @Override
    public String getConsumerSetLabel() {
        String consumerSetLabel = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerSetLabel");
        }
        consumerSetLabel = this._consumerKey.getConsumerSet().getLabel();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerSetLabel", (Object)consumerSetLabel);
        }
        return consumerSetLabel;
    }

    public int getMaxActiveMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaxActiveMessages");
            SibTr.exit((TraceComponent)tc, (String)"getMaxActiveMessages", (Object)this._maxActiveMessages);
        }
        return this._maxActiveMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxActiveMessages(int maxActiveMessages) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaxActiveMessages", (Object)maxActiveMessages);
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this.lock();
            try {
                Object object2 = this._maxActiveMessageLock;
                synchronized (object2) {
                    if (maxActiveMessages > this._maxActiveMessages && maxActiveMessages < this._currentActiveMessages) {
                        if (this._consumerSuspended) {
                            if (this._runningAsynchConsumer) {
                                this._consumerSuspended = false;
                                this._suspendFlags &= 0xFFFFFFFD;
                            } else {
                                this.resumeConsumer(2);
                            }
                        }
                    } else if (maxActiveMessages <= this._currentActiveMessages && !this._consumerSuspended) {
                        this._consumerSuspended = true;
                        this._suspendFlags |= 2;
                    }
                    this._maxActiveMessages = maxActiveMessages;
                }
            }
            finally {
                this.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxActiveMessages");
        }
    }

    @Override
    public void cleanupBifurcatedConsumer(BifurcatedConsumerSessionImpl consumer) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupBifurcatedConsumer", (Object)consumer);
        }
        this.lock();
        try {
            this._allLockedMessages.cleanOutBifurcatedMessages(consumer, this._consumerSession.getBifurcatedConsumerCloseRedeliveryMode());
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupBifurcatedConsumer");
        }
    }

    public void beforeCompletion(TransactionCommon arg0) {
    }

    public void afterCompletion(TransactionCommon tran, boolean committed) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{tran, committed});
        }
        this.removeActiveMessages(1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeConsumer(int suspendFlag) {
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"resumeConsumer", (Object)this);
            }
            boolean spinOffNewThread = false;
            try {
                this.lock();
                if (this._consumerSuspended) {
                    boolean setStillSuspended = false;
                    if (suspendFlag == 8) {
                        setStillSuspended = this._consumerKey.isConsumerSetSuspended();
                    }
                    if (!setStillSuspended) {
                        this._suspendFlags &= ~suspendFlag;
                        if (this._suspendFlags == 0) {
                            this._consumerSuspended = false;
                            if (!this._stopped && !this._closing) {
                                if (this._asynchConsumerRegistered) {
                                    if (!this._asynchConsumer.isAsynchConsumerRunning()) {
                                        spinOffNewThread = true;
                                    }
                                } else {
                                    this._waiter.signal();
                                }
                            }
                        }
                    }
                }
            }
            finally {
                this.unlock();
            }
            if (spinOffNewThread) {
                try {
                    this._messageProcessor.startNewThread(new AsynchThread(this, false));
                }
                catch (InterruptedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.resumeConsumer", (String)"1:4978:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block17;
                    SibTr.exit((TraceComponent)tc, (String)"resumeConsumer", (Object)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resumeConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean suspendConsumer(int suspendFlag) {
        boolean didSuspendConsumer;
        JSKeyGroup cachedKeyGroup;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"suspendConsumer", (Object)suspendFlag);
        }
        if ((cachedKeyGroup = this._keyGroup) != null) {
            cachedKeyGroup.lock();
        }
        try {
            this.lock();
            try {
                if (!this.isConsumerSuspended(suspendFlag)) {
                    this._consumerSuspended = true;
                    this._suspendFlags |= suspendFlag;
                    this.unsetReady();
                    didSuspendConsumer = true;
                } else {
                    didSuspendConsumer = false;
                }
            }
            finally {
                this.unlock();
            }
        }
        finally {
            if (cachedKeyGroup != null) {
                cachedKeyGroup.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"suspendConsumer", (Object)didSuspendConsumer);
        }
        return didSuspendConsumer;
    }

    @Override
    public void closeSession(Throwable e) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeSession", (Object)e);
        }
        if (e == null) {
            if (this._consumerKey.isClosedDueToDelete()) {
                e = new SISessionDroppedException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP00221", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            } else if (this._consumerKey.isClosedDueToReceiveExclusive()) {
                e = new SISessionDroppedException(nls.getFormattedMessage("DESTINATION_EXCLUSIVE_ERROR_CWSIP00222", new Object[]{this._consumerDispatcher.getDestination().getName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
        }
        this._consumerSession.close();
        if (e != null) {
            this.notifyException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeSession", (Object)e);
        }
    }

    @Override
    public boolean ignoreInitialIndoubts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ignoreInitialIndoubts");
        }
        boolean ignoreInitialIndoubts = this._consumerSession.ignoreInitialIndoubts();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ignoreInitialIndoubts", (Object)ignoreInitialIndoubts);
        }
        return ignoreInitialIndoubts;
    }

    @Override
    public MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStoppableAsynchConsumer(StoppableAsynchConsumerCallback callback, int maxActiveMessages, long messageLockExpiry, int maxBatchSize, Reliability unrecoverableReliability, boolean inLine, OrderingContextImpl orderingGroup, ExternalConsumerLock optionalCallbackBusyLock, int maxSequentialFailures, long hiddenMessageDelay) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerStoppableAsynchConsumer", (Object)new Object[]{this, callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, orderingGroup, optionalCallbackBusyLock, maxSequentialFailures, hiddenMessageDelay});
        }
        try {
            this.lock();
            this._maxSequentialFailuresThreshold = maxSequentialFailures;
            if ((this._destinationAttachedTo.isOrdered() || this._destinationAttachedTo.getExceptionDestination() == null || this._destinationAttachedTo.getExceptionDestination().equals("")) && this._maxSequentialFailuresThreshold > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Setting maxSequentialMessageThreshold to 0");
                }
                this._maxSequentialFailuresThreshold = 1;
            }
            if (this._maxSequentialFailuresThreshold <= 0) {
                this._consumerStoppable = false;
                this._hiddenMessageDelay = 0L;
            } else {
                this._consumerStoppable = true;
                this._hiddenMessageDelay = hiddenMessageDelay;
            }
        }
        finally {
            this.unlock();
        }
        this.registerAsynchConsumer((AsynchConsumerCallback)callback, maxActiveMessages, messageLockExpiry, maxBatchSize, unrecoverableReliability, inLine, orderingGroup, optionalCallbackBusyLock);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerStoppableAsynchConsumer");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIErrorException, SIRollbackException, SIConnectionLostException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{event, msg, tran});
        }
        if (event == 6) {
            this.eventUnlocked(msg);
        } else if (event == 5) {
            this.eventPostRollbackRemove(msg);
        } else if (event == 3) {
            this.eventPostCommitRemove(msg);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:5270:1.22.5.1"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.messageEventOccurred", (String)"1:5278:1.22.5.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint", "1:5284:1.22.5.1"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
            }
            throw e;
        }
        this.deregisterForEvents(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(6, this);
        msg.registerMessageEventListener(5, this);
        msg.registerMessageEventListener(3, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public void deregisterForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterForEvents", (Object)msg);
        }
        msg.deregisterMessageEventListener(6, this);
        msg.deregisterMessageEventListener(5, this);
        msg.deregisterMessageEventListener(3, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterForEvents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventPostCommitRemove(SIMPMessage message) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)message);
        }
        if (this._consumerStoppable) {
            JSKeyGroup cachedKeyGroup = this._keyGroup;
            if (cachedKeyGroup != null) {
                cachedKeyGroup.lock();
            }
            try {
                this.lock();
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Resetting sequential count to zero (from " + this._sequentialMessageCounter + ")"));
                    }
                    this._sequentialMessageCounter = 0;
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                if (cachedKeyGroup != null) {
                    cachedKeyGroup.unlock();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    private void unlockAllHiddenMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAllHiddenMessages");
        }
        List<SIMPMessage> privateMsgList = null;
        this.lock();
        try {
            if (!this._hiddenMessages.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("number of hidden messages to unlock: " + this._hiddenMessages.size() + "(" + this._sequentialMessageCounter + ")"));
                }
                privateMsgList = this._hiddenMessages;
                this._hiddenMessages = new ArrayList<SIMPMessage>();
            }
        }
        finally {
            this.unlock();
        }
        if (privateMsgList != null) {
            for (int i = 0; i < privateMsgList.size(); ++i) {
                SIMPMessage hiddenMessage = privateMsgList.get(i);
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unlocking hidden message: " + hiddenMessage.getMessage().getSystemMessageId()));
                    }
                    hiddenMessage.markHiddenMessage(false);
                    hiddenMessage.unlockMsg(this._consumerKey.getGetCursor(hiddenMessage).getLockID(), null, true);
                    continue;
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.unlockAllHiddenMessages", (String)"1:5437:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.unlockAllHiddenMessage", "1:5444:1.22.5.1", e});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAllHiddenMessages");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventPostRollbackRemove(SIMPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)message);
        }
        boolean startStopThread = false;
        if (this._consumerStoppable) {
            JSKeyGroup cachedKeyGroup;
            int maxFailedDeliveries = this._destinationAttachedTo.getMaxFailedDeliveries();
            int msgDeliveryCount = message.guessRedeliveredCount() + 1;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Message delivery:" + msgDeliveryCount + " Destination max:" + maxFailedDeliveries + " Sequential max:" + this._maxSequentialFailuresThreshold + " Delay:" + this._hiddenMessageDelay));
            }
            if ((cachedKeyGroup = this._keyGroup) != null) {
                cachedKeyGroup.lock();
            }
            try {
                this.lock();
                try {
                    if (!this._closed) {
                        if (maxFailedDeliveries == 1 || msgDeliveryCount == maxFailedDeliveries - 1) {
                            ++this._sequentialMessageCounter;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Incrementing sequential count to: " + this._sequentialMessageCounter));
                            }
                        }
                        if (this._sequentialMessageCounter == this._maxSequentialFailuresThreshold && !this._consumerStopThreadRunning) {
                            startStopThread = true;
                            this._consumerStopThreadRunning = true;
                        } else if (msgDeliveryCount < maxFailedDeliveries && this._hiddenMessageDelay > 0L) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Hiding message: " + message.getMessage().getSystemMessageId()));
                            }
                            long hiddenExpiryTime = System.currentTimeMillis() + this._hiddenMessageDelay;
                            message.setHiddenExpiryTime(hiddenExpiryTime);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Set hidden expiry time to: " + hiddenExpiryTime + " : " + new Date(hiddenExpiryTime)));
                            }
                            if (!this._hiddenMsgAlarmRegistered) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Registering Hidden Message Expiry alarm for: " + message));
                                }
                                this._alarmManager.create(this._hiddenMessageDelay, this);
                                this._hiddenMsgAlarmRegistered = true;
                            }
                            this._hiddenMessages.add(message);
                            message.markHiddenMessage(true);
                        }
                        if (this._hiddenMessages.size() == this._maxSequentialFailuresThreshold || startStopThread) {
                            this._consumerSuspended = true;
                            this._suspendFlags |= 0x10;
                            this.unsetReady();
                        }
                    }
                }
                finally {
                    this.unlock();
                }
            }
            finally {
                if (cachedKeyGroup != null) {
                    cachedKeyGroup.unlock();
                }
            }
            if (startStopThread) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"SequentialMessageThreshold hit, starting new thread to stop consumer");
                }
                ConsumerStopThread runnable = new ConsumerStopThread(this._asynchConsumer);
                try {
                    this._messageProcessor.startNewThread(runnable);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    private void eventUnlocked(SIMPMessage msg) {
    }

    @Override
    public ConsumableKey getConsumerKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerKey");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerKey", (Object)this._consumerKey);
        }
        return this._consumerKey;
    }

    @Override
    public String toString() {
        String returnStr = "";
        if (this._consumerKey != null) {
            returnStr = returnStr + ", " + this._consumerKey.toString();
        }
        return returnStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this});
        }
        long currentTime = System.currentTimeMillis();
        long nextExpiry = 0L;
        ArrayList<SIMPMessage> expiredHiddenMessages = null;
        boolean resumeConsumerAfterUnlock = false;
        this.lock();
        try {
            boolean continueExpiryProcessing = true;
            while (continueExpiryProcessing) {
                continueExpiryProcessing = false;
                if (this._hiddenMessages.isEmpty()) continue;
                SIMPMessage firstHiddenMessage = this._hiddenMessages.get(0);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Checking hidden message " + firstHiddenMessage.getMessage().getSystemMessageId() + " from list"));
                }
                if (firstHiddenMessage.getHiddenExpiryTime() <= currentTime + 10L) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Expiring hidden state on: " + firstHiddenMessage));
                    }
                    if (expiredHiddenMessages == null) {
                        expiredHiddenMessages = new ArrayList<SIMPMessage>(1);
                    }
                    expiredHiddenMessages.add(firstHiddenMessage);
                    this._hiddenMessages.remove(firstHiddenMessage);
                    continueExpiryProcessing = true;
                    continue;
                }
                nextExpiry = firstHiddenMessage.getHiddenExpiryTime() - currentTime;
            }
            if ((this._suspendFlags & 0x10) > 0 && expiredHiddenMessages != null) {
                resumeConsumerAfterUnlock = true;
            }
            if (nextExpiry > 0L) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Registering alarm for: " + nextExpiry));
                }
                this._alarmManager.create(nextExpiry, this);
            } else {
                this._hiddenMsgAlarmRegistered = false;
            }
        }
        finally {
            this.unlock();
        }
        if (expiredHiddenMessages != null) {
            for (int i = 0; i < expiredHiddenMessages.size(); ++i) {
                try {
                    SIMPMessage hiddenMessage = (SIMPMessage)expiredHiddenMessages.get(i);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unlocking hidden message: " + hiddenMessage.getMessage().getSystemMessageId()));
                    }
                    hiddenMessage.markHiddenMessage(false);
                    hiddenMessage.unlockMsg(this._consumerKey.getGetCursor(hiddenMessage).getLockID(), null, true);
                    continue;
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.alarm", (String)"1:5951:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.alarm", "1:5958:1.22.5.1", e});
                }
            }
        }
        if (resumeConsumerAfterUnlock) {
            this.resumeConsumer(16);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)this);
        }
    }

    @Override
    public void implicitClose(SIBUuid12 deletedUuid, SIException exception, SIBUuid8 qpoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"implicitClose", (Object)new Object[]{deletedUuid, exception});
        }
        boolean closed = false;
        if (deletedUuid == null || deletedUuid.equals((Object)this._destinationAttachedTo.getUuid())) {
            closed = deletedUuid != null ? this._consumerKey.close(1, qpoint) : (exception != null ? this._consumerKey.close(3, qpoint) : this._consumerKey.close(2, qpoint));
        }
        if (closed) {
            try {
                this.closeSession(exception);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.implicitClose", (String)"1:6007:1.22.5.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"implicitClose");
        }
    }

    @Override
    public boolean isConsumerSuspended(int suspendFlag) {
        boolean suspended;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isConsumerSuspended");
        }
        try {
            this.lock();
            suspended = suspendFlag == 0 ? this._consumerSuspended : (this._suspendFlags == 0 ? false : (this._suspendFlags & suspendFlag) == suspendFlag);
        }
        finally {
            this.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isConsumerSuspended", (Object)suspended);
        }
        return suspended;
    }

    @Override
    public boolean isGatheringConsumer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGatheringConsumer");
            SibTr.exit((TraceComponent)tc, (String)"isGatheringConsumer", (Object)this._gatherMessages);
        }
        return this._gatherMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(boolean incrementUnlockCount) throws SISessionUnavailableException, SIResourceException, SIMPMessageNotLockedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{this, incrementUnlockCount});
        }
        Object object = this._asynchConsumerBusyLock;
        synchronized (object) {
            this.lock();
            try {
                this.checkNotClosed();
                try {
                    this._allLockedMessages.unlockAll(false, incrementUnlockCount);
                }
                catch (SIMPMessageNotLockedException sIMPMessageNotLockedException) {
                    // empty catch block
                }
            }
            finally {
                this.unlock();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll");
        }
    }

    private class ActiveMsgBlockAlarm
    implements AlarmListener {
        private boolean _popped = false;
        private long _startTime = 0L;
        private Alarm _alarm = null;

        private ActiveMsgBlockAlarm() {
        }

        public void startAlarm() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"startAlarm", (Object)JSLocalConsumerPoint.this._activeMsgBlockInterval);
            }
            if (this._alarm == null) {
                this._popped = false;
                this._alarm = JSLocalConsumerPoint.this._messageProcessor.getAlarmManager().create(JSLocalConsumerPoint.this._activeMsgBlockInterval * 1000, this);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startAlarm", (Object)this._alarm);
            }
        }

        public void cancelAlarm() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"cancelAlarm", (Object)this._alarm);
            }
            this._startTime = 0L;
            if (this._popped) {
                String me;
                this._popped = false;
                long consumerId = JSLocalConsumerPoint.this._consumerSession.getIdInternal();
                String dest = null;
                if (JSLocalConsumerPoint.this._destinationAttachedTo.isPubSub() && JSLocalConsumerPoint.this._consumerDispatcher.getConsumerDispatcherState() != null) {
                    dest = JSLocalConsumerPoint.this._consumerDispatcher.getConsumerDispatcherState().getSubscriberID();
                }
                if (dest == null) {
                    dest = JSLocalConsumerPoint.this._destinationAttachedTo.getName();
                }
                if (JSLocalConsumerPoint.this._consumerDispatcher instanceof RemoteConsumerDispatcher) {
                    me = SIMPUtils.getMENameFromUuid(((RemoteConsumerDispatcher)JSLocalConsumerPoint.this._consumerDispatcher).getLocalisationUuid().toString());
                    if (me == null) {
                        me = "UNKNOWN";
                    }
                } else {
                    me = JSLocalConsumerPoint.this._messageProcessor.getMessagingEngineName();
                }
                SibTr.info((TraceComponent)tc, (String)"MSG_BLOCK_CLEARED_CWSIP0183", (Object)new Object[]{consumerId, dest, me});
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cancelAlarm");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object arg0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{"ActiveMsgBlockAlarm", this._alarm, this._startTime});
            }
            JSLocalConsumerPoint.this.lock();
            try {
                if (this._alarm != null) {
                    String me;
                    this._popped = true;
                    if (this._startTime == 0L) {
                        this._startTime = System.currentTimeMillis() - (long)(JSLocalConsumerPoint.this._activeMsgBlockInterval * 1000);
                    }
                    long consumerId = JSLocalConsumerPoint.this._consumerSession.getIdInternal();
                    String dest = null;
                    if (JSLocalConsumerPoint.this._destinationAttachedTo.isPubSub() && JSLocalConsumerPoint.this._consumerDispatcher.getConsumerDispatcherState() != null) {
                        dest = JSLocalConsumerPoint.this._consumerDispatcher.getConsumerDispatcherState().getSubscriberID();
                    }
                    if (dest == null) {
                        dest = JSLocalConsumerPoint.this._destinationAttachedTo.getName();
                    }
                    if (JSLocalConsumerPoint.this._consumerDispatcher instanceof RemoteConsumerDispatcher) {
                        me = SIMPUtils.getMENameFromUuid(((RemoteConsumerDispatcher)JSLocalConsumerPoint.this._consumerDispatcher).getLocalisationUuid().toString());
                        if (me == null) {
                            me = "UNKNOWN";
                        }
                    } else {
                        me = JSLocalConsumerPoint.this._messageProcessor.getMessagingEngineName();
                    }
                    long time = (System.currentTimeMillis() - this._startTime) / 1000L;
                    SibTr.warning((TraceComponent)tc, (String)"MSG_BLOCK_WARNING_CWSIP0182", (Object)new Object[]{consumerId, dest, me, time});
                    this._alarm = JSLocalConsumerPoint.this._messageProcessor.getAlarmManager().create(JSLocalConsumerPoint.this._messageProcessor.getCustomProperties().getMsgBlockWarningRepeat() * 1000, this);
                }
            }
            finally {
                JSLocalConsumerPoint.this.unlock();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)this._alarm);
            }
        }
    }

    private class ConsumerStopThread
    implements Runnable {
        private final AsynchConsumer asynchConsumer;

        public ConsumerStopThread(AsynchConsumer asynchConsumer) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ConsumerStopThread", (Object)asynchConsumer);
            }
            this.asynchConsumer = asynchConsumer;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumerStopThread");
            }
        }

        @Override
        public void run() {
            boolean closed;
            boolean restarted;
            block6: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)"ConsumerStopThread");
                }
                JSLocalConsumerPoint.this.lock();
                restarted = JSLocalConsumerPoint.this._startSinceSequentialStop;
                closed = JSLocalConsumerPoint.this._closed || JSLocalConsumerPoint.this._closing;
                JSLocalConsumerPoint.this.unlock();
                if (!closed) {
                    try {
                        JSLocalConsumerPoint.this._consumerSession.stop();
                    }
                    catch (SIException e) {
                        if (e instanceof SISessionUnavailableException) break block6;
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.ConsumerStopThread.run", (String)"1:5698:1.22.5.1", (Object)this);
                    }
                }
            }
            JSLocalConsumerPoint.this.resumeConsumer(16);
            JSLocalConsumerPoint.this.lock();
            JSLocalConsumerPoint.this._sequentialMessageCounter = 0;
            JSLocalConsumerPoint.this._startSinceSequentialStop = false;
            JSLocalConsumerPoint.this._consumerStopThreadRunning = false;
            closed = JSLocalConsumerPoint.this._closed || JSLocalConsumerPoint.this._closing;
            JSLocalConsumerPoint.this.unlock();
            JSLocalConsumerPoint.this.unlockAllHiddenMessages();
            if (restarted && !closed) {
                this.asynchConsumer.consumerSessionStopped();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run", (Object)"ConsumerStopThread");
            }
        }
    }

    private class AsynchThread
    implements Runnable {
        private final boolean _isolatedRun;
        private final JSLocalConsumerPoint _localConsumerPoint;

        AsynchThread(JSLocalConsumerPoint lcp, boolean isolatedRun) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AsynchThread", (Object)new Object[]{lcp, isolatedRun});
            }
            this._localConsumerPoint = lcp;
            this._isolatedRun = isolatedRun;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AsynchThread", (Object)this);
            }
        }

        @Override
        public void run() {
            block8: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
                }
                try {
                    this._localConsumerPoint.runAsynchConsumer(this._isolatedRun);
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.JSLocalConsumerPoint.AsynchThread.run", (String)"1:3644:1.22.5.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Throwable)e);
                    JSLocalConsumerPoint.this.notifyException(e);
                    try {
                        JSLocalConsumerPoint.this.closeSession(e);
                    }
                    catch (Exception ee) {
                        SibTr.exception((TraceComponent)tc, (Exception)ee);
                    }
                    if (e instanceof ThreadDeath) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"run", (Object)e);
                        }
                        throw (ThreadDeath)e;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block8;
                    SibTr.exit((TraceComponent)tc, (String)"run", (Object)e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

