/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.validation;

import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.NamedNode;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import io.smallrye.graphql.cdi.validation.BeanValidationError;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;

public class BeanValidationException
extends AbstractDataFetcherException {
    private final Set<ConstraintViolation<Object>> violations;
    private final Method method;

    public BeanValidationException(Set<ConstraintViolation<Object>> violations, Method method) {
        this.violations = violations;
        this.method = method;
    }

    @Override
    public DataFetcherResult.Builder<Object> appendDataFetcherResult(DataFetcherResult.Builder<Object> builder, DataFetchingEnvironment dfe) {
        RequestNodeBuilder requestNodeBuilder = new RequestNodeBuilder(this.method, dfe);
        this.violations.stream().map(violation -> new BeanValidationError((ConstraintViolation<Object>)violation, requestNodeBuilder.build((ConstraintViolation<Object>)violation))).forEach(arg_0 -> builder.error(arg_0));
        return builder;
    }

    class RequestNodeBuilder {
        private final Method method;
        private final DataFetchingEnvironment dfe;

        RequestNodeBuilder(Method method, DataFetchingEnvironment dfe) {
            this.method = method;
            this.dfe = dfe;
        }

        List<NamedNode<?>> build(ConstraintViolation<Object> violation) {
            Iterator violationNodes = violation.getPropertyPath().iterator();
            return Arrays.asList(this.methodNode((Path.Node)violationNodes.next()), this.requestedArgument((Path.Node)violationNodes.next()));
        }

        private Field methodNode(Path.Node methodNode) {
            assert (this.dfe.getFieldDefinition().getName().equals(methodNode.getName())) : "expected first violation path item " + methodNode.getName() + " to be the method name field definition " + this.dfe.getFieldDefinition().getName();
            return this.dfe.getField();
        }

        private Argument requestedArgument(Path.Node node) {
            String graphQLArgumentName = ((GraphQLArgument)this.dfe.getFieldDefinition().getArguments().get(this.parameterIndex(node.getName()))).getName();
            Field requestedField = this.dfe.getMergedField().getSingleField();
            return requestedField.getArguments().stream().filter(argument -> argument.getName().equals(graphQLArgumentName)).findFirst().orElseThrow(() -> new AssertionError((Object)("expected field " + graphQLArgumentName + " in " + requestedField.getArguments())));
        }

        private int parameterIndex(String name) {
            Parameter[] parameters = this.method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!name.equals(parameters[i].getName())) continue;
                return i;
            }
            throw new AssertionError((Object)("expected parameter " + name + " in " + this.method));
        }
    }
}

