/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.event;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class EventEmitter {
    private final ServiceLoader<EventingService> eventingServices = ServiceLoader.load(EventingService.class);
    private final List<EventingService> enabledServices = new ArrayList<EventingService>();

    public EventEmitter(Config config) {
        Iterator<EventingService> it = this.eventingServices.iterator();
        while (it.hasNext()) {
            try {
                EventingService eventingService = it.next();
                String configKey = eventingService.getConfigKey();
                boolean enabled = config.getConfigValue(configKey, Boolean.TYPE, false);
                if (!enabled) continue;
                this.enabledServices.add(eventingService);
            }
            catch (Throwable throwable) {}
        }
    }

    public void fireBeforeExecute() {
        Context context = SmallRyeContext.getContext();
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeExecute(context);
        }
    }

    public void fireOnExecuteError(String executionId, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorExecute(executionId, t);
        }
    }

    public void fireAfterExecute() {
        Context context = SmallRyeContext.getContext();
        for (EventingService extensionService : this.enabledServices) {
            extensionService.afterExecute(context);
        }
    }

    public void fireBeforeDataFetch() {
        Context context = SmallRyeContext.getContext();
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeDataFetch(context);
        }
    }

    public void fireBeforeMethodInvoke(InvokeInfo invokeInfo) throws Exception {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.beforeInvoke(invokeInfo);
        }
    }

    public void fireOnDataFetchError(String executionId, Throwable t) {
        for (EventingService extensionService : this.enabledServices) {
            extensionService.errorDataFetch(executionId, t);
        }
    }

    public void fireAfterDataFetch() {
        Context context = SmallRyeContext.getContext();
        for (EventingService extensionService : this.enabledServices) {
            extensionService.afterDataFetch(context);
        }
    }

    public GraphQLSchema.Builder fireBeforeSchemaBuild(GraphQLSchema.Builder builder) {
        for (EventingService extensionService : this.enabledServices) {
            builder = extensionService.beforeSchemaBuild(builder);
        }
        return builder;
    }

    public Operation fireCreateOperation(Operation operation) {
        for (EventingService extensionService : this.enabledServices) {
            operation = extensionService.createOperation(operation);
        }
        return operation;
    }
}

