/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.tx.util.alarm.Alarm;
import com.ibm.tx.util.alarm.AlarmListener;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.SharedServerLeaseLog;
import java.util.ArrayList;

public class LeaseTimeoutManager {
    private static final TraceComponent tc = Tr.register(LeaseTimeoutManager.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static String _recoveryIdentity;
    private static String _recoveryGroup;
    private static LeaseRenewer _renewer;
    private static LeaseChecker _checker;

    public static void setTimeouts(SharedServerLeaseLog leaseLog, String recoveryIdentity, String recoveryGroup, RecoveryAgent recoveryAgent, RecoveryDirector recoveryDirector, int leaseLength, int leaseCheckInterval) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTimeouts", (Object[])new Object[]{leaseLog, recoveryIdentity, recoveryGroup, recoveryAgent, recoveryDirector, leaseLength, leaseCheckInterval});
        }
        _recoveryIdentity = recoveryIdentity;
        _recoveryGroup = recoveryGroup;
        _renewer = new LeaseRenewer(leaseLength, leaseLog, recoveryAgent);
        _checker = new LeaseChecker(leaseCheckInterval, recoveryAgent, recoveryDirector);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTimeouts");
        }
    }

    public static void stopTimeout() {
        if (_renewer != null) {
            _renewer.cancel();
        }
        if (_checker != null) {
            _checker.cancel();
        }
    }

    private static class LeaseChecker
    implements AlarmListener {
        private final RecoveryAgent _recoveryAgent;
        private final RecoveryDirector _recoveryDirector;
        private Alarm _alarm;

        private LeaseChecker(int delay, RecoveryAgent recoveryAgent, RecoveryDirector recoveryDirector) {
            this._recoveryAgent = recoveryAgent;
            this._recoveryDirector = recoveryDirector;
            this.schedule(delay);
        }

        public void alarm(Object delay) {
            block5: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LeaseCheck", (Object[])new Object[]{_recoveryGroup});
                }
                if (this._recoveryAgent != null && this._recoveryAgent.checkingLeases()) {
                    ArrayList peersToRecover = this._recoveryAgent.processLeasesForPeers(_recoveryIdentity, _recoveryGroup);
                    if (this._recoveryDirector != null && this._recoveryDirector instanceof RecoveryDirectorImpl) {
                        try {
                            ((RecoveryDirectorImpl)this._recoveryDirector).peerRecoverServers(this._recoveryAgent, _recoveryIdentity, peersToRecover);
                        }
                        catch (RecoveryFailedException e) {
                            if (!tc.isDebugEnabled()) break block5;
                            Tr.debug((TraceComponent)tc, (String)("Swallow exception " + (Object)((Object)e)), (Object[])new Object[0]);
                        }
                    }
                }
            }
            this.schedule((Integer)delay);
        }

        void schedule(int delay) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Scheduling lease checker in " + delay + " seconds"), (Object[])new Object[0]);
            }
            this._alarm = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager().scheduleAlarm((long)delay * 1000L, (AlarmListener)this, (Object)delay);
        }

        void cancel() {
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
        }
    }

    private static class LeaseRenewer
    implements AlarmListener {
        private final RecoveryAgent _recoveryAgent;
        private final SharedServerLeaseLog _leaseLog;
        private Alarm _alarm;

        private LeaseRenewer(int delay, SharedServerLeaseLog leaseLog, RecoveryAgent recoveryAgent) {
            this._recoveryAgent = recoveryAgent;
            this._leaseLog = leaseLog;
            this.schedule(delay);
        }

        public void alarm(Object delay) {
            boolean leaseRenewed;
            block6: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"LeaseRenewal", (Object[])new Object[]{_recoveryIdentity, _recoveryGroup});
                }
                leaseRenewed = false;
                try {
                    if (this._leaseLog.lockLocalLease(_recoveryIdentity)) {
                        this._leaseLog.updateServerLease(_recoveryIdentity, _recoveryGroup, false);
                        this._leaseLog.releaseLocalLease(_recoveryIdentity);
                        leaseRenewed = true;
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Could not lock lease for " + _recoveryIdentity), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)("Swallow exception " + e), (Object[])new Object[0]);
                }
            }
            this._recoveryAgent.setCheckingLeases(leaseRenewed);
            this.schedule((Integer)delay);
        }

        void schedule(int delay) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Scheduling lease renewal in " + delay + " seconds"), (Object[])new Object[0]);
            }
            this._alarm = ConfigurationProviderManager.getConfigurationProvider().getAlarmManager().scheduleAlarm((long)delay * 1000L, (AlarmListener)this, (Object)delay);
        }

        void cancel() {
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
        }
    }
}

