/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.kernel.service.util.CpuInfo;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class BoundedBuffer {
    private int waitingThreads = 0;
    private static final int SPINS_TAKE_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_take", CpuInfo.getAvailableProcessors() - 1);
    private static final int SPINS_PUT_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.spins_put", SPINS_TAKE_ / 4);
    private static final boolean YIELD_TAKE_;
    private static final boolean YIELD_PUT_;
    private static final long WAIT_SHORT_SLICE_;
    private static final long WAIT_LONG_SLICE_;
    private static final int SPLIT_THRESH_;
    private static final int SPLIT_FACTOR_;
    private static final int MAX_COUNTER = 0x3FFFFFFF;
    private final PutQueueLock putQueue_ = new PutQueueLock();
    private int putQueueLen_ = 0;
    private final GetQueueLock[] getQueueLocks_;
    private Object[] buffer;
    private int takeIndex = 0;
    private int putIndex = 0;
    private final LiteAtomicInteger numberOfUsedSlots = new LiteAtomicInteger(0);
    private final BoundedBufferLock lock = new BoundedBufferLock();
    private final AtomicInteger getQueueCounter_ = new AtomicInteger(0);

    private int getQueueIndex(Object[] queue, AtomicInteger counter, boolean increment) {
        if (queue.length == 1) {
            return 0;
        }
        if (increment) {
            int i = counter.incrementAndGet();
            if (i > 0x3FFFFFFF && counter.compareAndSet(i, 0)) {
                System.out.println("BoundedBuffer: reset counter to 0");
            }
            return i % queue.length;
        }
        return counter.get() % queue.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGet_() {
        int lastWaitIndex;
        int lockIndex = lastWaitIndex = this.getQueueIndex(this.getQueueLocks_, this.getQueueCounter_, false);
        for (int i = 0; i < this.getQueueLocks_.length; ++i) {
            int checkIndex;
            if (this.getQueueLocks_[lockIndex].threadsWaiting > 0) {
                GetQueueLock getQueueLock = this.getQueueLocks_[lockIndex];
                synchronized (getQueueLock) {
                    if (this.getQueueLocks_[lockIndex].threadsWaiting > 0) {
                        this.getQueueLocks_[lockIndex].notify();
                        return;
                    }
                    --i;
                }
            }
            if ((checkIndex = this.getQueueIndex(this.getQueueLocks_, this.getQueueCounter_, false)) != lastWaitIndex) {
                lastWaitIndex = lockIndex = checkIndex;
                i = 0;
                continue;
            }
            ++lockIndex;
            lockIndex %= this.getQueueLocks_.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitGet_(long timeout) throws InterruptedException {
        int lockIndex = this.getQueueIndex(this.getQueueLocks_, this.getQueueCounter_, true);
        GetQueueLock getQueueLock = this.getQueueLocks_[lockIndex];
        synchronized (getQueueLock) {
            try {
                ++this.getQueueLocks_[lockIndex].threadsWaiting;
                if (this.numberOfUsedSlots.get() <= 0) {
                    if (timeout < 0L) {
                        if (WAIT_SHORT_SLICE_ != WAIT_LONG_SLICE_ && this.getQueueLocks_[lockIndex].shortWaiter == null) {
                            timeout = WAIT_SHORT_SLICE_;
                            this.getQueueLocks_[lockIndex].shortWaiter = Thread.currentThread();
                        } else {
                            timeout = WAIT_LONG_SLICE_;
                        }
                    }
                    this.getQueueLocks_[lockIndex].wait(timeout);
                }
            }
            catch (InterruptedException ex) {
                this.getQueueLocks_[lockIndex].notify();
                throw ex;
            }
            finally {
                --this.getQueueLocks_[lockIndex].threadsWaiting;
                if (WAIT_SHORT_SLICE_ != WAIT_LONG_SLICE_ && this.getQueueLocks_[lockIndex].shortWaiter == Thread.currentThread()) {
                    this.getQueueLocks_[lockIndex].shortWaiter = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPut_() {
        if (this.putQueueLen_ > 0) {
            PutQueueLock putQueueLock = this.putQueue_;
            synchronized (putQueueLock) {
                this.putQueue_.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitPut_(long timeout) throws InterruptedException {
        PutQueueLock putQueueLock = this.putQueue_;
        synchronized (putQueueLock) {
            try {
                ++this.putQueueLen_;
                if (this.numberOfUsedSlots.get() >= this.buffer.length) {
                    this.putQueue_.wait(timeout);
                }
            }
            catch (InterruptedException ex) {
                this.putQueue_.notify();
                throw ex;
            }
            finally {
                --this.putQueueLen_;
            }
        }
    }

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[capacity];
        int subPoolLength = 1;
        if (capacity > SPLIT_THRESH_) {
            subPoolLength = (int)Math.ceil((double)capacity / (double)SPLIT_FACTOR_);
        }
        this.getQueueLocks_ = new GetQueueLock[subPoolLength];
        for (int i = 0; i < this.getQueueLocks_.length; ++i) {
            this.getQueueLocks_[i] = new GetQueueLock();
        }
    }

    public int size() {
        return this.numberOfUsedSlots.get();
    }

    public int capacity() {
        return this.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.numberOfUsedSlots.get() > 0) {
                return this.buffer[this.takeIndex];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                return;
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                    continue;
                }
                this.waitPut_(WAIT_SHORT_SLICE_);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object x, long timeoutInMillis) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        Object ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = x;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                return ret;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object x, long timeoutInMillis, int maximumCapacity) throws InterruptedException {
        if (x == null || maximumCapacity > this.buffer.length) {
            throw new IllegalArgumentException();
        }
        long start = timeoutInMillis <= 0L ? 0L : -1L;
        long waitTime = timeoutInMillis;
        Object ret = null;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < maximumCapacity) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = x;
                }
            }
            if (ret != null) {
                this.notifyGet_();
                return ret;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(timeoutInMillis);
                }
                waitTime = timeoutInMillis - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object x, long timeout) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        long start = timeout <= 0L ? 0L : -1L;
        long waitTime = timeout;
        boolean ret = false;
        block3: while (true) {
            BoundedBufferLock boundedBufferLock = this.lock;
            synchronized (boundedBufferLock) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) {
                    this.insert(x);
                    this.numberOfUsedSlots.getAndIncrement();
                    ret = true;
                }
            }
            if (ret) {
                this.notifyGet_();
                return true;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_PUT_;
            while (true) {
                if (this.numberOfUsedSlots.get() < this.buffer.length) continue block3;
                if (waitTime <= 0L) {
                    return false;
                }
                if (spinctr > 0) {
                    if (YIELD_PUT_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitPut_(waitTime);
                }
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        Object old = null;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    old = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (old != null) {
                    --this.waitingThreads;
                }
            }
            if (old != null) {
                this.notifyPut_();
                return old;
            }
            int spinctr = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (spinctr > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --spinctr;
                    continue;
                }
                this.waitGet_(-1L);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long timeout) throws InterruptedException {
        Object old = null;
        long start = timeout <= 0L ? 0L : -1L;
        long waitTime = timeout;
        block3: while (true) {
            BoundedBuffer boundedBuffer = this;
            synchronized (boundedBuffer) {
                if (this.numberOfUsedSlots.get() > 0) {
                    old = this.extract();
                    this.numberOfUsedSlots.getAndDecrement();
                }
                if (old != null) {
                    --this.waitingThreads;
                }
            }
            if (old != null) {
                this.notifyPut_();
                return old;
            }
            if (start == -1L) {
                start = System.currentTimeMillis();
            }
            int spinctr = SPINS_TAKE_;
            while (true) {
                if (this.numberOfUsedSlots.get() > 0) continue block3;
                if (waitTime <= 0L) {
                    return null;
                }
                if (spinctr > 0) {
                    if (YIELD_TAKE_) {
                        Thread.yield();
                    }
                    --spinctr;
                } else {
                    this.waitGet_(waitTime);
                }
                waitTime = timeout - (System.currentTimeMillis() - start);
            }
            break;
        }
    }

    public synchronized void incrementWaitingThreads() {
        ++this.waitingThreads;
    }

    public synchronized void decrementWaitingThreads() {
        --this.waitingThreads;
    }

    public synchronized int excessWaitingThreads() {
        return this.waitingThreads - this.size();
    }

    private final void insert(Object x) {
        this.buffer[this.putIndex] = x;
        if (++this.putIndex >= this.buffer.length) {
            this.putIndex = 0;
        }
    }

    private final Object extract() {
        Object old = this.buffer[this.takeIndex];
        this.buffer[this.takeIndex] = null;
        if (++this.takeIndex >= this.buffer.length) {
            this.takeIndex = 0;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expand(int additionalCapacity) {
        if (additionalCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            Object[] newBuffer = new Object[this.buffer.length + additionalCapacity];
            if (this.putIndex > this.takeIndex) {
                int used = this.putIndex - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                this.putIndex = used;
            } else if (this.putIndex != this.takeIndex || this.buffer[this.takeIndex] != null) {
                int used = this.buffer.length - this.takeIndex;
                System.arraycopy(this.buffer, this.takeIndex, newBuffer, 0, used);
                System.arraycopy(this.buffer, 0, newBuffer, used, this.putIndex);
                this.putIndex += used;
            } else {
                this.putIndex = 0;
            }
            this.takeIndex = 0;
            this.buffer = newBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean cancel(Object x) {
        BoundedBufferLock boundedBufferLock = this.lock;
        synchronized (boundedBufferLock) {
            if (this.putIndex > this.takeIndex) {
                for (int i = this.takeIndex; i < this.putIndex; ++i) {
                    if (this.buffer[i] != x) continue;
                    System.arraycopy(this.buffer, i + 1, this.buffer, i, this.putIndex - i - 1);
                    --this.putIndex;
                    this.buffer[this.putIndex] = null;
                    this.numberOfUsedSlots.getAndDecrement();
                    return true;
                }
            } else if (this.putIndex != this.takeIndex || this.buffer[this.takeIndex] != null) {
                int i;
                for (i = this.takeIndex; i < this.buffer.length; ++i) {
                    if (this.buffer[i] != x) continue;
                    if (i != this.buffer.length - 1) {
                        System.arraycopy(this.buffer, i + 1, this.buffer, i, this.buffer.length - i - 1);
                    }
                    if (this.putIndex != 0) {
                        this.buffer[this.buffer.length - 1] = this.buffer[0];
                        System.arraycopy(this.buffer, 1, this.buffer, 0, this.putIndex - 1);
                        --this.putIndex;
                    } else {
                        this.putIndex = this.buffer.length - 1;
                    }
                    this.buffer[this.putIndex] = null;
                    this.numberOfUsedSlots.getAndDecrement();
                    return true;
                }
                for (i = 0; i < this.putIndex; ++i) {
                    if (this.buffer[i] != x) continue;
                    System.arraycopy(this.buffer, i + 1, this.buffer, i, this.putIndex - i - 1);
                    --this.putIndex;
                    this.buffer[this.putIndex] = null;
                    this.numberOfUsedSlots.getAndDecrement();
                    return true;
                }
            }
        }
        return false;
    }

    static {
        SPLIT_THRESH_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.split_thresh", 50);
        SPLIT_FACTOR_ = Integer.getInteger("com.ibm.ws.util.BoundedBuffer.split_factor", SPLIT_THRESH_);
        YIELD_TAKE_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_take");
        YIELD_PUT_ = Boolean.getBoolean("com.ibm.ws.util.BoundedBuffer.yield_put");
        WAIT_SHORT_SLICE_ = Long.getLong("com.ibm.ws.util.BoundedBuffer.wait", 1000L);
        WAIT_LONG_SLICE_ = Long.getLong("com.ibm.ws.util.BoundedBuffer.wait_long", 1000L);
    }

    private static class BoundedBufferLock {
        private BoundedBufferLock() {
        }
    }

    private class GetQueueLock {
        public int threadsWaiting = 0;
        public Thread shortWaiter = null;

        private GetQueueLock() {
        }
    }

    private static class PutQueueLock {
        private PutQueueLock() {
        }
    }

    private static class LiteAtomicInteger {
        private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        private final Lock readLock = this.rwl.readLock();
        private final Lock writeLock = this.rwl.writeLock();
        private final boolean useRwl = CpuInfo.getAvailableProcessors() > 4;
        private int val_;

        public LiteAtomicInteger(int v) {
            this.val_ = v;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int get() {
            if (this.useRwl) {
                this.readLock.lock();
                try {
                    int n = this.val_;
                    return n;
                }
                finally {
                    this.readLock.unlock();
                }
            }
            LiteAtomicInteger liteAtomicInteger = this;
            synchronized (liteAtomicInteger) {
                return this.val_;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int getAndIncrement() {
            if (this.useRwl) {
                this.writeLock.lock();
                try {
                    int n = this.val_++;
                    return n;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            LiteAtomicInteger liteAtomicInteger = this;
            synchronized (liteAtomicInteger) {
                return this.val_++;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final int getAndDecrement() {
            if (this.useRwl) {
                this.writeLock.lock();
                try {
                    int n = this.val_--;
                    return n;
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            LiteAtomicInteger liteAtomicInteger = this;
            synchronized (liteAtomicInteger) {
                return this.val_--;
            }
        }
    }
}

