/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

abstract class SibRaDestinationSession
implements DestinationSession {
    protected final SibRaConnection _parentConnection;
    private final DestinationSession _delegateSession;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaDestinationSession.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();

    public SibRaDestinationSession(SibRaConnection connection, DestinationSession delegate) {
        String methodName = "SibRaDestinationSession";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaDestinationSession", (Object)new Object[]{connection, delegate});
        }
        this._parentConnection = connection;
        this._delegateSession = delegate;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaDestinationSession");
        }
    }

    public void close() throws SIConnectionLostException, SIResourceException, SIErrorException, SIConnectionDroppedException {
        String methodName = "close";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"close");
        }
        this._delegateSession.close();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"close");
        }
    }

    public SICoreConnection getConnection() throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException {
        String methodName = "getConnection";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection");
        }
        this.checkValid();
        this._delegateSession.getConnection();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)this._parentConnection);
        }
        return this._parentConnection;
    }

    public SIDestinationAddress getDestinationAddress() {
        String methodName = "getDestinationAddress";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getDestinationAddress");
        }
        SIDestinationAddress address = this._delegateSession.getDestinationAddress();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getDestinationAddress", (Object)this._parentConnection);
        }
        return address;
    }

    public String toString() {
        StringBuffer buffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(buffer, "parentConnection", this._parentConnection);
        SibRaUtils.addFieldToString(buffer, "delegateSession", this._delegateSession);
        SibRaUtils.endToString(buffer);
        return buffer.toString();
    }

    protected void checkValid() throws SISessionUnavailableException {
        if (!this._parentConnection.isValid()) {
            SISessionUnavailableException exception = new SISessionUnavailableException(NLS.getString("INVALID_SESSION_CWSIV0200"));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
            }
            throw exception;
        }
    }
}

