/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.crypto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Set;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.EncryptedProperties;
import org.owasp.esapi.Logger;
import org.owasp.esapi.crypto.CipherText;
import org.owasp.esapi.crypto.PlainText;
import org.owasp.esapi.errors.EncryptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEncryptedProperties
implements EncryptedProperties {
    private final Properties properties = new Properties();
    private final Logger logger = ESAPI.getLogger("EncryptedProperties");

    @Override
    public synchronized String getProperty(String key) throws EncryptionException {
        String[] errorMsgs = new String[]{": failed decoding from base64", ": failed to deserialize properly", ": failed to decrypt properly"};
        int progressMark = 0;
        try {
            String encryptedValue = this.properties.getProperty(key);
            if (encryptedValue == null) {
                return null;
            }
            progressMark = 0;
            byte[] serializedCiphertext = ESAPI.encoder().decodeFromBase64(encryptedValue);
            ++progressMark;
            CipherText restoredCipherText = CipherText.fromPortableSerializedBytes(serializedCiphertext);
            ++progressMark;
            PlainText plaintext = ESAPI.encryptor().decrypt(restoredCipherText);
            return plaintext.toString();
        }
        catch (Exception e) {
            throw new EncryptionException("Property retrieval failure", "Couldn't retrieve encrypted property for property " + key + errorMsgs[progressMark], e);
        }
    }

    @Override
    public synchronized String setProperty(String key, String value) throws EncryptionException {
        String[] errorMsgs = new String[]{": failed to encrypt properly", ": failed to serialize correctly", ": failed to base64-encode properly", ": failed to set base64-encoded value as property. Illegal key name?"};
        int progressMark = 0;
        try {
            if (key == null) {
                throw new NullPointerException("Property name may not be null.");
            }
            if (value == null) {
                throw new NullPointerException("Property value may not be null.");
            }
            PlainText pt = new PlainText(value);
            CipherText ct = ESAPI.encryptor().encrypt(pt);
            ++progressMark;
            byte[] serializedCiphertext = ct.asPortableSerializedByteArray();
            ++progressMark;
            String b64str = ESAPI.encoder().encodeForBase64(serializedCiphertext, false);
            ++progressMark;
            String encryptedValue = (String)this.properties.setProperty(key, b64str);
            ++progressMark;
            return encryptedValue;
        }
        catch (Exception e) {
            throw new EncryptionException("Property setting failure", "Couldn't set encrypted property " + key + errorMsgs[progressMark], e);
        }
    }

    @Override
    public Set<?> keySet() {
        return this.properties.keySet();
    }

    @Override
    public void load(InputStream in) throws IOException {
        this.properties.load(in);
        this.logger.trace(Logger.SECURITY_SUCCESS, "Encrypted properties loaded successfully");
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        this.properties.store(out, comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String value;
        File f = new File(args[0]);
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY_SUCCESS, "Loading encrypted properties from " + f.getAbsolutePath());
        if (!f.exists()) {
            throw new IOException("Properties file not found: " + f.getAbsolutePath());
        }
        ESAPI.getLogger("EncryptedProperties.main").debug(Logger.SECURITY_SUCCESS, "Encrypted properties found in " + f.getAbsolutePath());
        DefaultEncryptedProperties ep = new DefaultEncryptedProperties();
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(f);
            out = new FileOutputStream(f);
            ep.load(in);
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String key = null;
            do {
                System.out.print("Enter key: ");
                key = br.readLine();
                System.out.print("Enter value: ");
                value = br.readLine();
                if (key == null || key.length() <= 0 || value == null || value.length() <= 0) continue;
                ep.setProperty(key, value);
            } while (key != null && key.length() > 0);
            ep.store(out, "Encrypted Properties File");
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {}
        for (String k : ep.keySet()) {
            value = ep.getProperty(k);
            System.out.println("   " + k + "=" + value);
        }
    }
}

