/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class GraphQLCodeRegistry {
    private final Map<FieldCoordinates, DataFetcherFactory> dataFetcherMap;
    private final Map<String, DataFetcherFactory> systemDataFetcherMap;
    private final Map<String, TypeResolver> typeResolverMap;
    private final GraphqlFieldVisibility fieldVisibility;

    private GraphQLCodeRegistry(Map<FieldCoordinates, DataFetcherFactory> dataFetcherMap, Map<String, DataFetcherFactory> systemDataFetcherMap, Map<String, TypeResolver> typeResolverMap, GraphqlFieldVisibility fieldVisibility) {
        this.dataFetcherMap = dataFetcherMap;
        this.systemDataFetcherMap = systemDataFetcherMap;
        this.typeResolverMap = typeResolverMap;
        this.fieldVisibility = fieldVisibility;
    }

    public GraphqlFieldVisibility getFieldVisibility() {
        return this.fieldVisibility;
    }

    public DataFetcher getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition) {
        return GraphQLCodeRegistry.getDataFetcherImpl(FieldCoordinates.coordinates(parentType, fieldDefinition), fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap);
    }

    public DataFetcher getDataFetcher(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition) {
        return GraphQLCodeRegistry.getDataFetcherImpl(coordinates, fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap);
    }

    private static DataFetcher getDataFetcherImpl(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition, Map<FieldCoordinates, DataFetcherFactory> dataFetcherMap, Map<String, DataFetcherFactory> systemDataFetcherMap) {
        Assert.assertNotNull(coordinates);
        Assert.assertNotNull(fieldDefinition);
        DataFetcherFactory dataFetcherFactory = systemDataFetcherMap.get(fieldDefinition.getName());
        if (dataFetcherFactory == null && (dataFetcherFactory = dataFetcherMap.get(coordinates)) == null) {
            dataFetcherFactory = DataFetcherFactories.useDataFetcher(new PropertyDataFetcher(fieldDefinition.getName()));
        }
        return dataFetcherFactory.get(DataFetcherFactoryEnvironment.newDataFetchingFactoryEnvironment().fieldDefinition(fieldDefinition).build());
    }

    private static boolean hasDataFetcherImpl(FieldCoordinates coords, Map<FieldCoordinates, DataFetcherFactory> dataFetcherMap, Map<String, DataFetcherFactory> systemDataFetcherMap) {
        Assert.assertNotNull(coords);
        DataFetcherFactory dataFetcherFactory = systemDataFetcherMap.get(coords.getFieldName());
        if (dataFetcherFactory == null) {
            dataFetcherFactory = dataFetcherMap.get(coords);
        }
        return dataFetcherFactory != null;
    }

    public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
        return GraphQLCodeRegistry.getTypeResolverForInterface(interfaceType, this.typeResolverMap);
    }

    public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
        return GraphQLCodeRegistry.getTypeResolverForUnion(unionType, this.typeResolverMap);
    }

    private static TypeResolver getTypeResolverForInterface(GraphQLInterfaceType parentType, Map<String, TypeResolver> typeResolverMap) {
        Assert.assertNotNull(parentType);
        TypeResolver typeResolver = typeResolverMap.get(parentType.getName());
        if (typeResolver == null) {
            typeResolver = parentType.getTypeResolver();
        }
        return Assert.assertNotNull(typeResolver, "There must be a type resolver for interface " + parentType.getName(), new Object[0]);
    }

    private static TypeResolver getTypeResolverForUnion(GraphQLUnionType parentType, Map<String, TypeResolver> typeResolverMap) {
        Assert.assertNotNull(parentType);
        TypeResolver typeResolver = typeResolverMap.get(parentType.getName());
        if (typeResolver == null) {
            typeResolver = parentType.getTypeResolver();
        }
        return Assert.assertNotNull(typeResolver, "There must be a type resolver for union " + parentType.getName(), new Object[0]);
    }

    public GraphQLCodeRegistry transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLCodeRegistry.newCodeRegistry(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static Builder newCodeRegistry() {
        return new Builder();
    }

    public static Builder newCodeRegistry(GraphQLCodeRegistry existingCodeRegistry) {
        return new Builder(existingCodeRegistry);
    }

    public static class Builder {
        private final Map<FieldCoordinates, DataFetcherFactory> dataFetcherMap = new LinkedHashMap<FieldCoordinates, DataFetcherFactory>();
        private final Map<String, DataFetcherFactory> systemDataFetcherMap = new LinkedHashMap<String, DataFetcherFactory>();
        private final Map<String, TypeResolver> typeResolverMap = new HashMap<String, TypeResolver>();
        private GraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;

        private Builder() {
        }

        private Builder(GraphQLCodeRegistry codeRegistry) {
            this.dataFetcherMap.putAll(codeRegistry.dataFetcherMap);
            this.typeResolverMap.putAll(codeRegistry.typeResolverMap);
            this.fieldVisibility = codeRegistry.fieldVisibility;
        }

        public DataFetcher getDataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition) {
            return GraphQLCodeRegistry.getDataFetcherImpl(FieldCoordinates.coordinates(parentType, fieldDefinition), fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap);
        }

        public DataFetcher getDataFetcher(FieldCoordinates coordinates, GraphQLFieldDefinition fieldDefinition) {
            return GraphQLCodeRegistry.getDataFetcherImpl(coordinates, fieldDefinition, this.dataFetcherMap, this.systemDataFetcherMap);
        }

        public boolean hasDataFetcher(FieldCoordinates coordinates) {
            return GraphQLCodeRegistry.hasDataFetcherImpl(coordinates, this.dataFetcherMap, this.systemDataFetcherMap);
        }

        public TypeResolver getTypeResolver(GraphQLInterfaceType interfaceType) {
            return GraphQLCodeRegistry.getTypeResolverForInterface(interfaceType, this.typeResolverMap);
        }

        public boolean hasTypeResolver(String typeName) {
            return this.typeResolverMap.containsKey(typeName);
        }

        public TypeResolver getTypeResolver(GraphQLUnionType unionType) {
            return GraphQLCodeRegistry.getTypeResolverForUnion(unionType, this.typeResolverMap);
        }

        public Builder dataFetcher(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            return this.dataFetcher(Assert.assertNotNull(coordinates), DataFetcherFactories.useDataFetcher(dataFetcher));
        }

        public Builder dataFetcher(GraphQLFieldsContainer parentType, GraphQLFieldDefinition fieldDefinition, DataFetcher<?> dataFetcher) {
            return this.dataFetcher(FieldCoordinates.coordinates(parentType.getName(), fieldDefinition.getName()), dataFetcher);
        }

        public Builder systemDataFetcher(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher);
            Assert.assertNotNull(coordinates);
            Assert.assertTrue(coordinates.getFieldName().startsWith("__"), "Only __ system fields can be used here", new Object[0]);
            this.systemDataFetcherMap.put(coordinates.getFieldName(), DataFetcherFactories.useDataFetcher(dataFetcher));
            return this;
        }

        public Builder dataFetcher(FieldCoordinates coordinates, DataFetcherFactory<?> dataFetcherFactory) {
            Assert.assertNotNull(dataFetcherFactory);
            this.dataFetcherMap.put(Assert.assertNotNull(coordinates), dataFetcherFactory);
            return this;
        }

        public Builder dataFetcherIfAbsent(FieldCoordinates coordinates, DataFetcher<?> dataFetcher) {
            this.dataFetcherMap.putIfAbsent(Assert.assertNotNull(coordinates), DataFetcherFactories.useDataFetcher(dataFetcher));
            return this;
        }

        public Builder dataFetchers(String parentTypeName, Map<String, DataFetcher> fieldDataFetchers) {
            Assert.assertNotNull(fieldDataFetchers);
            fieldDataFetchers.forEach((fieldName, dataFetcher) -> this.dataFetcher(FieldCoordinates.coordinates(parentTypeName, fieldName), (DataFetcher<?>)dataFetcher));
            return this;
        }

        public Builder dataFetchers(GraphQLCodeRegistry codeRegistry) {
            this.dataFetcherMap.putAll(codeRegistry.dataFetcherMap);
            return this;
        }

        public Builder typeResolver(GraphQLInterfaceType interfaceType, TypeResolver typeResolver) {
            this.typeResolverMap.put(interfaceType.getName(), typeResolver);
            return this;
        }

        public Builder typeResolverIfAbsent(GraphQLInterfaceType interfaceType, TypeResolver typeResolver) {
            this.typeResolverMap.putIfAbsent(interfaceType.getName(), typeResolver);
            return this;
        }

        public Builder typeResolver(GraphQLUnionType unionType, TypeResolver typeResolver) {
            this.typeResolverMap.put(unionType.getName(), typeResolver);
            return this;
        }

        public Builder typeResolverIfAbsent(GraphQLUnionType unionType, TypeResolver typeResolver) {
            this.typeResolverMap.putIfAbsent(unionType.getName(), typeResolver);
            return this;
        }

        public Builder typeResolver(String typeName, TypeResolver typeResolver) {
            this.typeResolverMap.put(Assert.assertValidName(typeName), typeResolver);
            return this;
        }

        public Builder typeResolvers(GraphQLCodeRegistry codeRegistry) {
            this.typeResolverMap.putAll(codeRegistry.typeResolverMap);
            return this;
        }

        public Builder fieldVisibility(GraphqlFieldVisibility fieldVisibility) {
            this.fieldVisibility = Assert.assertNotNull(fieldVisibility);
            return this;
        }

        public Builder clearDataFetchers() {
            this.dataFetcherMap.clear();
            return this;
        }

        public Builder clearTypeResolvers() {
            this.typeResolverMap.clear();
            return this;
        }

        public GraphQLCodeRegistry build() {
            return new GraphQLCodeRegistry(this.dataFetcherMap, this.systemDataFetcherMap, this.typeResolverMap, this.fieldVisibility);
        }
    }
}

