/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetcherFactory;
import graphql.schema.DataFetcherFactoryEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnionType;
import graphql.schema.GraphqlTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@PublicApi
public class GraphQLFieldDefinition
implements GraphQLNamedSchemaElement,
GraphQLDirectiveContainer {
    private final String name;
    private final String description;
    private final GraphQLOutputType originalType;
    private final DataFetcherFactory dataFetcherFactory;
    private final String deprecationReason;
    private final List<GraphQLArgument> arguments;
    private final List<GraphQLDirective> directives;
    private final FieldDefinition definition;
    private GraphQLOutputType replacedType;
    public static final String CHILD_ARGUMENTS = "arguments";
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_TYPE = "type";

    @Internal
    @Deprecated
    public GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcher<?> dataFetcher, List<GraphQLArgument> arguments, String deprecationReason) {
        this(name, description, type, DataFetcherFactories.useDataFetcher(dataFetcher), arguments, deprecationReason, Collections.emptyList(), null);
    }

    @Internal
    @Deprecated
    public GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcherFactory dataFetcherFactory, List<GraphQLArgument> arguments, String deprecationReason, List<GraphQLDirective> directives, FieldDefinition definition) {
        Assert.assertValidName(name);
        Assert.assertNotNull(dataFetcherFactory, "you have to provide a DataFetcher (or DataFetcherFactory)", new Object[0]);
        Assert.assertNotNull(type, "type can't be null", new Object[0]);
        Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
        this.name = name;
        this.description = description;
        this.originalType = type;
        this.dataFetcherFactory = dataFetcherFactory;
        this.arguments = Collections.unmodifiableList(arguments);
        this.directives = directives;
        this.deprecationReason = deprecationReason;
        this.definition = definition;
    }

    void replaceType(GraphQLOutputType type) {
        this.replacedType = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GraphQLOutputType getType() {
        return this.replacedType != null ? this.replacedType : this.originalType;
    }

    DataFetcher getDataFetcher() {
        return this.dataFetcherFactory.get(DataFetcherFactoryEnvironment.newDataFetchingFactoryEnvironment().fieldDefinition(this).build());
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    @Override
    public List<GraphQLDirective> getDirectives() {
        return new ArrayList<GraphQLDirective>(this.directives);
    }

    public List<GraphQLArgument> getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public FieldDefinition getDefinition() {
        return this.definition;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public String toString() {
        return "GraphQLFieldDefinition{name='" + this.name + '\'' + ", type=" + this.getType() + ", arguments=" + this.arguments + ", dataFetcherFactory=" + this.dataFetcherFactory + ", description='" + this.description + '\'' + ", deprecationReason='" + this.deprecationReason + '\'' + ", definition=" + this.definition + '}';
    }

    public GraphQLFieldDefinition transform(Consumer<Builder> builderConsumer) {
        Builder builder = GraphQLFieldDefinition.newFieldDefinition(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLFieldDefinition(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        ArrayList<GraphQLSchemaElement> children = new ArrayList<GraphQLSchemaElement>();
        children.add(this.getType());
        children.addAll(this.arguments);
        children.addAll(this.directives);
        return children;
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().children(CHILD_ARGUMENTS, this.arguments).children(CHILD_DIRECTIVES, this.directives).child(CHILD_TYPE, this.originalType).build();
    }

    @Override
    public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
        return this.transform(builder -> builder.replaceDirectives(newChildren.getChildren(CHILD_DIRECTIVES)).replaceArguments(newChildren.getChildren(CHILD_ARGUMENTS)).type((GraphQLOutputType)newChildren.getChildOrNull(CHILD_TYPE)));
    }

    public static Builder newFieldDefinition(GraphQLFieldDefinition existing) {
        return new Builder(existing);
    }

    public static Builder newFieldDefinition() {
        return new Builder();
    }

    @PublicApi
    public static class Builder
    extends GraphqlTypeBuilder {
        private GraphQLOutputType type;
        private DataFetcherFactory<?> dataFetcherFactory;
        private String deprecationReason;
        private FieldDefinition definition;
        private final Map<String, GraphQLArgument> arguments = new LinkedHashMap<String, GraphQLArgument>();
        private final Map<String, GraphQLDirective> directives = new LinkedHashMap<String, GraphQLDirective>();

        public Builder() {
        }

        public Builder(GraphQLFieldDefinition existing) {
            this.name = existing.getName();
            this.description = existing.getDescription();
            this.type = existing.originalType;
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(existing.getDataFetcher());
            this.deprecationReason = existing.getDeprecationReason();
            this.definition = existing.getDefinition();
            this.arguments.putAll(FpKit.getByName(existing.getArguments(), GraphQLArgument::getName));
            this.directives.putAll(FpKit.getByName(existing.getDirectives(), GraphQLDirective::getName));
        }

        @Override
        public Builder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public Builder description(String description) {
            super.description(description);
            return this;
        }

        @Override
        public Builder comparatorRegistry(GraphqlTypeComparatorRegistry comparatorRegistry) {
            super.comparatorRegistry(comparatorRegistry);
            return this;
        }

        public Builder definition(FieldDefinition definition) {
            this.definition = definition;
            return this;
        }

        public Builder type(GraphQLObjectType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLInterfaceType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLUnionType.Builder builder) {
            return this.type(builder.build());
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        @Deprecated
        public Builder dataFetcher(DataFetcher<?> dataFetcher) {
            Assert.assertNotNull(dataFetcher, "dataFetcher must be not null", new Object[0]);
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(dataFetcher);
            return this;
        }

        @Deprecated
        public Builder dataFetcherFactory(DataFetcherFactory dataFetcherFactory) {
            Assert.assertNotNull(dataFetcherFactory, "dataFetcherFactory must be not null", new Object[0]);
            this.dataFetcherFactory = dataFetcherFactory;
            return this;
        }

        @Deprecated
        public Builder staticValue(Object value) {
            this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(environment -> value);
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            Assert.assertNotNull(argument, "argument can't be null", new Object[0]);
            this.arguments.put(argument.getName(), argument);
            return this;
        }

        public Builder argument(UnaryOperator<GraphQLArgument.Builder> builderFunction) {
            GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
            builder = (GraphQLArgument.Builder)builderFunction.apply(builder);
            return this.argument(builder);
        }

        public Builder argument(GraphQLArgument.Builder builder) {
            this.argument(builder.build());
            return this;
        }

        @Deprecated
        public Builder argument(List<GraphQLArgument> arguments) {
            return this.arguments(arguments);
        }

        public Builder arguments(List<GraphQLArgument> arguments) {
            Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
            for (GraphQLArgument argument : arguments) {
                this.argument(argument);
            }
            return this;
        }

        public Builder replaceArguments(List<GraphQLArgument> arguments) {
            Assert.assertNotNull(arguments, "arguments can't be null", new Object[0]);
            this.arguments.clear();
            for (GraphQLArgument argument : arguments) {
                this.argument(argument);
            }
            return this;
        }

        public Builder clearArguments() {
            this.arguments.clear();
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public Builder withDirectives(GraphQLDirective ... directives) {
            Assert.assertNotNull(directives, "directives can't be null", new Object[0]);
            for (GraphQLDirective directive : directives) {
                this.withDirective(directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective directive) {
            Assert.assertNotNull(directive, "directive can't be null", new Object[0]);
            this.directives.put(directive.getName(), directive);
            return this;
        }

        public Builder replaceDirectives(List<GraphQLDirective> directives) {
            Assert.assertNotNull(directives, "directive can't be null", new Object[0]);
            this.directives.clear();
            for (GraphQLDirective directive : directives) {
                this.directives.put(directive.getName(), directive);
            }
            return this;
        }

        public Builder withDirective(GraphQLDirective.Builder builder) {
            return this.withDirective(builder.build());
        }

        public Builder clearDirectives() {
            this.directives.clear();
            return this;
        }

        public GraphQLFieldDefinition build() {
            if (this.dataFetcherFactory == null) {
                this.dataFetcherFactory = DataFetcherFactories.useDataFetcher(new PropertyDataFetcher(this.name));
            }
            return new GraphQLFieldDefinition(this.name, this.description, this.type, this.dataFetcherFactory, this.sort(this.arguments, GraphQLFieldDefinition.class, GraphQLArgument.class), this.deprecationReason, this.sort(this.directives, GraphQLFieldDefinition.class, GraphQLDirective.class), this.definition);
        }
    }
}

