/*
 * Decompiled with CFR 0.152.
 */
package graphql.util;

import graphql.Assert;
import graphql.Internal;
import graphql.util.DefaultTraverserContext;
import graphql.util.NodeLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TraverserVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;

@Internal
public class TreeParallelTraverser<T> {
    private final Function<? super T, Map<String, ? extends List<T>>> getChildren;
    private final Map<Class<?>, Object> rootVars = new ConcurrentHashMap();
    private final ForkJoinPool forkJoinPool;
    private Object sharedContextData;

    private TreeParallelTraverser(Function<? super T, Map<String, ? extends List<T>>> getChildren, Object sharedContextData, ForkJoinPool forkJoinPool) {
        this.getChildren = Assert.assertNotNull(getChildren);
        this.sharedContextData = sharedContextData;
        this.forkJoinPool = forkJoinPool;
    }

    public static <T> TreeParallelTraverser<T> parallelTraverser(Function<? super T, ? extends List<T>> getChildren) {
        return TreeParallelTraverser.parallelTraverser(getChildren, null, ForkJoinPool.commonPool());
    }

    public static <T> TreeParallelTraverser<T> parallelTraverser(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData) {
        return new TreeParallelTraverser<T>(TreeParallelTraverser.wrapListFunction(getChildren), sharedContextData, ForkJoinPool.commonPool());
    }

    public static <T> TreeParallelTraverser<T> parallelTraverser(Function<? super T, ? extends List<T>> getChildren, Object sharedContextData, ForkJoinPool forkJoinPool) {
        return new TreeParallelTraverser<T>(TreeParallelTraverser.wrapListFunction(getChildren), sharedContextData, forkJoinPool);
    }

    public static <T> TreeParallelTraverser<T> parallelTraverserWithNamedChildren(Function<? super T, Map<String, ? extends List<T>>> getNamedChildren, Object sharedContextData) {
        return new TreeParallelTraverser<T>(getNamedChildren, sharedContextData, ForkJoinPool.commonPool());
    }

    public static <T> TreeParallelTraverser<T> parallelTraverserWithNamedChildren(Function<? super T, Map<String, ? extends List<T>>> getNamedChildren, Object sharedContextData, ForkJoinPool forkJoinPool) {
        return new TreeParallelTraverser<T>(getNamedChildren, sharedContextData, forkJoinPool);
    }

    private static <T> Function<? super T, Map<String, ? extends List<T>>> wrapListFunction(Function<? super T, ? extends List<T>> listFn) {
        return node -> {
            List childs = (List)listFn.apply(node);
            return Collections.singletonMap(null, childs);
        };
    }

    public TreeParallelTraverser<T> rootVars(Map<Class<?>, Object> rootVars) {
        this.rootVars.putAll(Assert.assertNotNull(rootVars));
        return this;
    }

    public TreeParallelTraverser<T> rootVar(Class<?> key, Object value) {
        this.rootVars.put(key, value);
        return this;
    }

    public void traverse(T root, TraverserVisitor<? super T> visitor) {
        this.traverse((Collection<? extends T>)Collections.singleton(root), visitor);
    }

    public void traverse(Collection<? extends T> roots, TraverserVisitor<? super T> visitor) {
        this.traverseImpl(roots, visitor);
    }

    public DefaultTraverserContext<T> newRootContext(Map<Class<?>, Object> vars) {
        return this.newContextImpl(null, null, vars, null, true);
    }

    public void traverseImpl(final Collection<? extends T> roots, final TraverserVisitor<? super T> visitor) {
        Assert.assertNotNull(roots);
        Assert.assertNotNull(visitor);
        final DefaultTraverserContext<T> rootContext = this.newRootContext(this.rootVars);
        this.forkJoinPool.invoke(new CountedCompleter<Void>(){

            @Override
            public void compute() {
                this.setPendingCount(roots.size());
                for (Object root : roots) {
                    DefaultTraverserContext context = TreeParallelTraverser.this.newContext(root, rootContext, null);
                    EnterAction enterAction = new EnterAction(this, context, visitor);
                    enterAction.fork();
                }
                this.tryComplete();
            }
        });
    }

    private List<DefaultTraverserContext> pushAll(TraverserContext<T> traverserContext) {
        LinkedHashMap childrenContextMap = new LinkedHashMap();
        LinkedList<DefaultTraverserContext> contexts = new LinkedList<DefaultTraverserContext>();
        if (!traverserContext.isDeleted()) {
            Map<String, List<T>> childrenMap = this.getChildren.apply(traverserContext.thisNode());
            childrenMap.keySet().forEach(key -> {
                List children = (List)childrenMap.get(key);
                for (int i = children.size() - 1; i >= 0; --i) {
                    Object child = Assert.assertNotNull(children.get(i), "null child for key %s", key);
                    NodeLocation nodeLocation = new NodeLocation((String)key, i);
                    DefaultTraverserContext context = this.newContext(child, traverserContext, nodeLocation);
                    contexts.push(context);
                    childrenContextMap.computeIfAbsent(key, notUsed -> new ArrayList());
                    ((List)childrenContextMap.get(key)).add(0, context);
                }
            });
        }
        return contexts;
    }

    private DefaultTraverserContext<T> newContext(T o, TraverserContext<T> parent, NodeLocation position) {
        return this.newContextImpl(o, parent, new LinkedHashMap(), position, false);
    }

    private DefaultTraverserContext<T> newContextImpl(T curNode, TraverserContext<T> parent, Map<Class<?>, Object> vars, NodeLocation nodeLocation, boolean isRootContext) {
        Assert.assertNotNull(vars);
        return new DefaultTraverserContext<T>(curNode, parent, null, vars, this.sharedContextData, nodeLocation, isRootContext, true);
    }

    private class EnterAction
    extends CountedCompleter {
        private DefaultTraverserContext currentContext;
        private TraverserVisitor<? super T> visitor;

        private EnterAction(CountedCompleter parent, DefaultTraverserContext currentContext, TraverserVisitor<? super T> visitor) {
            super(parent);
            this.currentContext = currentContext;
            this.visitor = visitor;
        }

        @Override
        public void compute() {
            this.currentContext.setPhase(TraverserContext.Phase.ENTER);
            TraversalControl traversalControl = this.visitor.enter(this.currentContext);
            Assert.assertNotNull(traversalControl, "result of enter must not be null", new Object[0]);
            Assert.assertTrue(TraversalControl.QUIT != traversalControl, "can't return QUIT for parallel traversing", new Object[0]);
            if (traversalControl == TraversalControl.ABORT) {
                this.tryComplete();
                return;
            }
            Assert.assertTrue(traversalControl == TraversalControl.CONTINUE);
            List children = TreeParallelTraverser.this.pushAll(this.currentContext);
            if (children.size() == 0) {
                this.tryComplete();
                return;
            }
            this.setPendingCount(children.size() - 1);
            for (int i = 1; i < children.size(); ++i) {
                new EnterAction(this, (DefaultTraverserContext)children.get(i), this.visitor).fork();
            }
            new EnterAction(this, (DefaultTraverserContext)children.get(0), this.visitor).compute();
        }
    }
}

