/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTransport;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverTransportListener;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundVirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.VirtualConnectionFactory;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContextFactory;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;

class SipResolverTcpTransport
implements ConnectionReadyCallback,
TCPReadCompletedCallback,
TCPWriteCompletedCallback,
SipResolverTransport {
    private static final LogMgr c_logger = Log.get(SipResolverTcpTransport.class);
    private static final int READ_TIMEOUT = 1500;
    private static final int WRITE_TIMEOUT = 5000;
    private static final int MAX_READ_TIMEOUT_COUNT = 5;
    private static final int MAX_WRITE_QUEUE_SIZE = 5000;
    private static final int WRITE_STATE_DISCONNECTED = 0;
    private static final int WRITE_STATE_CONNECTING = 1;
    private static final int WRITE_STATE_IDLE = 2;
    private static final int WRITE_STATE_WRITE_ACTIVE = 3;
    private static final int WRITE_STATE_SHUTDOWN = 4;
    private static final int READ_STATE_READING_LENGTH = 0;
    private static final int READ_STATE_READING_BODY = 1;
    private static final int READ_STATE_DISCONNECTED = 2;
    private static final int READ_STATE_SHUTDOWN = 3;
    private static String CHAINNAME = "SipResolver-tcp-outbound";
    private static ChannelFramework _framework;
    private static boolean _channelInitialized;
    private boolean _shutdown = false;
    private Vector<InetSocketAddress> _nameServers = null;
    private Iterator<InetSocketAddress> _nameServerIterator = null;
    private Queue<WsByteBuffer> _requestQueue = new LinkedList<WsByteBuffer>();
    private WsByteBuffer[] _bufferArray = new WsByteBuffer[2];
    private WsByteBuffer _lengthBuffer;
    private int _outstandingRequestCount = 0;
    private int _readTimeoutCount = 0;
    private boolean reConnectAllowed = false;
    private int _connectionFailedCount = -1;
    private int _transportErrorCount = 0;
    private int _ConnectFailuresAllowed = 2;
    private int _TransportErrorsAllowed = 3;
    private TCPWriteRequestContext _writer = null;
    private TCPReadRequestContext _reader = null;
    private SipResolverTransportListener _transportListener = null;
    private OutboundVirtualConnection _outboundVirtualContext;
    private int _writeState = 0;
    private int _readState = 2;
    private InetSocketAddress _currentSocketAddress = null;

    protected static synchronized void initialize(ChannelFramework framework) {
        if (!_channelInitialized) {
            block5: {
                try {
                    framework.addChannel(CHAINNAME, framework.lookupFactory("TCPChannel"), null, 10);
                    String[] channelNameList = new String[]{CHAINNAME};
                    framework.addChain(CHAINNAME, FlowType.OUTBOUND, channelNameList);
                    _framework = framework;
                }
                catch (ChannelException e2) {
                    if (c_logger.isWarnEnabled()) {
                        c_logger.warn("Resolver channel exception during init: " + e2.getMessage());
                    }
                }
                catch (ChainException e1) {
                    if (!c_logger.isWarnEnabled()) break block5;
                    c_logger.warn("Resolver channel exception during init: " + e1.getMessage());
                }
            }
            _channelInitialized = true;
        }
    }

    protected SipResolverTcpTransport(Vector<InetSocketAddress> nameServers, SipResolverTransportListener transportListener, CHFWBundle chfwB) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: constructor: entry: id=" + this.hashCode());
        }
        SipResolverTcpTransport.initialize(chfwB.getFramework());
        this._lengthBuffer = chfwB.getBufferManager().allocate(2);
        this._nameServers = nameServers;
        this._nameServerIterator = this._nameServers.iterator();
        this._transportListener = transportListener;
        this._ConnectFailuresAllowed = this._nameServers.size() * 2;
        this._TransportErrorsAllowed = this._nameServers.size() * 3;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _ConnectFailuresAllowed: " + this._ConnectFailuresAllowed);
            c_logger.traceDebug("SipResolverTcpTransport: contructor: _TransportErrorsAllowed: " + this._TransportErrorsAllowed);
        }
        this.reConnectAllowed = true;
        this._writeState = 0;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: constructor: entry");
        }
    }

    protected synchronized void shutdown() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: shutdown: entry: id=" + this.hashCode());
        }
        this._shutdown = true;
        this._requestQueue.clear();
        this._writeState = 4;
        this._readState = 3;
        if (this._outboundVirtualContext != null) {
            this._outboundVirtualContext.close((Exception)new IOException("SIP Resolver is being shutdown"));
            this._outboundVirtualContext = null;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: shutdown: exit");
        }
    }

    private synchronized void connect() {
        block12: {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverTcpTransport: connect: entry: id=" + this.hashCode());
            }
            if (this._outboundVirtualContext != null) {
                this._outboundVirtualContext.close((Exception)new IOException("Connection not responding properly"));
                this._outboundVirtualContext = null;
            }
            if (this._connectionFailedCount != 0) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport: connect: Find DNS Server in list");
                }
                this._connectionFailedCount = 0;
                if (!this._nameServerIterator.hasNext()) {
                    this._nameServerIterator = this._nameServers.iterator();
                    this._currentSocketAddress = this._nameServerIterator.next();
                } else {
                    this._currentSocketAddress = this._nameServerIterator.next();
                }
            }
            try {
                this._writeState = 1;
                this._readState = 2;
                this._outstandingRequestCount = 0;
                this._readTimeoutCount = 0;
                VirtualConnectionFactory vcf = _framework.getOutboundVCFactory(CHAINNAME);
                this._outboundVirtualContext = (OutboundVirtualConnection)vcf.createConnection();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:connect: SIP Resolver is connecting to: " + this._currentSocketAddress.getHostName() + ":" + this._currentSocketAddress.getPort());
                }
                TCPConnectRequestContext context = TCPConnectRequestContextFactory.getRef().createTCPConnectRequestContext(this._currentSocketAddress.getHostName(), this._currentSocketAddress.getPort(), 10);
                this._reader = ((TCPConnectionContext)this._outboundVirtualContext.getChannelAccessor()).getReadInterface();
                this._writer = ((TCPConnectionContext)this._outboundVirtualContext.getChannelAccessor()).getWriteInterface();
                this._outboundVirtualContext.connectAsynch((Object)context, (ConnectionReadyCallback)this);
            }
            catch (ChannelException e2) {
                if (c_logger.isWarnEnabled()) {
                    c_logger.warn("Resolver channel exception during connect: " + e2.getMessage());
                }
            }
            catch (ChainException e1) {
                if (!c_logger.isWarnEnabled()) break block12;
                c_logger.warn("Resolver chain exception during connect: " + e1.getMessage());
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: connect: exit: id=" + this.hashCode());
        }
    }

    @Override
    public synchronized void writeRequest(WsByteBuffer requestBuffer) throws IOException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: writeRequest: entry: id=" + this.hashCode());
        }
        if (this._shutdown) {
            throw new IllegalStateException("SIP TCP Resolver transport is shutdown.");
        }
        switch (this._writeState) {
            case 4: {
                if (!c_logger.isTraceDebugEnabled()) break;
                c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_SHUTDOWN");
                break;
            }
            case 2: {
                VirtualConnection vc = null;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_IDLE");
                }
                this._lengthBuffer.clear();
                this._lengthBuffer.limit(2);
                this._lengthBuffer.putShort((short)requestBuffer.limit());
                this._lengthBuffer.position(0);
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = requestBuffer;
                this._writer.setBuffers(this._bufferArray);
                ++this._outstandingRequestCount;
                vc = this._writer.write(-1L, (TCPWriteCompletedCallback)this, false, 5000);
                if (vc == null) {
                    this._writeState = 3;
                    break;
                }
                this.complete(vc, this._writer);
                break;
            }
            case 3: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_WRITE_ACTIVE");
                }
                if (this._requestQueue.size() > 5000) {
                    throw new IOException("Maximum write queue size is being exceeded");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 1: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_CONNECTING");
                }
                this._requestQueue.add(requestBuffer);
                break;
            }
            case 0: {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: WRITE_STATE_DISCONNECTED");
                }
                this._requestQueue.add(requestBuffer);
                if (!this.reConnectAllowed) break;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:writeRequest: (re)connect to DNS server");
                }
                this.connect();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: writeRequest: exit");
        }
    }

    public void ready(VirtualConnection vc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: ready: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport:ready: socket is ready");
        }
        if (c_logger.isEventEnabled()) {
            c_logger.info("info.sip.resolver.established.connection", null, this._currentSocketAddress.toString());
        }
        this.reConnectAllowed = false;
        this._connectionFailedCount = 0;
        this._readState = 0;
        this._reader.setJITAllocateSize(2);
        this._reader.setBuffer(null);
        this._reader.read(2L, (TCPReadCompletedCallback)this, true, 1500);
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: ready: exit");
        }
    }

    public void destroy(Exception e2) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: destroy: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: Connection failed to establish: " + e2);
        }
        if (c_logger.isWarnEnabled()) {
            c_logger.warn("warn.sip.resolver.failed.connection", null, this._currentSocketAddress.toString());
        }
        ++this._connectionFailedCount;
        this._writeState = 0;
        this._outboundVirtualContext = null;
        if (this._connectionFailedCount <= this._ConnectFailuresAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: calling transportError - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportListener.transportError(e2, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: calling transportFailed - _connectionFailedCount: " + this._connectionFailedCount);
            }
            this._transportErrorCount = 0;
            this._connectionFailedCount = 0;
            this._transportListener.transportFailed(e2, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: destroy: exit");
        }
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: complete: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: complete: _readState: " + this._readState);
        }
        this._readTimeoutCount = 0;
        this._connectionFailedCount = 0;
        this._transportErrorCount = 0;
        boolean exit = false;
        while (!exit) {
            switch (this._readState) {
                case 0: {
                    this._reader.getBuffer().flip();
                    short length = this._reader.getBuffer().getShort();
                    this._readState = 1;
                    this._reader.setJITAllocateSize((int)length);
                    this._reader.setBuffer(null);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: complete: doing read length of: " + length);
                    }
                    if (this._reader.read((long)length, (TCPReadCompletedCallback)this, false, 1500) != null) break;
                    exit = true;
                    break;
                }
                case 1: {
                    if (this._outstandingRequestCount != 0) {
                        --this._outstandingRequestCount;
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: complete: error: outstandingRequestCount can't decrement past 0");
                    }
                    this._reader.getBuffer().flip();
                    this._transportListener.responseReceived(this._reader.getBuffer());
                    this._readState = 0;
                    this._reader.setJITAllocateSize(2);
                    this._reader.setBuffer(null);
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: complete: doing new read for length");
                    }
                    if (this._reader.read(2L, (TCPReadCompletedCallback)this, false, 1500) != null) break;
                    exit = true;
                    break;
                }
                case 2: 
                case 3: {
                    exit = true;
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: complete: exit: id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rrc, IOException ioe) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: error(vc, read context, exception) ");
        }
        if (!this._shutdown) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: read error: exception " + ioe);
            }
            if (ioe instanceof SocketTimeoutException || ioe instanceof AsyncTimeoutException) {
                if (this._outstandingRequestCount > 0 || this._readTimeoutCount > 5 || this._readState == 1) {
                    if (c_logger.isWarnEnabled() && this._outstandingRequestCount > 0) {
                        c_logger.warn("warn.sip.resolver.server.not.responding", null, this._currentSocketAddress.toString());
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: consecutive read timeouts: " + this._readTimeoutCount);
                    }
                    IOException exception = new IOException("Server stopped responding. Closing connection.");
                    this._outboundVirtualContext.close((Exception)exception);
                    this._outboundVirtualContext = null;
                    ++this._transportErrorCount;
                    if (this._outstandingRequestCount > 0 || this._readState == 1) {
                        ++this._connectionFailedCount;
                    }
                    this._readState = 2;
                    this._writeState = 0;
                    if (this._transportErrorCount < this._TransportErrorsAllowed) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                        }
                        this._transportListener.transportError(ioe, this);
                    } else {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                        }
                        this._transportErrorCount = 0;
                        this._connectionFailedCount = 0;
                        this._transportListener.transportFailed(ioe, this);
                    }
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: incrementing readTimeoutCount: " + this._readTimeoutCount);
                    }
                    ++this._readTimeoutCount;
                    this._reader.read(2L, (TCPReadCompletedCallback)this, true, 1500);
                }
            } else {
                this._readState = 2;
                this._writeState = 0;
                ++this._transportErrorCount;
                ++this._connectionFailedCount;
                if (this._transportErrorCount < this._TransportErrorsAllowed) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
                    }
                    this._transportListener.transportError(ioe, this);
                } else {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
                    }
                    this._transportErrorCount = 0;
                    this._connectionFailedCount = 0;
                    this._transportListener.transportFailed(ioe, this);
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: error(vc, read context, exception)");
        }
    }

    @Override
    public void prepareForReConnect() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: prepareForReConnect");
        }
        this._requestQueue.clear();
        this.reConnectAllowed = true;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: prepareForReConnect");
        }
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext wrc) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: complete: write completed sucessfully: " + this.hashCode());
        }
        this._connectionFailedCount = 0;
        this._transportErrorCount = 0;
        this.drainRequestQueue();
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: complete: write complete id=" + this.hashCode());
        }
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext wrc, IOException ioe) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
        if (this._shutdown) {
            return;
        }
        ++this._transportErrorCount;
        ++this._connectionFailedCount;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipResolverTcpTransport: error: write failed: " + this.hashCode());
        }
        this._writeState = 0;
        if (this._transportErrorCount < this._TransportErrorsAllowed) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: error: calling transportError - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportListener.transportError(ioe, this);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("SipResolverTcpTransport: error: calling transportFailed - _transprtErrorCount: " + this._transportErrorCount);
            }
            this._transportErrorCount = 0;
            this._connectionFailedCount = 0;
            this._transportListener.transportFailed(ioe, this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: error: write error id=" + this.hashCode());
        }
    }

    private synchronized void drainRequestQueue() {
        block5: {
            WsByteBuffer requestBuffer;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "SipResolverTcpTransport: drainRequestQueue: entry: id=" + this.hashCode());
            }
            while ((requestBuffer = this._requestQueue.poll()) != null) {
                this._lengthBuffer.clear();
                this._lengthBuffer.limit(2);
                this._lengthBuffer.putShort((short)requestBuffer.limit());
                this._lengthBuffer.position(0);
                this._bufferArray[0] = this._lengthBuffer;
                this._bufferArray[1] = requestBuffer;
                this._writer.setBuffers(this._bufferArray);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:drainRequestQueue: writing new message, length = " + requestBuffer.limit());
                }
                ++this._outstandingRequestCount;
                VirtualConnection vc = this._writer.write(-1L, (TCPWriteCompletedCallback)this, false, 60000);
                if (vc != null) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("SipResolverTcpTransport:drainRequestQueue: waiting for write to complete");
                }
                this._writeState = 3;
                break block5;
            }
            this._writeState = 2;
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipResolverTcpTransport: drainRequestQueue: exit");
        }
    }

    static {
        _channelInitialized = false;
    }
}

