/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.router.tasks;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import javax.servlet.sip.SipApplicationSession;

public abstract class RoutedTask
implements Queueable {
    protected int _index = -1;
    protected TransactionUserWrapper _transactionUser;
    private boolean _forDispatching = true;
    private TaskDurationMeasurer _sipContainerQueueDuration = null;
    private TaskDurationMeasurer _sipContainerApplicationCodeDuration = null;
    private static final LogMgr c_logger = Log.get(RoutedTask.class);

    public RoutedTask() {
    }

    public RoutedTask(TransactionUserWrapper transactionUser) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "RoutedTask", (Object)transactionUser);
        }
        if (transactionUser != null) {
            SipApplicationSessionImpl appSession = transactionUser.getAppSessionForInternalUse();
            if (appSession != null) {
                this._index = appSession.extractAppSessionCounter();
            } else {
                String sessId = transactionUser.getApplicationId();
                this._index = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
            }
            this._transactionUser = transactionUser;
        }
    }

    public RoutedTask(String sessionId) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "RoutedTask", (Object)sessionId);
        }
        this._index = SipApplicationSessionImpl.extractAppSessionCounter(sessionId);
    }

    @Override
    public int getQueueIndex() {
        return this._index;
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public void run() {
        if (this.getQueueIndex() == -1) {
            throw new RuntimeException("Dispatching error, transaction-user not found!");
        }
        this.doTask();
    }

    public boolean forDispatching() {
        return this._forDispatching;
    }

    public final void setForDispatching(boolean forDispatching) {
        this._forDispatching = forDispatching;
    }

    public void executeOnCurrentThread() {
        this.doTask();
    }

    protected abstract void doTask();

    public abstract String getMethod();

    @Override
    public Object getServiceSynchronizer() {
        if (this._transactionUser == null) {
            return null;
        }
        return this._transactionUser.getServiceSynchronizer();
    }

    @Override
    public TaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    @Override
    public TaskDurationMeasurer getApplicationCodeDuration() {
        return this._sipContainerApplicationCodeDuration;
    }

    @Override
    public String getAppName() {
        if (this._transactionUser != null && this._transactionUser.getSipServletDesc() != null) {
            return this._transactionUser.getSipServletDesc().getSipApp().getAppName();
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        if (this._transactionUser != null && this._transactionUser.getSipServletDesc() != null) {
            return this._transactionUser.getSipServletDesc().getSipApp().getAppIndexForPmi();
        }
        return null;
    }

    @Override
    public void setSipContainerQueueDuration(TaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }

    @Override
    public void setApplicationCodeDuration(TaskDurationMeasurer tm) {
        this._sipContainerApplicationCodeDuration = tm;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._transactionUser != null) {
            return this._transactionUser.getApplicationSession(false);
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        return this._transactionUser;
    }
}

