/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.dar.repository.impl;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.dar.parser.PropertyFileParser;
import com.ibm.ws.sip.dar.repository.ApplicationRepository;
import com.ibm.ws.sip.dar.selector.ApplicationSelector;
import com.ibm.ws.sip.dar.selector.impl.PropertyApplicationSelector;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.sip.ar.SipApplicationRouterInfo;

public class PropertyApplicationRepository
implements ApplicationRepository {
    private static final LogMgr c_logger = Log.get(PropertyApplicationRepository.class);
    private PropertyFileParser propertyFileParser = null;
    private HashMap<String, List<SipApplicationRouterInfo>> methodForApplicationMap = new HashMap();
    private PropertyApplicationSelector applicationSelector = null;

    public PropertyApplicationRepository(File propFile) throws IOException {
        this.propertyFileParser = new PropertyFileParser(propFile, this.methodForApplicationMap);
        this.applicationSelector = new PropertyApplicationSelector(this.methodForApplicationMap);
    }

    @Override
    public void applicationDeployed(List<String> newlyDeployedApplicationNames) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("CWSCT0415I: Default application router, property strategy, property file has been reloaded.");
        }
        this.propertyFileParser.reload();
    }

    @Override
    public void applicationUndeployed(List<String> undeployedApplicationNames) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("CWSCT0415I: Default application router, property strategy, property file has been reloaded.");
        }
        this.propertyFileParser.reload();
    }

    @Override
    public ApplicationSelector getApplicationSelector() {
        return this.applicationSelector;
    }
}

