/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser;

import com.ibm.ws.sip.parser.Separators;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class SipDate
implements Separators {
    public static final String SUN = "Sun";
    public static final String MON = "Mon";
    public static final String TUE = "Tue";
    public static final String WED = "Wed";
    public static final String THU = "Thu";
    public static final String FRI = "Fri";
    public static final String SAT = "Sat";
    public static final String JAN = "Jan";
    public static final String FEB = "Feb";
    public static final String MAR = "Mar";
    public static final String APR = "Apr";
    public static final String MAY = "May";
    public static final String JUN = "Jun";
    public static final String JUL = "Jul";
    public static final String AUG = "Aug";
    public static final String SEP = "Sep";
    public static final String OCT = "Oct";
    public static final String NOV = "Nov";
    public static final String DEC = "Dec";
    public static final String GMT = "GMT";
    String m_sipWeekDay;
    String m_sipMonth;
    int m_dayOfWeek = -1;
    int m_day = -1;
    int m_month = -1;
    int m_year = -1;
    int m_hour = -1;
    int m_minute = -1;
    int m_second = -1;
    Date m_date;
    Calendar m_calendar;

    public SipDate() {
    }

    public SipDate(long time) {
        this(new Date(time));
    }

    public SipDate(Date date) {
        this.m_date = date;
        this.m_calendar = new GregorianCalendar(TimeZone.getTimeZone(GMT), Locale.ENGLISH);
        this.m_calendar.setTime(this.m_date);
        this.m_dayOfWeek = this.m_calendar.get(7);
        switch (this.m_dayOfWeek) {
            case 2: {
                this.m_sipWeekDay = MON;
                break;
            }
            case 3: {
                this.m_sipWeekDay = TUE;
                break;
            }
            case 4: {
                this.m_sipWeekDay = WED;
                break;
            }
            case 5: {
                this.m_sipWeekDay = THU;
                break;
            }
            case 6: {
                this.m_sipWeekDay = FRI;
                break;
            }
            case 7: {
                this.m_sipWeekDay = SAT;
                break;
            }
            case 1: {
                this.m_sipWeekDay = SUN;
                break;
            }
            default: {
                this.m_sipMonth = null;
                throw new RuntimeException("Illegal SipDate day =" + this.m_dayOfWeek);
            }
        }
        this.m_day = this.m_calendar.get(5);
        this.m_month = this.m_calendar.get(2);
        switch (this.m_month) {
            case 0: {
                this.m_sipMonth = JAN;
                break;
            }
            case 1: {
                this.m_sipMonth = FEB;
                break;
            }
            case 2: {
                this.m_sipMonth = MAR;
                break;
            }
            case 3: {
                this.m_sipMonth = APR;
                break;
            }
            case 4: {
                this.m_sipMonth = MAY;
                break;
            }
            case 5: {
                this.m_sipMonth = JUN;
                break;
            }
            case 6: {
                this.m_sipMonth = JUL;
                break;
            }
            case 7: {
                this.m_sipMonth = AUG;
                break;
            }
            case 8: {
                this.m_sipMonth = SEP;
                break;
            }
            case 9: {
                this.m_sipMonth = OCT;
                break;
            }
            case 10: {
                this.m_sipMonth = NOV;
                break;
            }
            case 11: {
                this.m_sipMonth = DEC;
                break;
            }
            default: {
                this.m_sipMonth = null;
                throw new RuntimeException("Illegal SipDate month =" + this.m_month);
            }
        }
        this.m_year = this.m_calendar.get(1);
        this.m_hour = this.m_calendar.get(11);
        this.m_minute = this.m_calendar.get(12);
        this.m_second = this.m_calendar.get(13);
    }

    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    public void writeToCharBuffer(CharsBuffer ret) {
        if (this.m_sipWeekDay != null) {
            ret.append(this.m_sipWeekDay);
            ret.append(',');
            ret.append(' ');
        }
        ret.append(this.m_day < 10 ? "0" : "");
        ret.append(this.m_day);
        ret.append(' ');
        if (this.m_sipMonth != null) {
            ret.append(this.m_sipMonth);
            ret.append(' ');
        }
        ret.append(this.m_year);
        ret.append(' ');
        ret.append(this.m_hour < 10 ? "0" : "");
        ret.append(this.m_hour);
        ret.append(':');
        ret.append(this.m_minute < 10 ? "0" : "");
        ret.append(this.m_minute);
        ret.append(':');
        ret.append(this.m_second < 10 ? "0" : "");
        ret.append(this.m_second);
        ret.append(' ');
        ret.append(GMT);
    }

    public Calendar getCalendar() {
        if (this.m_calendar == null) {
            this.setJavaCal();
        }
        return this.m_calendar;
    }

    public Date getDate() {
        return this.m_date;
    }

    public String getWkday() {
        return this.m_sipWeekDay;
    }

    public String getMonth() {
        return this.m_sipMonth;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public int getSecond() {
        return this.m_second;
    }

    public int getYear() {
        return this.m_year;
    }

    private void setJavaCal() {
    }

    public void setWkday(String w) throws IllegalArgumentException {
        this.m_sipWeekDay = w;
        if (this.m_sipWeekDay.compareToIgnoreCase(MON) == 0) {
            this.m_dayOfWeek = 2;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(TUE) == 0) {
            this.m_dayOfWeek = 3;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(WED) == 0) {
            this.m_dayOfWeek = 4;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(THU) == 0) {
            this.m_dayOfWeek = 5;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(FRI) == 0) {
            this.m_dayOfWeek = 6;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(SAT) == 0) {
            this.m_dayOfWeek = 7;
        } else if (this.m_sipWeekDay.compareToIgnoreCase(SUN) == 0) {
            this.m_dayOfWeek = 1;
        } else {
            throw new IllegalArgumentException("Illegal Week day :" + w);
        }
    }

    public void setDay(int d) throws IllegalArgumentException {
        if (d < 1 || d > 31) {
            throw new IllegalArgumentException("Illegal Day of the month " + new Integer(d).toString());
        }
        this.m_day = d;
    }

    public void setMonth(String m) throws IllegalArgumentException {
        this.m_sipMonth = m;
        if (this.m_sipMonth.compareToIgnoreCase(JAN) == 0) {
            this.m_month = 0;
        } else if (this.m_sipMonth.compareToIgnoreCase(FEB) == 0) {
            this.m_month = 1;
        } else if (this.m_sipMonth.compareToIgnoreCase(MAR) == 0) {
            this.m_month = 2;
        } else if (this.m_sipMonth.compareToIgnoreCase(APR) == 0) {
            this.m_month = 3;
        } else if (this.m_sipMonth.compareToIgnoreCase(MAY) == 0) {
            this.m_month = 4;
        } else if (this.m_sipMonth.compareToIgnoreCase(JUN) == 0) {
            this.m_month = 5;
        } else if (this.m_sipMonth.compareToIgnoreCase(JUL) == 0) {
            this.m_month = 6;
        } else if (this.m_sipMonth.compareToIgnoreCase(AUG) == 0) {
            this.m_month = 7;
        } else if (this.m_sipMonth.compareToIgnoreCase(SEP) == 0) {
            this.m_month = 8;
        } else if (this.m_sipMonth.compareToIgnoreCase(OCT) == 0) {
            this.m_month = 9;
        } else if (this.m_sipMonth.compareToIgnoreCase(NOV) == 0) {
            this.m_month = 10;
        } else if (this.m_sipMonth.compareToIgnoreCase(DEC) == 0) {
            this.m_month = 11;
        } else {
            throw new IllegalArgumentException("Illegal Month :" + m);
        }
    }

    public void setYear(int y) throws IllegalArgumentException {
        if (y < 0) {
            throw new IllegalArgumentException("Illegal year : " + y);
        }
        this.m_calendar = null;
        this.m_year = y;
    }

    public void setHour(int h) throws IllegalArgumentException {
        if (h < 0 || h > 24) {
            throw new IllegalArgumentException("Illegal hour : " + h);
        }
        this.m_calendar = null;
        this.m_hour = h;
    }

    public void setMinute(int m) throws IllegalArgumentException {
        if (m < 0 || m >= 60) {
            throw new IllegalArgumentException("Illegal minute : " + new Integer(m).toString());
        }
        this.m_calendar = null;
        this.m_minute = m;
    }

    public void setSecond(int s) throws IllegalArgumentException {
        if (s < 0 || s >= 60) {
            throw new IllegalArgumentException("Illegal second : " + new Integer(s).toString());
        }
        this.m_calendar = null;
        this.m_second = s;
    }
}

