/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.parser.util;

import com.ibm.ws.sip.parser.util.ObjectPoolListener;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectPool {
    private final AtomicReference[] m_array;
    private final AtomicInteger m_get;
    private final AtomicInteger m_put;
    private final int m_arraySize;
    private final int m_capacity;
    private final Class m_type;
    private ObjectPoolListener m_listener;
    private static final int LIMIT = Integer.MAX_VALUE;

    public ObjectPool(Class type, ObjectPoolListener listener, int arraySize) {
        if (arraySize == -1) {
            arraySize = ApplicationProperties.getProperties().getInt("maxObjectPoolSize");
        }
        if (arraySize < 2) {
            throw new IllegalArgumentException("pool size is too small");
        }
        this.m_array = new AtomicReference[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            this.m_array[i] = new AtomicReference<Object>(null);
        }
        this.m_get = new AtomicInteger(0);
        this.m_put = new AtomicInteger(0);
        this.m_arraySize = arraySize;
        this.m_capacity = arraySize - 1;
        this.m_type = type;
        this.m_listener = listener;
    }

    public ObjectPool(Class type, ObjectPoolListener listener) {
        this(type, listener, -1);
    }

    public ObjectPool(Class type) {
        this(type, null);
    }

    public Object get() {
        int index;
        AtomicReference reference;
        Object object;
        int g;
        do {
            int p = this.m_put.get();
            g = this.m_get.get();
            if (g < p) continue;
            if (p >= Integer.MAX_VALUE) {
                this.m_get.set(0);
                this.m_put.set(0);
            }
            return this.allocate();
        } while (!this.m_get.compareAndSet(g, g + 1) || (object = (reference = this.m_array[index = g % this.m_arraySize]).get()) == null || !reference.compareAndSet(object, null));
        return object;
    }

    public void putBack(Object object) {
        if (this.m_listener != null) {
            this.m_listener.objectReturned(object);
        }
        this.put(object);
    }

    private boolean put(Object object) {
        int index;
        AtomicReference reference;
        int p;
        if (object == null) {
            throw new IllegalArgumentException("returning null object to pool");
        }
        if (!this.m_type.isInstance(object)) {
            throw new IllegalArgumentException("argument type invalid for pool");
        }
        do {
            int g = this.m_get.get();
            p = this.m_put.get();
            if (p >= Integer.MAX_VALUE) {
                return false;
            }
            if (p - g < this.m_capacity) continue;
            return false;
        } while (!this.m_put.compareAndSet(p, p + 1) || !(reference = this.m_array[index = p % this.m_arraySize]).compareAndSet(null, object));
        return true;
    }

    private Object allocate() {
        Object o;
        try {
            o = this.m_type.newInstance();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        if (o == null) {
            throw new RuntimeException("null object created");
        }
        return o;
    }

    public void setObjectPoolListener(ObjectPoolListener listener) {
        this.m_listener = listener;
    }

    public String toString() {
        return "ObjectPool-" + System.identityHashCode(this);
    }
}

