/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.udp;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.parser.util.InetAddressCache;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class UDPSenderThread
extends Thread {
    private static final LogMgr c_logger = Log.get(UDPSenderThread.class);
    private List<MessageContext> m_messages = new ArrayList<MessageContext>();
    private DatagramSocket m_socket;
    private boolean _keepRunning = true;
    private DatagramPacket m_packet = new DatagramPacket(new byte[0], 0);
    private static final String NAME = "UDP Sender";
    private int _qSizeAlertModulus = -1;
    private int _sizePrintedToTrace = 0;
    private int _maxQSize = 500;
    private boolean _isOverloaded = false;
    private long _lastOverLoadMessageTime;

    public UDPSenderThread(DatagramSocket socket) {
        super(NAME);
        this.m_socket = socket;
        this._maxQSize = ApplicationProperties.getProperties().getInt("udpSenderQueueSize");
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "UDPSenderThread", "Max Queue Size: " + this._maxQSize);
        }
        this._qSizeAlertModulus = ApplicationProperties.getProperties().getInt("traceQueueSizeMod");
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "UDPSenderThread", "Queue size alert modulus: " + this._qSizeAlertModulus);
        }
    }

    public synchronized void addToQ(MessageContext messageSendingContext) {
        if (this.m_messages.size() < this._maxQSize) {
            this.m_messages.add(messageSendingContext);
            this.notify();
            this._isOverloaded = false;
        } else {
            messageSendingContext.getSipMessageByteBuffer().reset();
            MessageContext.doneWithContext(messageSendingContext);
            if (!this._isOverloaded) {
                this._isOverloaded = true;
                long cTime = System.currentTimeMillis();
                if (this._lastOverLoadMessageTime + 60000L < cTime && c_logger.isWarnEnabled()) {
                    c_logger.warn("warn.udp.sender.overloaded", "Report.PERFORMANCE", null);
                    this._lastOverLoadMessageTime = cTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SipMessageByteBuffer msg = null;
        MessageContext messageSendingContext = null;
        while (this._keepRunning) {
            UDPSenderThread uDPSenderThread = this;
            synchronized (uDPSenderThread) {
                if (this.m_messages.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e2) {
                        this.logException(e2);
                    }
                } else {
                    messageSendingContext = this.m_messages.remove(0);
                    if (messageSendingContext != null) {
                        msg = messageSendingContext.getSipMessageByteBuffer();
                    }
                }
            }
            if (null == msg) continue;
            this.send(messageSendingContext);
            msg.reset();
            msg = null;
            this.printQueueStatistics();
        }
    }

    private final void printQueueStatistics() {
        if (this._qSizeAlertModulus <= 0) {
            return;
        }
        int qSize = this.m_messages.size();
        if (qSize != this._sizePrintedToTrace && qSize % this._qSizeAlertModulus == 0) {
            this._sizePrintedToTrace = qSize;
            System.out.println("Outbound UDP Queue size: " + qSize);
        }
    }

    private void send(MessageContext messageSendingContext) {
        try {
            SipMessageByteBuffer sipMsg = messageSendingContext.getSipMessageByteBuffer();
            SIPConnection sipConnection = messageSendingContext.getSipConnection();
            String peerHost = sipConnection.getRemoteHost();
            int peerPort = sipConnection.getRemotePort();
            InetAddress ina = "127.0.0.1".equalsIgnoreCase(peerHost) || "localhost".equalsIgnoreCase(peerHost) ? InetAddress.getLocalHost() : InetAddressCache.getByName(peerHost);
            this.m_packet.setData(sipMsg.getBytes(), 0, sipMsg.getMarkedBytesNumber());
            this.m_packet.setAddress(ina);
            this.m_packet.setPort(peerPort);
            this.m_socket.send(this.m_packet);
            messageSendingContext.writeComplete();
        }
        catch (IOException e2) {
            this.logException(e2);
            SIPConnection connection = messageSendingContext.getSipConnection();
            if (connection != null) {
                connection.connectionError(e2);
            }
            messageSendingContext.writeError(e2);
        }
    }

    private void logException(Exception e2) {
        if (c_logger.isErrorEnabled()) {
            c_logger.error("error.exception.stack", "Create", null, (Throwable)e2);
        }
    }

    public synchronized void terminate() {
        this._keepRunning = false;
        this.notify();
    }

    public List<MessageContext> getMessagesFromQ() {
        return this.m_messages;
    }
}

